/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.FutureThreadWithAbortMessage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;

public abstract class FutureServiceBase {
    public static final String JOB_ID_NOT_FOUND = "JobID not found";
    protected Map<String, FutureThreadBase<?>> runningJobs = new HashMap();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.future");

    @PostConstruct
    public void scheduleClearUnclaimedJobs() {
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::clearUnclaimedJobs, 5L, 360L, TimeUnit.MINUTES);
    }

    public synchronized <T> FutureResponse<T> getUpdate(String jobId) throws Exception {
        if (!this.runningJobs.containsKey(jobId)) {
            logger.warn((Object)String.format("JobID not found: %s. Running jobs: %s", jobId, JSON.json(this.runningJobs.keySet())));
            throw ErrorContext.iaef((String)"%s : %s.", (Object)JOB_ID_NOT_FOUND, (Object[])new Object[]{jobId});
        }
        FutureThreadBase<?> ft = this.runningJobs.get(jobId);
        FutureResponse fr = new FutureResponse();
        if (ft.isAlive()) {
            fr.alive = true;
            fr.hasResult = false;
            fr.jobId = jobId;
            fr.progress = ft.getProgressSnapshot();
            fr.log = ft.getLog();
            fr.startTime = ft.creationTime;
            fr.runningTime = (ft.finishTime > 0L ? ft.finishTime : System.currentTimeMillis()) - ft.creationTime;
            fr.fekPort = ft.getUsedFekPort();
        } else {
            fr.alive = false;
            this.runningJobs.remove(jobId);
            fr.aborted = ft.aborted;
            fr.log = ft.getLog();
            if (!ft.aborted && ft.storedException != null) {
                throw ft.storedException;
            }
            if (!ft.aborted && ft.storedError != null) {
                throw ft.storedError;
            }
            fr.hasResult = true;
            fr.result = ft.getResult();
        }
        return fr;
    }

    public synchronized <T> FutureResponse<T> getProgress(String jobId) {
        FutureThreadBase<?> ft = this.runningJobs.get(jobId);
        if (ft == null) {
            return null;
        }
        FutureResponse fr = new FutureResponse();
        fr.alive = ft.isAlive();
        fr.hasResult = !fr.alive;
        fr.jobId = jobId;
        fr.progress = ft.getProgressSnapshot();
        fr.log = ft.getLog();
        fr.payload = ft.getPayload();
        fr.jobDisplayName = fr.payload != null ? fr.payload.displayName : null;
        fr.aborted = ft.aborted;
        fr.startTime = ft.creationTime;
        fr.runningTime = (ft.finishTime > 0L ? ft.finishTime : System.currentTimeMillis()) - ft.creationTime;
        fr.tenantId = ft.tenantId;
        fr.owner = ft.getOwnerIdentifier();
        fr.fekPort = ft.getUsedFekPort();
        return fr;
    }

    public <T> FutureResponse<T> getProgress(FutureThreadBase<?> ft) {
        FutureResponse fr = new FutureResponse();
        fr.alive = ft.isAlive();
        fr.hasResult = !fr.alive;
        fr.jobId = ft.jobId;
        fr.progress = ft.getProgressSnapshot();
        fr.log = ft.getLog();
        fr.jobDisplayName = ft.getPayload().displayName;
        fr.payload = ft.getPayload();
        fr.aborted = ft.aborted;
        fr.startTime = ft.creationTime;
        fr.runningTime = (ft.finishTime > 0L ? ft.finishTime : System.currentTimeMillis()) - ft.creationTime;
        fr.tenantId = ft.tenantId;
        fr.owner = ft.getOwnerIdentifier();
        fr.fekPort = ft.getUsedFekPort();
        return fr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String jobId) {
        FutureThreadBase<?> ft;
        logger.info((Object)("Aborting future: " + jobId));
        FutureServiceBase futureServiceBase = this;
        synchronized (futureServiceBase) {
            ft = this.runningJobs.get(jobId);
        }
        if (ft == null) {
            logger.warn((Object)String.format("JobID not found: %s. Running jobs: %s", jobId, JSON.json(this.runningJobs.keySet())));
            throw new JobNotFoundException("JobID not found: " + jobId);
        }
        ft.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String jobId, AuthCtx user) {
        FutureThreadBase<?> ft;
        logger.info((Object)("Aborting future: " + jobId));
        FutureServiceBase futureServiceBase = this;
        synchronized (futureServiceBase) {
            ft = this.runningJobs.get(jobId);
        }
        if (ft == null) {
            logger.warn((Object)String.format("JobID not found: %s. Running jobs: %s", jobId, JSON.json(this.runningJobs.keySet())));
            throw new IllegalArgumentException("JobID not found: " + jobId);
        }
        if (ft instanceof FutureThreadWithAbortMessage) {
            ((FutureThreadWithAbortMessage)((Object)ft)).abort("Manually aborted by " + user.getIdentifier());
        } else {
            ft.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerAndStartNoWait(FutureThreadBase<T> ft) {
        String jobId = ft.jobId;
        ft.start();
        FutureServiceBase futureServiceBase = this;
        synchronized (futureServiceBase) {
            this.runningJobs.put(jobId, ft);
        }
    }

    public abstract <T> FutureResponse<T> runFuture(FutureThreadBase<T> var1, long var2, TypeToken<? extends FutureResponse<T>> var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FutureResponse<T> safeRunFuture(FutureThreadBase<T> ft, long waitTimeoutInMs) throws Exception {
        ft.start();
        FutureServiceBase futureServiceBase = this;
        synchronized (futureServiceBase) {
            this.runningJobs.put(ft.jobId, ft);
        }
        return this.waitForShortFuture(ft.jobId, waitTimeoutInMs);
    }

    public <T> T runAndWait(FutureThreadBase<T> ft, TypeToken<? extends FutureResponse<T>> resultClass) throws Exception {
        FutureResponse<T> resp = this.runFuture(ft, 0L, resultClass);
        return this.waitForFinalResponse(resp).result;
    }

    private <T> FutureResponse<T> waitForShortFuture(String jobId, long waitTimeoutInMs) throws Exception {
        FutureResponse<T> updated;
        long before = System.currentTimeMillis();
        do {
            updated = this.getUpdate(jobId);
            if (updated.hasResult) {
                return updated;
            }
            if (waitTimeoutInMs == 0L) break;
            DKUtils.unsafeSleep((long)20L);
        } while (System.currentTimeMillis() - before <= waitTimeoutInMs);
        return updated;
    }

    public synchronized FutureThreadBase<?> getThread(String jobId) {
        return this.runningJobs.get(jobId);
    }

    public synchronized FutureLiveliness getLiveliness(String jobId) {
        FutureLiveliness res = new FutureLiveliness();
        if (this.runningJobs.containsKey(jobId)) {
            FutureThreadBase<?> ft = this.runningJobs.get(jobId);
            res.alive = ft.isAlive();
            res.registered = true;
        } else {
            res.alive = false;
            res.registered = false;
        }
        return res;
    }

    public synchronized Map<String, FutureThreadBase<?>> getThreads(String owner) {
        this.clearUnclaimedJobs();
        HashMap threads = Maps.newHashMap();
        for (Map.Entry<String, FutureThreadBase<?>> runningJob : this.runningJobs.entrySet()) {
            if (!runningJob.getValue().getOwnerIdentifier().equals(owner)) continue;
            threads.put(runningJob.getKey(), runningJob.getValue());
        }
        return threads;
    }

    public synchronized Map<String, FutureThreadBase<?>> getAllThreads() {
        this.clearUnclaimedJobs();
        return Maps.newHashMap(this.runningJobs);
    }

    private synchronized void clearUnclaimedJobs() {
        HashSet doneJobs = Sets.newHashSet();
        for (Map.Entry<String, FutureThreadBase<?>> job : this.runningJobs.entrySet()) {
            if (job.getValue().isAlive()) continue;
            Class<?> jobClass = job.getValue().getClass();
            while (jobClass.getSuperclass() != FutureThreadBase.class && jobClass.getSuperclass() != Object.class) {
                jobClass = jobClass.getSuperclass();
            }
            ParameterizedType futureThreadType = (ParameterizedType)jobClass.getGenericSuperclass();
            Type futureThreadResultType = futureThreadType.getActualTypeArguments()[0];
            if (futureThreadResultType == Void.class) {
                doneJobs.add(job.getKey());
                continue;
            }
            long delay = System.currentTimeMillis() - job.getValue().finishTime;
            if (delay <= 21600000L) continue;
            doneJobs.add(job.getKey());
        }
        for (String jobId : doneJobs) {
            FutureThreadBase<?> ft = this.runningJobs.get(jobId);
            if (!ft.aborted && ft.storedException != null) {
                logger.info((Object)("Future " + ft.jobId + " failed"), (Throwable)ft.storedException);
            }
            if (!ft.aborted && ft.storedError != null) {
                logger.info((Object)("Future " + ft.jobId + " badly failed"), (Throwable)ft.storedError);
            }
            ft.getResult();
            this.runningJobs.remove(jobId);
        }
    }

    public <T> FutureResponse<T> waitForFinalResponse(FutureResponse<T> resp) throws Exception {
        if (!resp.hasResult) {
            resp = this.waitForFinalResponse(resp.jobId);
        }
        return resp;
    }

    public abstract <T> FutureResponse<T> waitForFinalResponse(String var1) throws Exception;

    public abstract <T> FutureResponse<T> waitForCompletion(String var1) throws Exception;

    public static FuturePayload buildFuturePayload(FuturePayload remotePayload) {
        FuturePayload fp = new FuturePayload();
        fp.action = "remote";
        fp.withExtra("remotePayload", remotePayload);
        return fp;
    }

    public List<FutureResponse<?>> buildActiveFuturesList(Map<String, FutureThreadBase<?>> threads) {
        ArrayList updates = Lists.newArrayList();
        for (Map.Entry<String, FutureThreadBase<?>> running : threads.entrySet()) {
            FutureResponse progress = this.getProgress(running.getKey());
            if (progress == null) continue;
            updates.add(progress);
        }
        return updates.stream().filter(update -> update.alive).sorted((r0, r1) -> -((int)(r0.startTime - r1.startTime))).collect(Collectors.toList());
    }

    public static class JobNotFoundException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public JobNotFoundException(String msg) {
            super(msg);
        }
    }

    public static class FutureLiveliness {
        public boolean alive;
        public boolean registered;
    }
}

