/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.licensing.LicenseLimitsParser;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.SublicenseEnforcer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class MultiInstancesLicenseStatusComputer {
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.licensing.multiinstance");

    public MultiInstancesLicenseStatusComputer() {
        SpringUtils.getInstance().autowire(this);
    }

    public GlobalLicensingStatus compute(LicenseUsageComputeQuery query) {
        GlobalLicensingStatus ret = new GlobalLicensingStatus();
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        HashMap allProfilesPerUser = new HashMap();
        for (InstanceUsageData instanceUsageData : query.instances) {
            logger.info((Object)("Starting to work for instance " + instanceUsageData.instanceId));
            InstanceLicensingStatus instanceLicensingStatus = new InstanceLicensingStatus();
            instanceLicensingStatus.instanceId = instanceUsageData.instanceId;
            ret.perInstance.add(instanceLicensingStatus);
            instanceLicensingStatus.status = new LimitsStatusComputer.LicenseLimitsStatus();
            LicenseLimitsParser.parseLicensedProfiles(ls, instanceLicensingStatus.status);
            new SublicenseEnforcer(ls.sublicense).restrict(instanceLicensingStatus.status);
            ArrayList<String> userProfilesOnInstance = new ArrayList<String>();
            instanceUsageData.users.stream().forEach(iu -> {
                ArrayList<String> iuProfiles = (ArrayList<String>)allProfilesPerUser.get(iu.login);
                if (iuProfiles == null) {
                    iuProfiles = new ArrayList<String>();
                    allProfilesPerUser.put(iu.login, iuProfiles);
                }
                iuProfiles.add(iu.userProfile);
                userProfilesOnInstance.add(iu.userProfile);
            });
            LimitsStatusComputer lsc = new LimitsStatusComputer();
            instanceLicensingStatus.status.profileLimits = lsc.getLimitsStatus(instanceLicensingStatus.status.licensedProfiles.values(), instanceLicensingStatus.status.fallbackProfile, userProfilesOnInstance, new ArrayList<String>());
            logger.info((Object)("Done to work on instance " + instanceUsageData.instanceId));
        }
        logger.info((Object)"Computing global status");
        ret.globalStatus = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseLimitsParser.parseLicensedProfiles(ls, ret.globalStatus);
        new SublicenseEnforcer(ls.sublicense).restrict(ret.globalStatus);
        ArrayList<String> dedupedGlobalProfiles = new ArrayList<String>();
        for (Map.Entry entry : allProfilesPerUser.entrySet()) {
            String highestProfileForUser = new LimitsStatusComputer().getHighestProfile(ret.globalStatus.licensedProfiles.values(), (Collection)entry.getValue(), ret.globalStatus.fallbackProfile);
            logger.info((Object)("For user " + (String)entry.getKey() + " from source profiles " + JSON.json(entry.getValue()) + " kept profile " + highestProfileForUser));
            dedupedGlobalProfiles.add(highestProfileForUser);
        }
        LimitsStatusComputer limitsStatusComputer = new LimitsStatusComputer();
        ret.globalStatus.profileLimits = limitsStatusComputer.getLimitsStatus(ret.globalStatus.licensedProfiles.values(), ret.globalStatus.fallbackProfile, dedupedGlobalProfiles, new ArrayList<String>());
        return ret;
    }

    public static class GlobalLicensingStatus {
        public List<InstanceLicensingStatus> perInstance = new ArrayList<InstanceLicensingStatus>();
        public LimitsStatusComputer.LicenseLimitsStatus globalStatus;
    }

    public static class LicenseUsageComputeQuery {
        List<InstanceUsageData> instances = new ArrayList<InstanceUsageData>();
    }

    public static class InstanceUsageData {
        String instanceId;
        List<UserAndProfile> users = new ArrayList<UserAndProfile>();
    }

    public static class InstanceLicensingStatus {
        String instanceId;
        LimitsStatusComputer.LicenseLimitsStatus status;
    }

    static class UserAndProfile {
        String login;
        String userProfile;

        UserAndProfile() {
        }
    }
}

