/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.UpgradeRequest;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServletUtils {
    private static final Pattern cookiePattern = Pattern.compile("([^=]+)=([^\\;]*);?\\s?");

    public static Map<String, String> parseCookies(String headerLine) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Matcher matcher = cookiePattern.matcher(headerLine);
        while (matcher.find()) {
            ret.put(matcher.group(1), matcher.group(2));
        }
        return ret;
    }

    public static Map<String, String> parseCookies(HttpServletRequest req) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (req.getCookies() != null) {
            for (Cookie c : req.getCookies()) {
                ret.put(c.getName(), c.getValue());
            }
        }
        return ret;
    }

    public static Map<String, String> parseCookies(UpgradeRequest req) {
        String cookieHeader = req.getHeader("Cookie");
        return ServletUtils.parseCookies(cookieHeader);
    }

    public static ServletContextHandler createServletContext(int maxFormContentSize, String contextPath) {
        ServletContextHandler sch = new ServletContextHandler();
        sch.setDefaultRequestCharacterEncoding("UTF-8");
        sch.setDefaultResponseCharacterEncoding("UTF-8");
        sch.setMaxFormContentSize(maxFormContentSize);
        sch.setContextPath(contextPath);
        return sch;
    }

    public static void addMultiPartElementConfig(ServletHolder sh, File location, int fileSizeThreshold) {
        ServletHolder.Registration registration = sh.getRegistration();
        MultipartConfigElement multipartConfigElement = ServletUtils.getMultipartConfigElement(location, fileSizeThreshold);
        registration.setMultipartConfig(multipartConfigElement);
    }

    public static MultipartConfigElement getMultipartConfigElement(File location, int fileSizeThreshold) {
        String uploadLocation = location.getAbsolutePath();
        return new MultipartConfigElement(uploadLocation, Long.MAX_VALUE, Long.MAX_VALUE, fileSizeThreshold);
    }
}

