/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.springframework.stereotype.Component;

@Component
public class OperatingSystemInformation {
    private final OperatingSystemMXBean operatingSystemMXBean;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.operatingSystemInformation");

    OperatingSystemInformation() {
        try {
            this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get OperatingSystemMXBean, you might be running an unsupported JVM");
        }
    }

    public boolean isLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    public double getSystemCpuLoad() {
        return this.operatingSystemMXBean.getSystemCpuLoad();
    }

    public int getAvailableProcessors() {
        return this.operatingSystemMXBean.getAvailableProcessors();
    }

    public long getTotalMemoryInBytes() {
        return this.operatingSystemMXBean.getTotalPhysicalMemorySize();
    }

    @Nullable
    public Long getAvailableMemoryInKilobytes() {
        List<String> memInfoLines;
        if (!this.isLinux()) {
            logger.trace((Object)"Can only compute available memory on Linux");
            return null;
        }
        try {
            memInfoLines = Files.readAllLines(Path.of("/proc/meminfo", new String[0]));
        }
        catch (IOException e) {
            return null;
        }
        return OperatingSystemInformation.parseMemAvailable(memInfoLines);
    }

    @VisibleForTesting
    static Long parseMemAvailable(List<String> meminfoLines) {
        Pattern pattern = Pattern.compile("^MemAvailable:\\s+(\\d+)\\s+kB$");
        for (String line : meminfoLines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            try {
                return Long.valueOf(matcher.group(1));
            }
            catch (Exception e) {
                logger.traceV((Throwable)e, "Failed to parse MemAvailable from /proc/meminfo: %s", new Object[]{line});
                return null;
            }
        }
        logger.trace((Object)"Didn't find MemAvailable in /proc/meminfo");
        return null;
    }
}

