/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StackUtils {
    private StackUtils() {
    }

    private static Stream<StackTraceElement> getStackStreamFrom(StackTraceElement[] stackTrace, String lastDroppedElementClass, String lastDroppedElementMethod) {
        return Arrays.stream(stackTrace).dropWhile(stackTraceElement -> !stackTraceElement.getClassName().equals(lastDroppedElementClass) || !stackTraceElement.getMethodName().equals(lastDroppedElementMethod)).skip(1L);
    }

    public static List<StackTraceElement> getStackFrom(StackTraceElement[] stackTrace, String lastDroppedElementClass, String lastDroppedElementMethod, int limit) {
        return StackUtils.getStackStreamFrom(stackTrace, lastDroppedElementClass, lastDroppedElementMethod).limit(limit).collect(Collectors.toList());
    }

    public static List<StackTraceElement> getShortStackForDeduplication(StackTraceElement[] stackTrace, String lastDroppedElementClass, String lastDroppedElementMethod, int limit) {
        return StackUtils.getStackStreamFrom(stackTrace, lastDroppedElementClass, lastDroppedElementMethod).filter(stackTraceElement -> stackTraceElement.getClassName().contains("com.dataiku")).limit(limit).collect(Collectors.toList());
    }

    public static String getStringStack(List<StackTraceElement> stack) {
        return stack.stream().map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    public static String getHumanStack(List<StackTraceElement> stack) {
        return stack.stream().map(val -> "      " + String.valueOf(val)).collect(Collectors.joining(System.lineSeparator()));
    }
}

