/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.j3ts.ClassScanner;
import com.dataiku.dip.utils.j3ts.PyFileEmitter;
import com.dataiku.dip.utils.j3ts.PyMappedType;
import com.dataiku.j2py.annotations.PyNullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PyTypeMapper {
    private final ClassScanner classScanner;
    private final Map<Type, PyMappedType> localMappings = new HashMap<Type, PyMappedType>();
    private PyMappedType currentTranslatedVia;
    private int currentTranslatedViaDepth;

    public PyTypeMapper(ClassScanner classScanner) {
        this.classScanner = classScanner;
    }

    public List<PyMappedType> getAllMappedTypes() {
        ArrayList<PyMappedType> out = new ArrayList<PyMappedType>(this.localMappings.values());
        out.sort(Comparator.comparing(mt -> mt.javaType.getTypeName()));
        return out;
    }

    private void inspectType(PyMappedType mt) throws Exception {
        if (mt.inspected) {
            return;
        }
        mt.inspected = true;
        if (mt.javaType instanceof Class) {
            Class clazz = (Class)mt.javaType;
            String javaClassName = clazz.getName();
            if (clazz.isAnonymousClass()) {
                mt.type = PyMappedType.PyType.UNKNOWN;
                mt.problem = clazz.getName();
                return;
            }
            mt.polyJsonMeta = JSON.getPolyJsonMeta((Class)clazz);
            if (CharSequence.class.isAssignableFrom(clazz) || Character.TYPE == clazz || Character.class == clazz) {
                mt.type = PyMappedType.PyType.STRING;
            } else if (Integer.TYPE == clazz || Long.TYPE == clazz || Short.TYPE == clazz || Byte.TYPE == clazz || Integer.class == clazz || Long.class == clazz || Short.class == clazz || Byte.class == clazz) {
                mt.type = PyMappedType.PyType.INT;
            } else if (Double.TYPE == clazz || Float.TYPE == clazz || Double.class == clazz || Float.class == clazz) {
                mt.type = PyMappedType.PyType.FLOAT;
            } else if (Object.class == clazz) {
                mt.type = PyMappedType.PyType.ANY;
                mt.problem = clazz.getName();
            } else if (Boolean.class == clazz || Boolean.TYPE == clazz) {
                mt.type = PyMappedType.PyType.BOOLEAN;
            } else if (mt.javaType == JsonObject.class || Map.class.isAssignableFrom(clazz)) {
                mt.type = PyMappedType.PyType.MAP;
                mt.typeParameters = Lists.newArrayList((Object[])new PyMappedType[]{this.mapType((Type)((Object)String.class)), this.mapType((Type)((Object)JsonElement.class))});
            } else if (mt.javaType == JsonArray.class || Collection.class.isAssignableFrom(clazz)) {
                mt.type = PyMappedType.PyType.LIST;
                mt.typeParameters = Lists.newArrayList((Object[])new PyMappedType[]{this.mapType((Type)((Object)JsonElement.class))});
            } else if (JsonElement.class.isAssignableFrom(clazz)) {
                mt.type = PyMappedType.PyType.ANY;
                mt.problem = clazz.getName();
            } else if (clazz.isArray()) {
                mt.type = PyMappedType.PyType.LIST;
                mt.typeParameters = Lists.newArrayList((Object[])new PyMappedType[]{this.mapType(clazz.getComponentType())});
            } else {
                Type sc;
                Field[] sortedFields;
                String javaNameInPackage;
                mt.setName(clazz.getSimpleName());
                int idx = javaClassName.lastIndexOf(".");
                String string = javaNameInPackage = idx == -1 ? javaClassName : javaClassName.substring(idx + 1);
                if (javaNameInPackage.contains("$")) {
                    String[] parts = StringUtils.split((String)javaNameInPackage, (String)"$");
                    parts = Arrays.copyOf(parts, parts.length - 1);
                    mt.modules.addAll(Arrays.asList(parts));
                }
                String javaPackageName = javaClassName.substring(0, javaClassName.length() - javaNameInPackage.length());
                String pyUnitName = mt.modules.isEmpty() ? mt.getName() : mt.modules.get(0);
                String pyWrapperDir = PyFileEmitter.pascalToSnake(pyUnitName);
                String pyFile = PyFileEmitter.pascalToSnake(mt.getName());
                ClassScanner.RootMapping root = this.classScanner.getRootMappingForClass(clazz);
                RelFile dir = (root != null && root.targetDirectory != null ? root.targetDirectory : RelFile.root()).append(StringUtils.split((String)javaPackageName, (String)"."));
                mt.definitionFileNoExt = dir.append(pyWrapperDir).append(pyFile);
                mt.type = clazz.isEnum() ? PyMappedType.PyType.ENUM : PyMappedType.PyType.CLASS;
                for (Field field2 : sortedFields = (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> mt.polyJsonMeta == null || !Objects.equals(mt.polyJsonMeta.getTypeProperty(), field.getName())).filter(field -> !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic()).sorted(Comparator.comparing(Field::getName).thenComparing(Field::getModifiers)).toArray(Field[]::new)) {
                    boolean isStatic = Modifier.isStatic(field2.getModifiers());
                    if (isStatic || clazz.isEnum()) continue;
                    PyMappedType.MappedField mappedField = new PyMappedType.MappedField();
                    SerializedName serializedName = field2.getAnnotation(SerializedName.class);
                    mappedField.name = serializedName == null ? field2.getName() : serializedName.value();
                    Type fieldType = field2.getGenericType();
                    mappedField.mt = this.mapType(fieldType);
                    boolean bl = mappedField.optional = field2.getAnnotation(Nullable.class) != null || field2.getAnnotation(PyNullable.class) != null;
                    if (mt.typeFields == null) {
                        mt.typeFields = new ArrayList<PyMappedType.MappedField>();
                    }
                    mt.typeFields.add(mappedField);
                }
                if (clazz.isEnum()) {
                    mt.enumValues = Arrays.stream(clazz.getEnumConstants()).map(enumConstant -> {
                        try {
                            PyMappedType.MappedEnumValue enumValue = new PyMappedType.MappedEnumValue();
                            String enumName = ((Enum)enumConstant).name();
                            SerializedName serializedName = clazz.getField(enumName).getAnnotation(SerializedName.class);
                            enumValue.name = serializedName == null ? enumName : serializedName.value();
                            enumValue.value = enumConstant.toString();
                            return enumValue;
                        }
                        catch (NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                    }).collect(Collectors.toList());
                    return;
                }
                mt.type = PyMappedType.PyType.CLASS;
                mt.typeParameters = Arrays.stream(clazz.getTypeParameters()).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                mt.concrete = !Modifier.isAbstract(clazz.getModifiers());
                Class superclass = clazz.getSuperclass();
                if (superclass != null && !superclass.equals(Object.class)) {
                    mt.rawSuperclass = this.mapType(superclass);
                }
                mt.superclass = (sc = clazz.getGenericSuperclass()) != null ? this.mapType(sc) : mt.rawSuperclass;
                if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                    Type[] actualTypeArguments;
                    ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
                    for (Type type : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                        this.mapType(type);
                    }
                }
                mt.hasJavaSubclasses = this.classScanner.hasSubclasses(clazz);
                if (mt.polyJsonMeta != null) {
                    mt.hasPolyJsonAnnotation = mt.polyJsonMeta.getAnnotatedClass() == clazz;
                    mt.polyJsonType = mt.polyJsonMeta.getTypeFromClass(clazz);
                    mt.polyJsonSubclasses = mt.polyJsonMeta.listSubClasses().stream().filter(clazz::isAssignableFrom).sorted(Comparator.comparing(Class::getName)).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                    this.exploreAndGenerateUnionOfSubclasses(mt);
                }
            }
        } else if (mt.javaType instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)mt.javaType).getRawType();
            if (raw instanceof Class) {
                Class rawClass = (Class)raw;
                if (Map.class.isAssignableFrom(rawClass)) {
                    mt.type = PyMappedType.PyType.MAP;
                    mt.typeParameters = Arrays.stream(.Gson.Types.getMapKeyAndValueTypes((Type)mt.javaType, (Class)rawClass)).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                    PyMappedType keyType = mt.typeParameters.get(0);
                    if (keyType.type != PyMappedType.PyType.STRING && keyType.type != PyMappedType.PyType.ENUM && keyType.type != PyMappedType.PyType.INT && keyType.type != PyMappedType.PyType.FLOAT && keyType.type != PyMappedType.PyType.ANY) {
                        mt.typeParameters.set(0, this.mapType((Type)((Object)String.class)));
                        mt.logTranslationIssue("Invalid map key (must be string or enum)");
                    }
                } else if (Collection.class.isAssignableFrom(rawClass)) {
                    mt.type = PyMappedType.PyType.LIST;
                    mt.typeParameters = Lists.newArrayList((Object[])new PyMappedType[]{this.mapType(.Gson.Types.getCollectionElementType((Type)mt.javaType, (Class)rawClass))});
                } else if (rawClass.isArray()) {
                    mt.type = PyMappedType.PyType.LIST;
                    mt.typeParameters = Lists.newArrayList((Object[])new PyMappedType[]{this.mapType(.Gson.Types.getArrayComponentType((Type)mt.javaType))});
                }
            }
            if (mt.type == null) {
                mt.type = PyMappedType.PyType.PARAMETRIZED_TYPE;
                mt.typeParameters = Arrays.stream(((ParameterizedType)mt.javaType).getActualTypeArguments()).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                mt.rawJavaType = this.mapType(raw);
            }
        } else if (mt.javaType instanceof TypeVariable) {
            mt.type = PyMappedType.PyType.TYPE_VARIABLE;
            mt.setName(((TypeVariable)mt.javaType).getName());
        } else if (mt.javaType instanceof GenericArrayType) {
            mt.type = PyMappedType.PyType.LIST;
            mt.typeParameters = Lists.newArrayList((Object[])new PyMappedType[]{this.mapType(.Gson.Types.getArrayComponentType((Type)mt.javaType))});
        }
        if (mt.type == null) {
            mt.type = PyMappedType.PyType.UNKNOWN;
            mt.problem = "No mapping for " + String.valueOf(mt.javaType);
            mt.logTranslationIssue("No mapping");
        }
    }

    public void mapTypeAndGenerateUnion(Type type) throws Exception {
        this.exploreAndGenerateUnionOfSubclasses(this.mapType(type));
    }

    private void exploreAndGenerateUnionOfSubclasses(PyMappedType mt) throws Exception {
        if (!mt.generateUnion && mt.type == PyMappedType.PyType.CLASS) {
            mt.generateUnion = true;
            for (Class<?> subclass : this.classScanner.listSubclasses((Class)mt.javaType)) {
                PyMappedType subMt = this.mapType(subclass);
                if (subMt.type == PyMappedType.PyType.CLASS) {
                    mt.subclasses.add(subMt);
                }
                if (!((Class)mt.javaType).isInterface()) continue;
                subMt.implementedInterfaces.add(mt);
            }
        }
    }

    private PyMappedType mapType(Type type) throws Exception {
        PyMappedType mt;
        Preconditions.checkNotNull((Object)type);
        if (type instanceof WildcardType) {
            Type[] upper = ((WildcardType)type).getUpperBounds();
            type = upper.length > 0 ? upper[0] : JsonElement.class;
        }
        if ((mt = this.localMappings.get(type)) == null) {
            mt = new PyMappedType();
            mt.translatedVia = this.currentTranslatedVia;
            mt.translatedViaDepth = this.currentTranslatedViaDepth++;
            mt.javaType = type;
            this.localMappings.put((Type)type, mt);
            PyMappedType previousTranslatedVia = this.currentTranslatedVia;
            this.currentTranslatedVia = mt;
            this.inspectType(mt);
            --this.currentTranslatedViaDepth;
            this.currentTranslatedVia = previousTranslatedVia;
        }
        if (this.currentTranslatedViaDepth < mt.translatedViaDepth) {
            mt.translatedVia = this.currentTranslatedVia;
            mt.translatedViaDepth = this.currentTranslatedViaDepth;
        }
        return mt;
    }
}

