/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.AICompletionService;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AIShaker
extends AIRecipe {
    public static final String type = "shaker";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        if (this.params.steps.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, "Failed to fully understand what data processing steps we should apply on the dataset");
        }
        return Collections.emptyList();
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) throws Exception {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        SerializedShakerScript serializedShakerScript = new SerializedShakerScript();
        List<ProcessorScriptStep> steps = AICompletionService.getProcessorScriptSteps(recipeGenerationContext.datasetNameToTWRMap.getOrDefault(this.params.input_dataset, null), this.params.steps);
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("AI Generate Recipe failed to generate valid steps. List of steps is empty.");
        }
        serializedShakerScript.steps = steps.stream().map(ScriptStep.class::cast).collect(Collectors.toList());
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)serializedShakerScript);
        return metaCreation;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public List<JsonObject> steps;
    }
}

