/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen;

import com.dataiku.dip.analysis.docgen.handler.AbstractPythonHandler;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.analysis.docgen.transform.PlaceholderResolverService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.NamedLock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.log4j.Logger;

public abstract class DocumentGenerationThread
extends FutureThread<DocumentGenerationResponse> {
    protected final APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
    protected final PlaceholderResolverService placeholderResolverService = (PlaceholderResolverService)SpringUtils.getBean(PlaceholderResolverService.class);
    protected final DocumentGenerationResponse documentGenerationResponse;
    protected final String rootUrl;
    private final InputStream templateInputStream;
    private final FuturePayload futurePayload;
    protected final String projectKey;
    protected String templateUploadId;
    protected File templateFile;
    protected FutureProgress.AutocloseableFutureProgressState percentageProgressState;
    private static final Logger logger = Logger.getLogger((String)"dku.document.generation");

    public DocumentGenerationThread(DSSAuthCtx user, String projectKey, InputStream templateInputStream, String rootUrl, FuturePayload futurePayload) {
        super(user);
        this.projectKey = projectKey;
        this.futurePayload = futurePayload;
        this.templateInputStream = templateInputStream;
        this.rootUrl = rootUrl;
        this.documentGenerationResponse = new DocumentGenerationResponse();
    }

    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    public double getDangerosity() {
        return 0.0;
    }

    public DocumentGenerationResponse getResult() {
        return this.documentGenerationResponse;
    }

    protected abstract String getDocumentGenerationId();

    protected abstract String getDocumentGenerationType();

    protected abstract void renderOutputDocument() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        AutoCloseableLock lock;
        try (FutureProgress.AutocloseableFutureProgressState waiting = FutureProgress.pushAutoCloseableState((String)"Waiting completion of other document generation");){
            String lockName = "document.generation" + this.getDocumentGenerationId();
            lock = NamedLock.acquireInterruptibly((String)lockName);
        }
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)("Generating the " + this.getDocumentGenerationType() + " documentation"), (double)0.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            this.percentageProgressState = state;
            BufferedInputStream bufferedTemplateInputStream = new BufferedInputStream(this.templateInputStream);
            boolean isFileCompatible = MDGFileUtil.checkSignature(bufferedTemplateInputStream);
            if (isFileCompatible) {
                this.documentGenerationResponse.exportId = this.templateUploadId = MDGFileUtil.handleFileUpload(bufferedTemplateInputStream);
                this.templateFile = MDGFileUtil.getUploadedFile(this.templateUploadId);
                this.renderOutputDocument();
            } else {
                String errorTitle = "The uploaded file is not compatible";
                String errorDetails = "Only .docx files are allowed to generate a " + this.getDocumentGenerationType() + " documentation.";
                InfoMessage errorMessage = InfoMessage.fatal((String)errorTitle, (String)errorDetails);
                this.documentGenerationResponse.data.addMessage(errorMessage);
                logger.error((Object)errorMessage.toString());
            }
        }
        finally {
            lock.close();
        }
    }

    public <T> T executePython(AbstractPythonHandler<T> handler) throws Exception {
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> {
            try {
                handler.abort();
            }
            catch (Exception e) {
                logger.warn((Object)("Error white aborting the " + handler.getPhaseName() + " phase."), (Throwable)e);
            }
        });){
            T t = handler.compute();
            return t;
        }
    }
}

