/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen;

import com.dataiku.dip.analysis.docgen.DocumentGenerationThread;
import com.dataiku.dip.analysis.docgen.handler.DocxConditionalExtractHandler;
import com.dataiku.dip.analysis.docgen.handler.DocxRegularExtractHandler;
import com.dataiku.dip.analysis.docgen.handler.DocxRenderHandler;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.docgen.model.PlaceholderNames;
import com.dataiku.dip.analysis.docgen.model.PythonConditionalExtractionCommand;
import com.dataiku.dip.analysis.docgen.model.PythonRegularExtractionCommand;
import com.dataiku.dip.analysis.docgen.model.PythonRenderingCommand;
import com.dataiku.dip.analysis.docgen.model.ResolvedResult;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.hooks.FileExportPostprocessingHookHandler;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.security.DSSAuthCtx;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ModelDocumentGenerationThread
extends DocumentGenerationThread {
    private final FullModelId modelId;

    public ModelDocumentGenerationThread(DSSAuthCtx user, String projectKey, FullModelId modelId, InputStream inputStream, String rootUrl) {
        super(user, projectKey, inputStream, rootUrl, ModelDocumentGenerationThread.buildFuturePayload(modelId));
        this.modelId = modelId;
    }

    @Override
    protected String getDocumentGenerationId() {
        return this.modelId.toString();
    }

    @Override
    protected String getDocumentGenerationType() {
        return "model";
    }

    private static FuturePayload buildFuturePayload(FullModelId modelId) {
        FuturePayload fp = new FuturePayload();
        fp.action = "model-document-generation";
        fp.targets.add(DSSFuturePayloadUtils.forFMI(modelId).withPart("model-document-generation"));
        fp.displayName = "Model document generation";
        return fp;
    }

    protected File extractConditionalPlaceholders() throws Exception {
        PythonConditionalExtractionCommand command = new PythonConditionalExtractionCommand("extract conditional placeholders", this.templateFile.getAbsolutePath());
        DocxConditionalExtractHandler extractConditionalHandler = new DocxConditionalExtractHandler(this.owner, this.modelId, command, this.apiTicketService);
        PlaceholderNames conditionalNames = this.executePython(extractConditionalHandler);
        PlaceholderNames filteredNames = this.placeholderResolverService.removePuppeteerPlaceholders(conditionalNames, this.documentGenerationResponse.data);
        ResolvedResult conditionalResolvedResult = this.placeholderResolverService.resolve(filteredNames, this.rootUrl, this.modelId, this.owner, this.documentGenerationResponse.data);
        return MDGFileUtil.writeOnTemporaryFile(conditionalResolvedResult, this.templateUploadId);
    }

    protected File extractRegularPlaceholders(File resolvedResultFile) throws Exception {
        PythonRegularExtractionCommand extractRegularCommand = new PythonRegularExtractionCommand("extract", this.templateFile.getAbsolutePath(), resolvedResultFile.getAbsolutePath());
        DocxRegularExtractHandler extractHandler = new DocxRegularExtractHandler(this.owner, this.modelId, extractRegularCommand, this.apiTicketService);
        PlaceholderNames regularNames = this.executePython(extractHandler);
        ResolvedResult resolvedResult = this.placeholderResolverService.resolve(regularNames, this.rootUrl, this.modelId, this.owner, this.documentGenerationResponse.data);
        return MDGFileUtil.writeOnTemporaryFile(resolvedResult, this.templateUploadId);
    }

    protected PythonRenderingCommand createPythonRenderingCommand(File resolvedResultFile, File conditionalResolvedResultFile, String absoluteOutputFilepath) {
        return new PythonRenderingCommand("export", this.templateFile.getAbsolutePath(), resolvedResultFile.getAbsolutePath(), conditionalResolvedResultFile.getAbsolutePath(), absoluteOutputFilepath, this.projectKey);
    }

    private String computeOutputFileAbsolutePath() throws DKUSecurityException, IOException {
        this.modelId.checkIdsValidity(this.modelId.getProjectKey());
        String outputFilename = this.placeholderResolverService.getOutputFileName(this.modelId);
        return MDGFileUtil.getTmpExportDirectory(this.templateUploadId) + "/" + outputFilename;
    }

    @Override
    protected void renderOutputDocument() throws Exception {
        this.modelId.checkIdsValidity(this.projectKey);
        File conditionalResolvedResultFile = this.extractConditionalPlaceholders();
        File resolvedResultFile = this.extractRegularPlaceholders(conditionalResolvedResultFile);
        String outputFilepath = this.computeOutputFileAbsolutePath();
        PythonRenderingCommand renderCommand = this.createPythonRenderingCommand(resolvedResultFile, conditionalResolvedResultFile, outputFilepath);
        DocxRenderHandler renderHandler = new DocxRenderHandler(this.owner, this.modelId, renderCommand, this.apiTicketService);
        this.executePython(renderHandler);
        FileExportPostprocessingHookHandler.onPostModelDocumentationExport(this.owner, new File(outputFilepath), this.modelId);
    }
}

