/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringClusterRecipePayloadParams;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelKernel;
import com.dataiku.dip.analysis.ml.prediction.MLSchemaComparator;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.SnowflakeJavaUDFPredictionRecipeSubrunner;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class MLFlowUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.ml");

    public static void checkActiveVersion(SavedModel sm) {
        if (StringUtils.isBlank((String)sm.activeVersion)) {
            throw ErrorContext.iae((String)"No active version in saved model");
        }
        MLFlowUtils.checkVersion(sm, sm.activeVersion);
    }

    public static void checkVersion(SavedModel sm, String versionId) {
        File activeModelFolder = MLPaths.savedModelVersionFolder(sm, versionId);
        if (!activeModelFolder.isDirectory()) {
            throw ErrorContext.iaef((String)"Saved model active version (%s) does not exist", (Object)activeModelFolder, (Object[])new Object[0]);
        }
    }

    public static String getModelVersionToUse(SavedModel sm, String versionIdOverride) {
        if (StringUtils.isNotBlank((String)versionIdOverride)) {
            MLFlowUtils.checkVersion(sm, versionIdOverride);
            return versionIdOverride;
        }
        MLFlowUtils.checkActiveVersion(sm);
        return sm.activeVersion;
    }

    public static boolean hasValidActiveVersion(SavedModel sm) {
        if (StringUtils.isBlank((String)sm.activeVersion)) {
            return false;
        }
        File activeModelFolder = MLPaths.savedModelVersionFolder(sm, sm.activeVersion);
        return activeModelFolder.isDirectory();
    }

    public static FlowSavedModel getSMInput(JobActivity activity) {
        FlowSavedModel fsm = null;
        for (FlowComputable flowComputable : activity.getSubgraph().getSources()) {
            if (flowComputable.getType() != FlowComputable.FCType.SAVED_MODEL) continue;
            fsm = (FlowSavedModel)flowComputable;
            break;
        }
        if (fsm == null) {
            throw ErrorContext.iae((String)"Recipe does not have a model input");
        }
        return fsm;
    }

    public static Schema getSchemaToUseForPreparedScoringInput(ResolvedPreprocessingParams trainParams, Schema schemaUsedForTrain, Schema currentPreparationOutput, boolean skipInputChecks) {
        if (!skipInputChecks) {
            List<InfoMessage> checkRet = MLSchemaComparator.checkForScore(trainParams, currentPreparationOutput);
            if (InfoMessage.anyFatal(checkRet)) {
                throw ErrorContext.iae((String)("Cannot apply the model with the output of preparation on this input (" + InfoMessage.firstFatal(checkRet).message + ")"));
            }
        } else {
            logger.info((Object)"Skipping the checks for the output schema of the recipe.");
        }
        Schema outputSchema = new Schema();
        if (currentPreparationOutput != null) {
            for (SchemaColumn preparedColInScor : currentPreparationOutput.columns) {
                SchemaColumn preparedColInTrain = schemaUsedForTrain.getColumn(preparedColInScor.getName());
                if (preparedColInTrain != null) {
                    outputSchema.columns.add(preparedColInTrain);
                    continue;
                }
                outputSchema.columns.add(preparedColInScor);
            }
        }
        return outputSchema;
    }

    public static Schema getSchemaToUseForPreparedScoringInput(ResolvedPreprocessingParams trainParams, Schema schemaUsedForTrain, Schema currentPreparationOutput) {
        return MLFlowUtils.getSchemaToUseForPreparedScoringInput(trainParams, schemaUsedForTrain, currentPreparationOutput, false);
    }

    public static Schema getInferredPreparationOutputSchema_NT(String contextProjectKey, Dataset inputDataset, SerializedShakerScript script, String outputDatasetType, AuthCtx user) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        return ((AnalysisDataService)SpringUtils.getBean(AnalysisDataService.class)).getInferredSchemaForML_NT(script, contextProjectKey, inputDataset, outputDatasetType, user, ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.JEK);
    }

    public static Pair<ModelPartitionMode, FullModelId> getModelPartitionModeAndFullModelId(JobActivity activity, ResolvedPredictionCoreParams coreParams, FullModelId fmi) throws IOException {
        ModelPartitionMode retModelPartitionMode;
        SerializedRecipe recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
        List<SerializedRecipe.RecipeInput> modelInputs = recipe.getInputsForRole("model");
        SerializedRecipe.RecipeInput inputModel = modelInputs.get(0);
        boolean expectSinglePartitionModel = !inputModel.deps.isEmpty();
        for (SerializedRecipe.SDep modelDep : inputModel.deps) {
            if (modelDep.expectsSinglePartition()) continue;
            expectSinglePartitionModel = false;
            break;
        }
        FullModelId retFMI = fmi;
        if (activity != null && coreParams.isPartitioned()) {
            RunnableSubgraph subgraph = activity.getSubgraph();
            Partition singleModelPartition = null;
            for (FlowComputable flowComputable : subgraph.getSources()) {
                if (flowComputable.getType() != FlowComputable.FCType.SAVED_MODEL) continue;
                List<Partition> modelPartitions = subgraph.getSourcePartitions(flowComputable);
                logger.debugV("Source model with %d partitions", new Object[]{modelPartitions.size()});
                if (modelPartitions.size() != 1) continue;
                singleModelPartition = modelPartitions.get(0);
            }
            if (singleModelPartition == null || singleModelPartition.isNP() || !expectSinglePartitionModel) {
                retModelPartitionMode = ModelPartitionMode.PARTITIONED_DISPATCH;
            } else {
                retFMI = fmi.getModelPartition(singleModelPartition.id());
                retModelPartitionMode = ModelPartitionMode.PARTITIONED_SINGLE;
            }
        } else {
            retModelPartitionMode = ModelPartitionMode.UNPARTITIONED;
        }
        return new Pair((Object)retModelPartitionMode, (Object)retFMI);
    }

    public static RecipeStatusComputer buildClusterRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        return new ClusterRecipeStatusComputer(recipe, payload);
    }

    public static enum ModelPartitionMode {
        UNPARTITIONED,
        PARTITIONED_SINGLE,
        PARTITIONED_DISPATCH;

    }

    private static class ClusterRecipeStatusComputer
    extends RecipeStatusComputer {
        public ClusterRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
            RecipeStatus.BasicRecipeStatus status = new RecipeStatus.BasicRecipeStatus();
            this.performBasicStructureChecks(status, authCtx);
            ClusteringClusterRecipePayloadParams desc = (ClusteringClusterRecipePayloadParams)JSON.parse((String)this.payload, ClusteringClusterRecipePayloadParams.class);
            RecipeEngineStatus engineStatus = null;
            switch (desc.backendType) {
                case H2O: {
                    engineStatus = new RecipeEngineStatus("SPARK", "Spark", "H20", "Sparkling Water", "Sparkling Water");
                    break;
                }
                case MLLIB: {
                    engineStatus = new RecipeEngineStatus("SPARK", "Spark", "MLLIB", "MLLib", "Spark MLLib");
                    break;
                }
                case PY_MEMORY: {
                    engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS in-memory");
                    break;
                }
                case KERAS: {
                    engineStatus = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Streamed", "DSS streamed");
                    break;
                }
                case VERTICA: {
                    engineStatus = new RecipeEngineStatus("SQL", "SQL", "VERTICA_ML", "Vertica ML", "In-database (Vertica ML)");
                }
            }
            status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
            status.selectedEngine = engineStatus;
            JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(activity);
            return status;
        }
    }

    public static class StandaloneEvaluationRecipeStatusComputer
    extends RecipeStatusComputer {
        @Autowired
        private TransactionService transactionService;

        public StandaloneEvaluationRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
            SpringUtils.getInstance().autowire((Object)this);
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) {
            RecipeEngineStatus dss = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Stream", "DSS stream (single-thread)");
            StandaloneEvaluationRecipePayloadParams desc = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)this.payload, StandaloneEvaluationRecipePayloadParams.class);
            ArrayList engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{dss});
            StandaloneEvaluationRecipeStatus status = new StandaloneEvaluationRecipeStatus(engines);
            try {
                this.performBasicStructureChecks(status, authCtx);
                dss.isSelectable = true;
                JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
                this.recipesValidationService.checkTargetsAreWritable(activity);
                status.selectedEngine = this.selectEngine(desc.engineType, engines);
                logger.info((Object)("Selected engine: " + JSON.json((Object)status.selectedEngine)));
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute fast status", e);
                status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute status: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return status;
        }

        private RecipeEngineStatus selectEngine(String userSelected, List<RecipeEngineStatus> statusList) throws IOException {
            String[] preferred;
            if (userSelected != null) {
                RecipeEngineStatus selected = RecipeEngineStatus.getByType(statusList, userSelected);
                Validate.isTrue((boolean)selected.isSelectable);
                return selected;
            }
            for (String type : preferred = new String[]{"DSS"}) {
                RecipeEngineStatus res = RecipeStatus.getEngineByType(statusList, type);
                if (!res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
                return res;
            }
            return RecipeEngineStatus.getByType(statusList, "DSS");
        }
    }

    public static class EvaluationRecipeStatusComputer
    extends RecipeStatusComputer {
        @Autowired
        private SavedModelsDAO smDAO;
        @Autowired
        private TransactionService transactionService;

        public EvaluationRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
            SpringUtils.getInstance().autowire((Object)this);
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) {
            RecipeEngineStatus spark = new RecipeEngineStatus("SPARK", "Spark", "MLLIB", "MLLib", "Spark MLLib");
            RecipeEngineStatus dss = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Stream", "DSS stream (single-thread)");
            ArrayList engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{spark, dss});
            EvaluationRecipeStatus status = new EvaluationRecipeStatus(engines);
            try {
                this.performBasicStructureChecks(status, authCtx);
                AnyLoc modelLoc = AnyLoc.resolveSmart(this.recipe.projectKey, this.recipe.getInputsForRole((String)"model").get((int)0).ref);
                SavedModel sm = (SavedModel)this.smDAO.getMandatory(modelLoc);
                if (sm.miniTask.backendType.isSparkBased()) {
                    spark.isSelectable = true;
                } else {
                    dss.isSelectable = true;
                }
                if (!this.recipe.getOutputsForRole("evaluationStore").isEmpty() && spark.isSelectable) {
                    spark.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                    spark.statusMessage = "Cannot write to model evaluation stores";
                }
                JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
                this.recipesValidationService.checkTargetsAreWritable(activity);
                status.selectedEngine = sm.miniTask.backendType.isSparkBased() ? spark : dss;
                logger.info((Object)("Selected engine: " + JSON.json((Object)status.selectedEngine)));
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute fast status", e);
                status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute status: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return status;
        }
    }

    private static class StandaloneEvaluationRecipeStatus
    extends RecipeStatus.BasicRecipeStatus {
        public StandaloneEvaluationRecipeStatus(List<RecipeEngineStatus> engines) {
            this.engines = engines;
        }
    }

    private static class EvaluationRecipeStatus
    extends RecipeStatus.BasicRecipeStatus {
        public EvaluationRecipeStatus(List<RecipeEngineStatus> engines) {
            this.engines = engines;
        }
    }

    public static class ClusteringScoringRecipeStatusComputer
    extends RecipeStatusComputer {
        @Autowired
        private SavedModelsDAO smDAO;
        @Autowired
        private TransactionService transactionService;

        public ClusteringScoringRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
            SpringUtils.getInstance().autowire((Object)this);
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) {
            RecipeStatus.BasicRecipeStatus status = new RecipeStatus.BasicRecipeStatus();
            try {
                this.performBasicStructureChecks(status, authCtx);
                AnyLoc modelLoc = AnyLoc.resolveSmart(this.recipe.projectKey, this.recipe.getInputsForRole((String)"model").get((int)0).ref);
                SavedModel sm = (SavedModel)this.smDAO.getMandatory(modelLoc);
                RecipeEngineStatus engineStatus = null;
                switch (sm.miniTask.backendType) {
                    case H2O: {
                        engineStatus = new RecipeEngineStatus("SPARK", "Spark", "H20", "Sparkling Water", "Sparkling Water");
                        break;
                    }
                    case MLLIB: {
                        engineStatus = new RecipeEngineStatus("SPARK", "Spark", "MLLIB", "MLLib", "Spark MLLib");
                        break;
                    }
                    case PY_MEMORY: {
                        engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS in-memory");
                        break;
                    }
                    case KERAS: {
                        engineStatus = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Streamed", "DSS streamed");
                        break;
                    }
                    case VERTICA: {
                        engineStatus = new RecipeEngineStatus("SQL", "SQL", "VERTICA_ML", "Vertica ML", "In-database (Vertica ML)");
                    }
                }
                status.selectedEngine = engineStatus;
                status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
                JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
                this.recipesValidationService.checkTargetsAreWritable(activity);
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute fast status", e);
                status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute status: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return status;
        }
    }

    private static class PredictionScoringRecipeStatus
    extends RecipeStatus.BasicRecipeStatus {
        public PredictionScoringRecipeStatus(List<RecipeEngineStatus> engines) {
            this.engines = engines;
        }
    }

    public static class PredictionScoringRecipeStatusComputer
    extends RecipeStatusComputer {
        @Autowired
        private SavedModelsDAO smDAO;
        @Autowired
        private DatasetsDAO datasetsDAO;

        public PredictionScoringRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
            SpringUtils.getInstance().autowire((Object)this);
        }

        public boolean isJavaCompatible() throws IOException {
            AnyLoc modelLoc = AnyLoc.resolveSmart(this.recipe.projectKey, this.recipe.getInputsForRole((String)"model").get((int)0).ref);
            SavedModel sm = (SavedModel)this.smDAO.getMandatory(modelLoc);
            FullModelId fmi = new FullModelId(sm.projectKey, sm.id, sm.activeVersion);
            ClassicalPredictionModelDetails details = PredictionResultsReader.makeDetails(fmi);
            return details.getJavaScoreCompatibility().compatible;
        }

        private void setSQLCompatibility(AuthCtx authCtx, FullModelId fmi, ClassicalPredictionModelDetails details, SerializedDataset inputDataset, RecipeEngineStatus status) throws IOException {
            if (!DatasetInspector.isSQL(inputDataset)) {
                status.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                status.statusMessage = "Input is not a SQL dataset";
                status.isSelectable = false;
                return;
            }
            File scriptFile = fmi.getModelFile("script.json");
            if (scriptFile.exists()) {
                SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)scriptFile, SerializedShakerScript.class);
                if (!script.steps.isEmpty()) {
                    status.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                    status.statusMessage = "Model has a script";
                    status.isSelectable = false;
                    return;
                }
            }
            if ("Snowflake".equals(inputDataset.type)) {
                try {
                    String connectionName = inputDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).connection;
                    DSSConnection conn = ConnectionsDAO.get().getConnection(authCtx, connectionName);
                    if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF((AbstractSQLConnection)conn) && SnowflakeJavaUDFPredictionRecipeSubrunner.isModelSupported(fmi)) {
                        status.variant = "IN_SNOWFLAKE";
                        status.variantLabel = "In Snowflake";
                        status.label = "In Database (Snowflake with Java UDF)";
                        CompatibilityWithReason snowflakeCompatibility = details.getSnowflakeWithJavaUdfCompatibility();
                        if (snowflakeCompatibility.compatible) {
                            status.isSelectable = true;
                        } else {
                            status.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                            status.statusMessage = snowflakeCompatibility.reason;
                            status.isSelectable = false;
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not check Snowflake compatibility", (Throwable)e);
                }
            }
            if (!details.getSQLCompatibility().compatible) {
                status.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                status.statusMessage = "Algorithm or preprocessing cannot be translated to SQL: " + details.getSQLCompatibility().reason;
                status.isSelectable = false;
                return;
            }
            status.isSelectable = true;
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
            RecipeEngineStatus spark = new RecipeEngineStatus("SPARK", "Spark", "SPARK_NATIVE", "Spark Native", "Spark (distributed)");
            RecipeEngineStatus dss = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Stream", "DSS stream (single-thread)");
            RecipeEngineStatus sql = new RecipeEngineStatus("SQL", "SQL", "IN_DB", "In Database", "In-database (SQL)");
            TabularPredictionScoringRecipePayloadParams desc = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)this.payload, TabularPredictionScoringRecipePayloadParams.class);
            ArrayList engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{spark, dss, sql});
            PredictionScoringRecipeStatus status = new PredictionScoringRecipeStatus(engines);
            SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, this.recipe.projectKey).getSparkSettings();
            boolean sparkEnabled = sparkSettings.sparkEnabled;
            try {
                this.performBasicStructureChecks(status, authCtx);
                AnyLoc modelLoc = AnyLoc.resolveSmart(this.recipe.projectKey, this.recipe.getInputsForRole((String)"model").get((int)0).ref);
                SavedModel sm = (SavedModel)this.smDAO.getMandatory(modelLoc);
                FullModelId fmi = new FullModelId(sm.projectKey, sm.id, sm.activeVersion);
                switch (sm.savedModelType.savedModelHandlingType) {
                    case INTERNAL: {
                        switch (sm.miniTask.backendType) {
                            case VERTICA: {
                                sql.isSelectable = true;
                                sql.variant = "VERTICA_ML";
                                sql.variantLabel = "Vertica ML";
                                break;
                            }
                            case DEEP_HUB: {
                                dss.isSelectable = true;
                                break;
                            }
                            default: {
                                PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
                                if (details instanceof TimeseriesForecastingModelDetails || details instanceof CausalPredictionModelDetails) {
                                    dss.isSelectable = true;
                                    break;
                                }
                                if (details instanceof ClassicalPredictionModelDetails) {
                                    CompatibilityWithReason javaCompatibility = ((ClassicalPredictionModelDetails)details).getJavaScoreCompatibility();
                                    if (sm.miniTask.backendType.isSparkBased()) {
                                        spark.isSelectable = true;
                                        dss.isSelectable = javaCompatibility.compatible;
                                        if (!dss.isSelectable) {
                                            dss.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                                            dss.statusMessage = javaCompatibility.reason;
                                        }
                                    } else {
                                        dss.isSelectable = true;
                                        if (javaCompatibility.compatible && sparkEnabled) {
                                            spark.isSelectable = true;
                                        }
                                    }
                                    DatasetLocUtils.DatasetLoc dsLoc = DatasetLocUtils.resolveSmart(this.recipe.projectKey, this.recipe.getSingleInput((String)"main").ref);
                                    SerializedDataset inputDataset = (SerializedDataset)this.datasetsDAO.getMandatory(dsLoc);
                                    this.setSQLCompatibility(authCtx, fmi, (ClassicalPredictionModelDetails)details, inputDataset, sql);
                                    break;
                                }
                                throw ErrorContext.iae((String)("Invalid model details type: " + details.getClass().getSimpleName()));
                            }
                        }
                        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                        this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
                        this.recipesValidationService.checkTargetsAreWritable(activity);
                        status.selectedEngine = this.selectEngine(desc.engineType, engines, sm.miniTask.backendType);
                        break;
                    }
                    case EXTERNAL_MLFLOW: {
                        if (sm.savedModelType == SavedModel.SavedModelType.MLFLOW_PYFUNC) {
                            status.selectedEngine = new RecipeEngineStatus("DSS", InteractiveModelKernel.KernelType.MLFLOW_KERNEL_TYPE.name, "DSS", InteractiveModelKernel.KernelType.MLFLOW_KERNEL_TYPE.name, InteractiveModelKernel.KernelType.MLFLOW_KERNEL_TYPE.name);
                            break;
                        }
                        if (sm.savedModelType != SavedModel.SavedModelType.PROXY_MODEL) break;
                        status.selectedEngine = new RecipeEngineStatus("DSS", InteractiveModelKernel.KernelType.PROXY_MODEL_KERNEL_TYPE.name, "DSS", InteractiveModelKernel.KernelType.PROXY_MODEL_KERNEL_TYPE.name, InteractiveModelKernel.KernelType.PROXY_MODEL_KERNEL_TYPE.name);
                        break;
                    }
                    case PYTHON_AGENT: 
                    case PLUGIN_AGENT: 
                    case TOOLS_USING_AGENT: {
                        throw new IllegalArgumentException("Agents are not supported in scoring recipe");
                    }
                    case LLM_GENERIC: {
                        throw new IllegalArgumentException("Fine-tuned LLMs are not supported in scoring recipe");
                    }
                    case RETRIEVAL_AUGMENTED_LLM: {
                        throw new IllegalArgumentException("Augmented LLMs are not supported in scoring recipe");
                    }
                }
                logger.info((Object)("Selected engine: " + JSON.json((Object)status.selectedEngine)));
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute fast status", e);
                status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute status: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return status;
        }

        private RecipeEngineStatus selectEngine(String userSelected, List<RecipeEngineStatus> statusList, MLTask.BackendType backendType) throws IOException {
            String[] preferred;
            if (userSelected != null) {
                RecipeEngineStatus selected = RecipeEngineStatus.getByType(statusList, userSelected);
                if (!selected.isSelectable) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, String.format("Current engine \"%s\" cannot be used", userSelected));
                }
                return selected;
            }
            if (backendType.isSparkBased()) {
                for (RecipeEngineStatus res : statusList) {
                    if (!Objects.equals(res.type, "SPARK")) continue;
                    return res;
                }
            }
            for (String type : preferred = new String[]{"DSS", "SQL", "SPARK"}) {
                RecipeEngineStatus res = RecipeStatus.getEngineByType(statusList, type);
                if (!res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
                return res;
            }
            return RecipeEngineStatus.getByType(statusList, "DSS");
        }

        public PredictionScoringRecipeScorability getScorability_T(AuthCtx authCtx, JobActivity activity) throws IOException, DKUSecurityException {
            return this.getScorability_T(authCtx, activity, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PredictionScoringRecipeScorability getScorability_T(AuthCtx authCtx, JobActivity activity, String versionIdOverride) throws IOException, DKUSecurityException {
            PredictionScoringRecipeScorability scorability = new PredictionScoringRecipeScorability();
            List<SerializedRecipe.RecipeInput> modelInputs = this.recipe.getInputsForRole("model");
            if (modelInputs.isEmpty()) {
                return scorability;
            }
            scorability.model = (SavedModel)this.smDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.projectKey, modelInputs.get((int)0).ref));
            String versionId = MLFlowUtils.getModelVersionToUse(scorability.model, versionIdOverride);
            scorability.activeModelFolder = MLPaths.savedModelVersionFolder(scorability.model, versionId);
            FullModelId fmiGlobal = new FullModelId(scorability.model.projectKey, scorability.model.id, versionId);
            String inputDatasetSmartRef = this.recipe.getInputsForRole((String)"main").get((int)0).ref;
            AnyLoc inputDatasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.projectKey, inputDatasetSmartRef);
            SerializedDataset inputSerializedDataset = (SerializedDataset)this.datasetsDAO.getMandatory(inputDatasetLoc);
            scorability.inputDataset = Dataset.fromSerialized(inputDatasetLoc.getFullName(), inputSerializedDataset);
            List<SerializedRecipe.RecipeOutput> mainOutputs = this.recipe.getOutputsForRole("main");
            String outputDatasetType = inputSerializedDataset.type;
            if (mainOutputs.size() > 0) {
                String outputDatasetSmartRef = mainOutputs.get((int)0).ref;
                AnyLoc outputDatasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.projectKey, outputDatasetSmartRef);
                SerializedDataset outputSerializedDataset = (SerializedDataset)this.datasetsDAO.getMandatory(outputDatasetLoc);
                scorability.outputDataset = Dataset.fromSerialized(outputDatasetLoc.getFullName(), outputSerializedDataset);
                outputDatasetType = scorability.outputDataset.getType();
            }
            switch (scorability.model.savedModelType.savedModelHandlingType) {
                case INTERNAL: {
                    boolean hasPipelineMetaFile;
                    ResolvedClassicalPredictionCoreParams coreParams = (ResolvedClassicalPredictionCoreParams)JSON.parseFile((File)new File(scorability.activeModelFolder.getAbsoluteFile(), "core_params.json"), ResolvedClassicalPredictionCoreParams.class);
                    Pair<ModelPartitionMode, FullModelId> modelPartitionModeFullModelIdPair = MLFlowUtils.getModelPartitionModeAndFullModelId(activity, coreParams, fmiGlobal);
                    scorability.fmi = (FullModelId)modelPartitionModeFullModelIdPair.second;
                    if (scorability.fmi.isModelPartition()) {
                        scorability.activeModelFolder = fmiGlobal.getPartitionModelFolder(scorability.fmi.getPartitionName());
                    }
                    scorability.modelPartitionMode = (ModelPartitionMode)((Object)modelPartitionModeFullModelIdPair.first);
                    logger.debugV("Model partition mode: %s", new Object[]{scorability.modelPartitionMode});
                    ResolvedClassicalPredictionPreprocessingParams rppp = (ResolvedClassicalPredictionPreprocessingParams)JSON.parseFile((File)new File(scorability.activeModelFolder.getAbsoluteFile(), "rpreprocessing_params.json"), ResolvedClassicalPredictionPreprocessingParams.class);
                    PreTrainPredictionModelingParams rpmp = (PreTrainPredictionModelingParams)JSON.parseFile((File)new File(scorability.activeModelFolder.getAbsoluteFile(), "rmodeling_params.json"), PreTrainPredictionModelingParams.class);
                    ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).stashTheSingleTransaction();
                    try {
                        SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)new File(scorability.activeModelFolder, "script.json"), SerializedShakerScript.class);
                        script.contextProjectKey = scorability.model.projectKey;
                        scorability.inferredPreparedSchema = MLFlowUtils.getInferredPreparationOutputSchema_NT(scorability.model.projectKey, scorability.inputDataset, script, outputDatasetType, authCtx);
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Scoring recipe not pipelineable: cannot infer schema from input dataset '%s'", new Object[]{inputDatasetLoc.getFullName()});
                        PredictionScoringRecipeScorability predictionScoringRecipeScorability = scorability;
                        return predictionScoringRecipeScorability;
                    }
                    finally {
                        ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).unstashTheSingleTransaction();
                    }
                    if (scorability.modelPartitionMode == ModelPartitionMode.PARTITIONED_DISPATCH) {
                        for (String dimension : coreParams.partitionedModel.dimensionNames) {
                            if (scorability.inferredPreparedSchema.getColumn(dimension) != null) continue;
                            logger.warnV("Dispatch partitioning but input dataset lacks column " + dimension, new Object[0]);
                            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_PARTITION_DISPATCH_NO_DATA, "Dispatch partitioning but input dataset lacks column " + dimension);
                        }
                    }
                    scorability.backendType = rpmp.algorithm.backendType;
                    if (!PredictionRecipesMeta.SCORING_META.getType().equals(this.recipe.getType())) {
                        return scorability;
                    }
                    scorability.isJavaCompatible = true;
                    if (!rpmp.algorithm.meta.isJavaCompatible(coreParams)) {
                        scorability.isJavaCompatible = false;
                        logger.debug((Object)"Algorithm is not compatible with Java scoring");
                    }
                    CompatibilityWithReason rpppJavaCompatibility = rppp.getJavaCompatibility(scorability.backendType);
                    if (!rpppJavaCompatibility.compatible) {
                        scorability.isJavaCompatible = false;
                        logger.debug((Object)("Preprocessing is not compatible with Java scoring : " + rpppJavaCompatibility.reason));
                    }
                    scorability.isSqlCompatible = true;
                    if (!rpmp.algorithm.meta.isSQLCompatible(coreParams)) {
                        scorability.isSqlCompatible = false;
                        logger.debug((Object)"Algorithm is not compatible with SQL scoring");
                    }
                    CompatibilityWithReason rpppSQLCompatility = rppp.getSQLCompatibility(scorability.backendType, coreParams.calibration);
                    if (!rpppSQLCompatility.compatible) {
                        scorability.isSqlCompatible = false;
                        logger.debug((Object)("Preprocessing is not compatible with SQL scoring : " + rpppSQLCompatility.reason));
                    }
                    if (hasPipelineMetaFile = new File(scorability.activeModelFolder.getAbsoluteFile(), "dss_pipeline_meta.json").isFile()) break;
                    logger.debug((Object)"Do not have a pipeline meta file, not Java nor SQL compatible");
                    scorability.isJavaCompatible = false;
                    scorability.isSqlCompatible = false;
                    break;
                }
                case EXTERNAL_MLFLOW: {
                    scorability.fmi = fmiGlobal;
                    break;
                }
                case PYTHON_AGENT: 
                case PLUGIN_AGENT: 
                case TOOLS_USING_AGENT: {
                    throw new IllegalArgumentException("Agents are not supported in scoring recipe");
                }
                case LLM_GENERIC: {
                    throw new IllegalArgumentException("Fine-tuned LLMs are not supported in scoring recipe");
                }
                case RETRIEVAL_AUGMENTED_LLM: {
                    throw new IllegalArgumentException("Augmented LLMs are not supported in scoring recipe");
                }
            }
            scorability.engineToUse = this.fastStatusIgnorePartitions(authCtx).getSelectedEngineBase();
            if (scorability.engineToUse == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Current engine cannot be used");
            }
            scorability.desc = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)this.payload, TabularPredictionScoringRecipePayloadParams.class);
            if ("SPARK".equals(scorability.engineToUse.type)) {
                if (scorability.backendType.isSparkBased()) {
                    if (!scorability.desc.forceOriginalEngine && scorability.isJavaCompatible) {
                        scorability.isSparkJava = true;
                    }
                } else if (scorability.isJavaCompatible) {
                    scorability.isSparkJava = true;
                }
            }
            return scorability;
        }
    }

    public static class PredictionScoringRecipeScorability {
        public boolean isJavaCompatible;
        public boolean isSparkJava;
        public Dataset inputDataset;
        public Dataset outputDataset;
        public SavedModel model;
        public File activeModelFolder;
        public TabularPredictionScoringRecipePayloadParams desc;
        public RecipeEngineStatus engineToUse;
        public MLTask.BackendType backendType;
        public ModelPartitionMode modelPartitionMode;
        public FullModelId fmi;
        public boolean isSqlCompatible;
        public Schema inferredPreparedSchema;
    }

    public static class ClusteringTrainingRecipeStatusComputer
    extends RecipeStatusComputer {
        private SavedModelsCRUDService service = (SavedModelsCRUDService)SpringUtils.getBean(SavedModelsCRUDService.class);

        public ClusteringTrainingRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
            RecipeStatus.BasicRecipeStatus status = new RecipeStatus.BasicRecipeStatus();
            this.performBasicStructureChecks(status, authCtx);
            try {
                SavedModel sm = this.service.getMandatory(this.recipe.projectKey, this.recipe.getSingleOutput((String)"main").ref);
                RecipeEngineStatus engineStatus = null;
                switch (sm.miniTask.backendType) {
                    case H2O: {
                        engineStatus = new RecipeEngineStatus("SPARK", "Spark", "H20", "Sparkling Water", "Sparkling Water");
                        break;
                    }
                    case MLLIB: {
                        engineStatus = new RecipeEngineStatus("SPARK", "Spark", "MLLIB", "MLLib", "Spark MLLib");
                        break;
                    }
                    case PY_MEMORY: {
                        engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS in-memory");
                        break;
                    }
                    case KERAS: {
                        engineStatus = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Streamed", "DSS streamed");
                        break;
                    }
                    case VERTICA: {
                        engineStatus = new RecipeEngineStatus("SQL", "SQL", "VERTICA_ML", "Vertica ML", "In-database (Vertica ML)");
                    }
                }
                status.selectedEngine = engineStatus;
                status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
                JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
                this.recipesValidationService.checkTargetsAreWritable(activity);
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute fast status", e);
                status.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute status: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return status;
        }
    }

    public static class PredictionTrainingRecipeStatusComputer
    extends RecipeStatusComputer {
        @Autowired
        private SavedModelsCRUDService service;

        public PredictionTrainingRecipeStatusComputer(SerializedRecipe recipe, String payload) {
            super(recipe, payload);
        }

        @Override
        public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
                this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(ContainerRecipeParams.class), ret.selectedEngine);
                RecipeStatus recipeStatus = ret;
                return recipeStatus;
            }
        }

        @Override
        public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
            RecipeStatus.BasicRecipeStatus status = new RecipeStatus.BasicRecipeStatus();
            this.performBasicStructureChecks(status, authCtx);
            SavedModel sm = this.service.getMandatory(this.recipe.projectKey, this.recipe.getSingleOutput((String)"main").ref);
            RecipeEngineStatus engineStatus = null;
            switch (sm.miniTask.backendType) {
                case H2O: {
                    engineStatus = new RecipeEngineStatus("SPARK", "Spark", "H20", "Sparkling Water", "Sparkling Water");
                    break;
                }
                case MLLIB: {
                    engineStatus = new RecipeEngineStatus("SPARK", "Spark", "MLLIB", "MLLib", "Spark MLLib");
                    break;
                }
                case PY_MEMORY: {
                    engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS in-memory");
                    break;
                }
                case DEEP_HUB: 
                case KERAS: {
                    engineStatus = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Streamed", "DSS streamed");
                    break;
                }
                case VERTICA: {
                    engineStatus = new RecipeEngineStatus("SQL", "SQL", "VERTICA_ML", "Vertica ML", "In-database (Vertica ML)");
                }
            }
            status.selectedEngine = engineStatus;
            status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
            JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(activity);
            return status;
        }
    }
}

