/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ColumnImportance;
import com.dataiku.dip.analysis.model.prediction.DataEvaluationMetrics;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanations;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsAbsoluteImportance;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsFacts;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsObservations;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesInteractiveScoringScenarios;
import com.dataiku.dip.analysis.model.prediction.TimeseriesResiduals;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVReader;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class ModelLikeId {
    public static final String GLOBAL_EXPLANATIONS_OBSERVATIONS = "global_explanations_observations.json";
    public static final String GLOBAL_EXPLANATIONS_ABSOLUTE_IMPORTANCE = "global_explanations_absolute_importance.json";
    public static final String GLOBAL_EXPLANATIONS_FACTS = "global_explanations_facts.json";
    public static final String SAMPLE_CSV_GZ = "sample.csv.gz";
    public static final String SAMPLE_SCHEMA_JSON = "sample_schema.json";
    public static final String SAMPLE_WITH_METRICS_CSV_GZ = "sample_with_metrics.csv.gz";
    public static final String SAMPLE_WITH_METRICS_SCHEMA_JSON = "sample_with_metrics_schema.json";
    protected final ModelLikeType modelLikeType;
    protected final String projectKey;
    private static DKULogger logger;

    public ModelLikeId(String projectKey, ModelLikeType modelLikeType) {
        this.modelLikeType = modelLikeType;
        this.projectKey = projectKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public abstract String getId();

    public abstract String toString();

    public abstract File getFolderEnsuringSecurity();

    public abstract File getMainFolder();

    public abstract File getSplitFolder();

    public abstract boolean hasResolvedCoreParams();

    public abstract ResolvedCoreParams getResolvedCoreParams() throws IOException;

    public abstract File getCollectorDataFile() throws IOException;

    public abstract File getSubpopulationFile();

    public abstract File getPredictionStatisticsFile();

    public abstract boolean hasPredictionStatisticsFile();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract File getPostOperationsFolder();

    public abstract Map<String, FeaturePreprocessingParams> getFeatures() throws IOException;

    public ResolvedClassicalPredictionPreprocessingParams getResolvedPredictionPreprocessingParams() throws IOException {
        ResolvedPreprocessingParams params = this.getResolvedPreprocessingParams();
        return params instanceof ResolvedClassicalPredictionPreprocessingParams ? (ResolvedClassicalPredictionPreprocessingParams)params : null;
    }

    public abstract boolean hasResolvedPreprocessingParams();

    public abstract ResolvedPreprocessingParams getResolvedPreprocessingParams() throws IOException;

    public abstract DataEvaluationMetrics getDataEvaluationMetrics() throws IOException;

    public abstract MLTask.BackendType getBackendType() throws IOException;

    public abstract FuturePayload buildPostComputationFuturePayload();

    public Set<String> getClasses() throws IOException {
        ResolvedClassicalPredictionPreprocessingParams preprocessing;
        File f = DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{"mlflow_imported_model.json"});
        if (f.isFile() && f.canRead()) {
            MLFlowModelVersionInfo mvi = (MLFlowModelVersionInfo)JSON.parseFile((File)f, MLFlowModelVersionInfo.class);
            if (mvi.classLabels != null) {
                return mvi.classLabels.stream().map(cl -> cl.label).collect(Collectors.toSet());
            }
        } else if (this.hasResolvedPreprocessingParams() && (preprocessing = this.getResolvedPredictionPreprocessingParams()) != null && preprocessing.target_remapping != null) {
            return preprocessing.target_remapping.stream().map(mapping -> mapping.sourceValue).collect(Collectors.toSet());
        }
        return null;
    }

    public abstract ComputeResourceUsageContext getComputeResourceUsageContext(DSSAuthCtx var1);

    public abstract File getSessionFolder();

    public abstract boolean hasDataToStreamCSV() throws IOException;

    public abstract void streamDataCSV(OutputStream var1) throws Exception;

    public abstract Schema getDataSchema() throws IOException;

    @Nullable
    public abstract Schema getPredictedSchema() throws IOException;

    public abstract void streamPredictedCSV(OutputStream var1) throws Exception;

    @Nullable
    public abstract ColumnImportance getColumnImportance() throws IOException;

    public abstract Set<String> getUsedConnections() throws IOException;

    public abstract boolean remapAndSaveConnections(Map<String, String> var1) throws IOException;

    public ModelLikeType getModelLikeType() {
        return this.modelLikeType;
    }

    public JsonObject getCollectorDataOrNull() throws IOException {
        File collectorDataFile = this.getCollectorDataFile();
        if (collectorDataFile.isFile()) {
            return (JsonObject)JSON.parseFile((File)collectorDataFile, JsonObject.class);
        }
        return null;
    }

    public abstract TaggableObjectsService.TaggableObjectRef getUnderlyingStore();

    public abstract PredictionMLTask.PredictionType getPredictionType() throws IOException;

    public abstract FullModelId getUnderlyingModel() throws IOException;

    @Transient
    public File getGlobalExplanationsObservationsFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{GLOBAL_EXPLANATIONS_OBSERVATIONS});
    }

    @Transient
    public File getGlobalExplanationsAbsoluteImportanceFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{GLOBAL_EXPLANATIONS_ABSOLUTE_IMPORTANCE});
    }

    @Transient
    public File getGlobalExplanationsFactsFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{GLOBAL_EXPLANATIONS_FACTS});
    }

    @Transient
    public Optional<PredictionGlobalExplanationsObservations> getGlobalExplanationsObservations() throws IOException {
        File globalExplanationsFile = this.getGlobalExplanationsObservationsFile();
        if (globalExplanationsFile.isFile()) {
            return Optional.of((PredictionGlobalExplanationsObservations)JSON.parseFile((File)globalExplanationsFile, PredictionGlobalExplanationsObservations.class));
        }
        return Optional.empty();
    }

    @Transient
    public Optional<PredictionGlobalExplanationsAbsoluteImportance> getGlobalExplanationsAbsoluteImportance() throws IOException {
        File globalExplanationsFile = this.getGlobalExplanationsAbsoluteImportanceFile();
        if (globalExplanationsFile.isFile()) {
            return Optional.of((PredictionGlobalExplanationsAbsoluteImportance)JSON.parseFile((File)globalExplanationsFile, PredictionGlobalExplanationsAbsoluteImportance.class));
        }
        return Optional.empty();
    }

    @Transient
    public Optional<PredictionGlobalExplanations> getGlobalExplanations() throws IOException {
        PredictionGlobalExplanations globalExplanations = new PredictionGlobalExplanations();
        Optional<PredictionGlobalExplanationsAbsoluteImportance> globalExplanationsAbsoluteImportance = this.getGlobalExplanationsAbsoluteImportance();
        Optional<PredictionGlobalExplanationsObservations> globalExplanationsObservations = this.getGlobalExplanationsObservations();
        if (!globalExplanationsAbsoluteImportance.isPresent() || !globalExplanationsObservations.isPresent()) {
            return Optional.empty();
        }
        globalExplanations.explanations = globalExplanationsObservations.get().explanations;
        globalExplanations.observations = globalExplanationsObservations.get().observations;
        globalExplanations.absoluteImportance = globalExplanationsAbsoluteImportance.get().absoluteImportance;
        return Optional.of(globalExplanations);
    }

    @Transient
    public File getIndividualExplanationsFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getPostOperationsFolder(), (String[])new String[]{"individual_explanations.json"});
    }

    @Transient
    public File getLearningCurveFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getPostOperationsFolder(), (String[])new String[]{"learning_curve.json"});
    }

    public abstract SplitDesc getSplitDesc() throws IOException;

    @Transient
    public Optional<PredictionGlobalExplanationsFacts> getGlobalExplanationsFacts() throws IOException {
        File globalExplanationsFactsFile = this.getGlobalExplanationsFactsFile();
        if (globalExplanationsFactsFile.exists()) {
            return Optional.of((PredictionGlobalExplanationsFacts)JSON.parseFile((File)globalExplanationsFactsFile, PredictionGlobalExplanationsFacts.class));
        }
        return Optional.empty();
    }

    public abstract String toSmartModelLikeId(String var1);

    public static ModelLikeId parse(String smartId, String contextProjectKey) {
        if (smartId != null) {
            if (smartId.startsWith("S-*")) {
                return FullModelId.parseSmartSavedModelId(smartId, contextProjectKey);
            }
            if (smartId.startsWith("A-*")) {
                return FullModelId.parseSmartAnalysisId(smartId, contextProjectKey);
            }
            if (smartId.startsWith("ME-*")) {
                return FullModelEvaluationId.parseSmart(smartId, contextProjectKey);
            }
            if (smartId.startsWith("S-")) {
                return FullModelId.parseSavedModelId(smartId);
            }
            if (smartId.startsWith("A-")) {
                return FullModelId.parseAnalysisId(smartId);
            }
            if (smartId.startsWith("ME-")) {
                return FullModelEvaluationId.parse(smartId);
            }
        }
        throw new IllegalArgumentException(smartId + " is not a FullModelId nor a FullModelEvaluationId");
    }

    @Transient
    private static void checkFileSize(File file) throws CodedIOException {
        if (file.length() > ApplicationConfigurator.getParams().getLongParam("dku.fileSizeLimit.modelDetailJson", 0x3200000L)) {
            throw new CodedIOException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_MODEL_DETAILS_OVERFLOW, file.getAbsolutePath() + " exceeds size limit: " + file.length());
        }
    }

    @Transient
    public static <T> T parseJsonFile(File file, Class<T> clazz) throws IOException {
        ModelLikeId.checkFileSize(file);
        return (T)JSON.parseFile((File)file, clazz);
    }

    @Transient
    public static <T> T parseJsonFileWithAutoDecompress(File file, Class<T> clazz) throws IOException {
        ModelLikeId.checkFileSize(file);
        return (T)JSON.parse((InputStream)DKUFileUtils.readWithAutoDecompress((File)file), clazz);
    }

    public File getMLDiagnosticsFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{"ml_diagnostics.json"});
    }

    public MLDiagnostics getMLDiagnostics() throws IOException {
        File mlDiagnosticsFile = this.getMLDiagnosticsFile();
        if (mlDiagnosticsFile.exists()) {
            return ModelLikeId.parseJsonFile(mlDiagnosticsFile, MLDiagnostics.class);
        }
        return null;
    }

    private Pair<Boolean, List<String[]>> sampleRows(CSVReader reader, int rangeSize) throws IOException {
        List allRows = reader.readAll();
        if (allRows.size() <= rangeSize) {
            return new Pair((Object)false, (Object)allRows);
        }
        String[] firstRow = (String[])allRows.get(0);
        String[] lastRow = (String[])allRows.get(allRows.size() - 1);
        Random random = new Random(1234L);
        while (allRows.size() > rangeSize - 2) {
            allRows.remove(random.nextInt(allRows.size()));
        }
        allRows.add(0, firstRow);
        allRows.add(lastRow);
        return new Pair((Object)true, (Object)allRows);
    }

    public Optional<Map<String, TimeseriesResiduals>> parseTimeseriesResiduals(List<String> identifiers) throws IOException {
        Set<Object> identifierColumns;
        HashMap<String, TimeseriesResiduals> residualsByTimeseries = new HashMap<String, TimeseriesResiduals>();
        File residualsFolder = DKUFileUtils.getWithin((File)this.getMainFolder(), (String[])new String[]{"residuals"});
        if (!DKUFileUtils.exists((File)DKUFileUtils.getWithinFollowLink((File)residualsFolder, (String[])new String[]{"identifiers_mapping.json"}), (String[])new String[0])) {
            return Optional.empty();
        }
        Map identifiersMapping = (Map)JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)residualsFolder, (String[])new String[]{"identifiers_mapping.json"}), Map.class);
        try {
            identifierColumns = JSON.parseToMap((String)((String)identifiersMapping.keySet().toArray()[0])).keySet();
        }
        catch (JsonSyntaxException e) {
            identifierColumns = Set.of();
        }
        int offset = identifierColumns.size();
        Set<Object> allIdentifiers = Set.of();
        if (identifiers.size() == 0) {
            allIdentifiers = identifiersMapping.keySet();
        } else {
            allIdentifiers.addAll(identifiers);
        }
        if (allIdentifiers.isEmpty()) {
            return Optional.empty();
        }
        for (String string : allIdentifiers) {
            try {
                File residualsFile = DKUFileUtils.getWithinFollowLink((File)residualsFolder, (String[])new String[]{"residuals-" + (String)identifiersMapping.get(string) + ".csv.gz"});
                CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(DKUFileUtils.readWithAutoDecompress((File)residualsFile)), '\t');
                Pair<Boolean, List<String[]>> pair = this.sampleRows(csvReader, TimeseriesResiduals.MAX_SAMPLE_SIZE);
                for (String[] row : (List)pair.second) {
                    if (!residualsByTimeseries.containsKey(string)) {
                        residualsByTimeseries.put(string, new TimeseriesResiduals(string));
                    }
                    ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).dates.add(row[0 + offset]);
                    ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).target.add(Double.parseDouble(row[1 + offset]));
                    ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).fittedValues.add(Double.parseDouble(row[2 + offset]));
                    ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).residuals.add(Double.parseDouble(row[3 + offset]));
                    ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).stdResiduals.add(Double.parseDouble(row[4 + offset]));
                    ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).theoreticalQuantiles.add(Double.parseDouble(row[5 + offset]));
                }
                ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).isSample = (Boolean)pair.first;
                String statsFileName = "stats-" + (String)identifiersMapping.get(string) + ".json";
                ((TimeseriesResiduals)residualsByTimeseries.get((Object)string)).stats = (TimeseriesResiduals.Stats)JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)residualsFolder, (String[])new String[]{statsFileName}), TimeseriesResiduals.Stats.class);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception while parsing timeseries residuals for identifier " + string + ": " + e.getMessage()));
            }
        }
        return Optional.of(residualsByTimeseries);
    }

    public Optional<Map<String, TimeseriesInteractiveScoringScenarios>> parseTimeseriesInteractiveScoringScenario() {
        try {
            TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder isf = new TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder(this.getMainFolder(), this.getResolvedPreprocessingParams());
            return Optional.of(isf.parseScenarios());
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage());
            return Optional.empty();
        }
    }

    public void updateTimeseriesInteractiveScoringScenarios(Map<String, TimeseriesInteractiveScoringScenarios> scenarios) throws IOException {
        TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder isf = new TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder(this.getMainFolder(), this.getResolvedPreprocessingParams());
        for (Map.Entry<String, TimeseriesInteractiveScoringScenarios> entry : scenarios.entrySet()) {
            String timeseriesIdentifier = entry.getKey();
            TimeseriesInteractiveScoringScenarios perTimeseriesScenarios = entry.getValue();
            isf.updateTimeseriesScenarios(timeseriesIdentifier, perTimeseriesScenarios);
        }
    }

    public Optional<Map<String, TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts>> getInteractiveScoringTimeseriesEvaluationForecasts() throws IOException {
        File interactiveScoringFolder = DKUFileUtils.getWithin((File)this.getMainFolder(), (String[])new String[]{"interactive-scoring-analysis"});
        if (!interactiveScoringFolder.exists()) {
            return Optional.empty();
        }
        File forecastsFile = DKUFileUtils.getWithinFollowLink((File)interactiveScoringFolder, (String[])new String[]{"scenario-forecasts.json.gz"});
        if (!forecastsFile.exists()) {
            return Optional.empty();
        }
        Map result = ModelLikeId.parsePossiblyCompressedJsonFile(forecastsFile, Map.class);
        return Optional.of(result);
    }

    public static <T> T parsePossiblyCompressedJsonFile(File file, Class<T> clazz) throws IOException {
        File possiblyGzippedModelFile = DKUFileUtils.getWithAutoDecompress((File)file);
        return ModelLikeId.parseJsonFileWithAutoDecompress(possiblyGzippedModelFile, clazz);
    }

    public boolean exists() {
        return this.getMainFolder().exists();
    }

    static {
        JSON.registerFactory((TypeAdapterFactory)new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (!ModelLikeId.class.isAssignableFrom(typeToken.getRawType())) {
                    return null;
                }
                final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken);
                return new TypeAdapter<T>(){

                    public void write(JsonWriter jsonWriter, T modelLikeId) throws IOException {
                        JsonElement o = delegate.toJsonTree(modelLikeId);
                        if (o != null && o.isJsonObject()) {
                            JsonObject jsonObj = o.getAsJsonObject();
                            jsonObj.addProperty("fullId", modelLikeId.toString());
                            Streams.write((JsonElement)jsonObj, (JsonWriter)jsonWriter);
                        } else {
                            Streams.write((JsonElement)o, (JsonWriter)jsonWriter);
                        }
                    }

                    public T read(JsonReader jsonReader) throws IOException {
                        return delegate.read(jsonReader);
                    }
                };
            }
        });
        logger = DKULogger.getLogger((String)"dku.analysis.ml");
    }

    public static enum ModelLikeType {
        DOCTOR_MODEL,
        MODEL_EVALUATION;

    }
}

