/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.PreprocessingReport;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelPerf;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelSnippetData;
import com.dataiku.dip.analysis.model.clustering.ClustersFacts;
import com.dataiku.dip.analysis.model.clustering.HeatMap;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringCoreParams;
import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClusteringResultsReader {
    private static Logger logger = Logger.getLogger((String)"dku.models.resultsreader");

    private ClusteringResultsReader() {
    }

    public static ClusteringModelSnippetData makeSnippet(FullModelId id) throws IOException {
        ClusteringModelDetails ret = new ClusteringModelDetails();
        ClusteringResultsReader.fillDetails(ret, id);
        return ClusteringResultsReader.makeSnippet(ret);
    }

    public static ClusteringModelSnippetData makeSnippet(ClusteringModelDetails summary) {
        ClusteringModelSnippetData sd = new ClusteringModelSnippetData();
        sd.fullModelId = summary.fullModelId;
        sd.algorithm = summary.modeling.algorithm;
        sd.backendType = summary.backendType;
        sd.sessionId = summary.sessionId;
        sd.sessionDate = summary.sessionDate == 0L ? System.currentTimeMillis() : summary.sessionDate;
        sd.evaluationMetric = summary.modeling.getEvaluationMetricName();
        if (summary.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            sd.silhouette = summary.perf.metrics.silhouette;
            sd.ssRatio = summary.perf.metrics.ssRatio;
            sd.inertia = summary.perf.metrics.inertia;
            sd.nbClusters = summary.perf.metrics.nbClusters;
        }
        sd.trainInfo = summary.trainInfo;
        sd.userMeta = summary.userMeta;
        sd.facts = summary.facts;
        sd.mlDiagnostics = summary.mlDiagnostics;
        sd.usesPCA = summary.preprocessing.reduce.enabled;
        if (sd.usesPCA) {
            List<String> parts = Arrays.asList(sd.userMeta.name.split(" "));
            sd.userMeta.name = StringUtils.join((Object[])parts.subList(0, parts.size() - 1).toArray(), (String)" ") + " (PCA) " + parts.get(parts.size() - 1);
        }
        return sd;
    }

    public static ClusteringModelDetails makeDetails(FullModelId id) throws IOException {
        ClusteringModelDetails ret = new ClusteringModelDetails();
        ClusteringResultsReader.fillDetails(ret, id);
        return ret;
    }

    private static void fillDetails(ClusteringModelDetails ret, FullModelId id) throws IOException {
        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(id, ret);
        ret.preprocessing = id.parsePreprocessingFile("rpreprocessing_params.json", ResolvedClusteringPreprocessingParams.class);
        ret.modeling = id.parseModelFile("rmodeling_params.json", PreTrainClusteringModelingParams.class);
        ret.backendType = ret.modeling.algorithm.backendType;
        ret.coreParams = (ResolvedClusteringCoreParams)id.getResolvedCoreParams();
        if (ret.trainInfo.state == ModelTrainInfo.ModelTrainState.DONE) {
            ret.preprocessingReport = id.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
            ret.perf = id.parseModelFile("results.json", ClusteringModelPerf.class);
            ret.actualParams = id.parseModelFile("actual_params.json", ActualModelParameters.class);
            try {
                ret.facts = id.parseModelFile("facts.json", ClustersFacts.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to load clustering facts", (Throwable)e);
            }
            try {
                ret.heatmap = id.parseModelFile("heatmap.json", HeatMap.class).normalized();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to load clustering heatmap", (Throwable)e);
            }
            try {
                ret.clustersProfiling = id.parseModelFile("profiling.json", JsonArray.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to load clustering profiling", (Throwable)e);
            }
            try {
                ret.iperf = id.parseModelFile("iperf.json", ClusteringModelIntrinsicPerf.class);
            }
            catch (Exception e) {
                if (!id.hasReadableModelFile("iperf.json")) {
                    logger.info((Object)"Clustering intrinsic performance file doesn't exist, this is expected if the model was trained before DSS 13.1.0", (Throwable)e);
                }
                logger.warn((Object)"Failed to load clustering intrinsic performance", (Throwable)e);
            }
        }
        ret.trainedWithScript = id.parseSessionFile("script.json", SerializedShakerScript.class);
        ResultsReaderBase.readSplitData(id, ret);
    }
}

