/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.distributed.workers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.distributed.workers.AbstractWorkerService;
import com.dataiku.dip.analysis.ml.distributed.workers.Worker;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerFactory;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.TestFlag;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class WorkerService
extends AbstractWorkerService {
    @VisibleForTesting
    static final TestFlag allowNotImpersonatedWorker = new TestFlag();
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.analysis.ml.distributed.workers");

    public WorkerService() {
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.API) {
            throw new UnsupportedOperationException("This worker service is not supported on the API node. Use the LambdaWorkerService.");
        }
    }

    public synchronized WorkerPool createWorkerPool(String projectKey, String envName, AuthCtx authCtx, @Nullable ContainerExecRuntimeConfig containerConfig, boolean impersonated, boolean useProjectLibs, Map<String, String> pythonLibs) {
        MLBaseService.MLTaskWorkThread.MLTaskContext mlTaskContext = (MLBaseService.MLTaskWorkThread.MLTaskContext)MLBaseService.MLTaskWorkThread.mlTaskContext.get();
        JobContext jobContext = JobContext.getCurrentJobContext();
        ComputeResourceUsageContext cruContext = CurrentComputeResourceUsageContext.get();
        String workerPoolId = this.generateId();
        Runnable unregisterWorkerPool = this.getCloseCallBack(workerPoolId);
        WorkerPool workerPool = this.createWorkerPool(projectKey, envName, authCtx, containerConfig, mlTaskContext, jobContext, cruContext, workerPoolId, unregisterWorkerPool, impersonated, useProjectLibs, pythonLibs);
        this.workerPools.put(workerPoolId, workerPool);
        logger.info((Object)("New worker pool created: " + workerPoolId));
        return workerPool;
    }

    private WorkerPool createWorkerPool(String projectKey, String envName, AuthCtx authCtx, ContainerExecRuntimeConfig containerConfig, MLBaseService.MLTaskWorkThread.MLTaskContext mlTaskContext, JobContext jobContext, ComputeResourceUsageContext cruContext, String workerPoolId, Runnable unregisterWorkerPool, boolean impersonated, boolean useProjectLibs, Map<String, String> pythonLibs) {
        AtomicInteger workerCount = new AtomicInteger();
        WorkerFactory workerFactory = (workerId, workerPool) -> {
            if (!allowNotImpersonatedWorker.isActivated() && !workerPool.impersonated) {
                throw new UnsupportedOperationException("Workers can only be spawned while impersonated.");
            }
            return new Worker(workerId, workerPool, SimplePythonKernelFactory.prepareKernel(authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, envName, "dataiku.doctor.distributed.remote_worker_server", workerPool.impersonated, useProjectLibs, pythonLibs, containerConfig, workerId, "remote-worker-" + workerCount.incrementAndGet() + "-", true, false, null));
        };
        return new WorkerPool(projectKey, envName, authCtx, workerPoolId, cruContext, mlTaskContext, jobContext, unregisterWorkerPool, workerFactory, impersonated);
    }

    public synchronized WorkerPool getWorkerPool(AuthCtx authCtx, String workerPoolId) throws DKUSecurityException {
        WorkerPool workerPool = super.getWorkerPool(workerPoolId);
        if (!Objects.equals(authCtx.getAssociatedDSSUserMand(), workerPool.authCtx.getAssociatedDSSUser())) {
            throw new DKUSecurityException("Cannot use a worker pool belonging to another user");
        }
        return workerPool;
    }
}

