/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.ml.prediction.guess.TabularPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.TimestepParamsComputer;
import com.dataiku.dip.analysis.ml.shared.FeatureGuessUtils;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.dataiku.dip.analysis.model.preprocessing.FeatureGenerationParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TimeseriesForecastingPreprocessingParams;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class TimeseriesForecastingGuesser
extends TabularPredictionGuesser<PredictionMLTask.TimeseriesForecastingMLTask> {
    private static final int MIN_CONTEXT_LENGTH = 10;
    private static final int MAX_RECORDS = 10000;
    private static AnyTemporal anyTemporalMeaning = new AnyTemporal();
    private boolean timeStepParamsSuccessfullyGuessed;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis");

    protected TimeseriesForecastingGuesser(PredictionMLTask.TimeseriesForecastingMLTask task, MemTable table) {
        super(task, table);
    }

    @Override
    public boolean canChangePredictionType() {
        return false;
    }

    @Override
    protected Optional<FeaturePreprocessingParams.Role> getSpecialFeatureRole(MemColumn column) {
        MemColumn targetColumn = this.table.getColumn(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).targetVariable);
        if (column.equals(targetColumn)) {
            return Optional.of(FeaturePreprocessingParams.Role.TARGET);
        }
        MemColumn timeVarColumn = this.table.getColumn(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable);
        if (column.equals(timeVarColumn)) {
            return Optional.of(FeaturePreprocessingParams.Role.TIME);
        }
        for (String timeseriesIdentifier : ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeseriesIdentifiers) {
            MemColumn timeSeriesIdentifierColumn = this.table.getColumn(timeseriesIdentifier);
            if (!column.equals(timeSeriesIdentifierColumn)) continue;
            return Optional.of(FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER);
        }
        return Optional.empty();
    }

    @Override
    public FeaturePreprocessingParams guessSingleFeature(MemColumn column) {
        Optional<FeaturePreprocessingParams.Role> specialRole = this.getSpecialFeatureRole(column);
        if (specialRole.isPresent()) {
            return this.guessSpecialFeature(FeatureGuessUtils.isNumerical(column), specialRole.get());
        }
        FeaturePreprocessingParams preprocessingParams = FeatureGuessUtils.guessSingleFeature(this.table, column, this.task);
        preprocessingParams.role = FeaturePreprocessingParams.Role.REJECT;
        return preprocessingParams;
    }

    @Override
    protected void guessPredictionType(MemColumn targetColumn) {
    }

    @Override
    protected void guessAllSettingsWithFixedPredictionType(boolean throwException) {
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).splitParams = SplitParams.buildForTimeseries(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable);
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength = 10L;
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).skipTooShortTimeseriesForTraining = false;
        try {
            logger.info((Object)"Guessing time step parameters");
            TimestepParamsComputer.updateTimestepParams((PredictionMLTask.TimeseriesForecastingMLTask)this.task, this.table);
            this.timeStepParamsSuccessfullyGuessed = true;
        }
        catch (Exception e) {
            this.timeStepParamsSuccessfullyGuessed = false;
        }
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.gapSize = 0L;
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.testSize = ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength;
        this.checkAllFixableSettings(throwException);
        logger.info((Object)"Guessing algorithm parameters");
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling = this.guessAlgorithms(this.table, (PredictionMLTask.TimeseriesForecastingMLTask)this.task, false);
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling.grid_search = false;
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling.gridSearchParams.nJobs = 1;
        this.setNIterRandom();
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling.xgboost.enable_early_stopping = false;
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling.lightgbm_regression.early_stopping = false;
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling.metrics.evaluationMetric = MetricParams.EvaluationMetric.MASE;
        ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).preprocessing = new TimeseriesForecastingPreprocessingParams();
        for (String name : this.table.columns.keySet()) {
            this.guessFeature(name);
        }
        this.setDefaultTimeseriesShiftAndWindows(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).preprocessing);
        TimeseriesForecastingGuesser.setResamplingDates((PredictionMLTask.TimeseriesForecastingMLTask)this.task, this.table);
    }

    @Override
    protected void checkTargetColumn(boolean throwException) {
        boolean isAllNumeric;
        super.checkTargetColumn(throwException);
        MemColumn targetColumn = this.table.columns.get(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).targetVariable);
        if (targetColumn != null && targetColumn.selectedType != null && !(isAllNumeric = FeatureGuessUtils.isNumerical(targetColumn))) {
            this.throwOrAddMessage("Target column contains non-numerical values, incompatible with time forecasting models", throwException);
        }
    }

    private void checkTimeseriesIdentifiersColumns(boolean throwException) {
        for (String timeseriesIdentifier : ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeseriesIdentifiers) {
            if (this.table.columns.containsKey(timeseriesIdentifier)) continue;
            this.throwOrAddMessage("Dataset does not contain the time series identifier column '" + timeseriesIdentifier + "'", throwException);
        }
    }

    private void checkTimeVariableColumn(boolean throwException) {
        if (StringUtils.isBlank((String)((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable)) {
            this.throwOrAddMessage("No time variable", throwException);
        }
        if (!this.table.columns.containsKey(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable)) {
            this.throwOrAddMessage("Dataset does not contain the time variable column '" + ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable + "'", throwException);
        }
    }

    private void checkNoSpecialRoleCollision() {
        if (((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeseriesIdentifiers.contains(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).targetVariable)) {
            this.messages.add("Target cannot be a time series identifier '" + ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).targetVariable + "'");
        }
        if (((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeseriesIdentifiers.contains(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable)) {
            this.messages.add("Time variable cannot be a time series identifier '" + ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable + "'");
        }
        if (((PredictionMLTask.TimeseriesForecastingMLTask)this.task).targetVariable.equals(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable)) {
            this.messages.add("Target cannot be the time variable '" + ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable + "'");
        }
    }

    @Override
    protected void checkAllFixableSettings(boolean throwException) {
        super.checkAllFixableSettings(throwException);
        this.checkTimeVariableColumn(throwException);
        this.checkTimeseriesIdentifiersColumns(throwException);
        this.checkNoSpecialRoleCollision();
    }

    public void changeTimeseriesIdentifiersNoReguess(List<String> previousTimeseriesIdentifiers, @Nullable GuessStatus previousGuessStatus) {
        this.checkTimeseriesIdentifiersColumns(true);
        this.retrievePreviousGuessStatusBooleans(previousGuessStatus);
        this.checkAllFixableSettings(false);
        for (String timeseriesIdentifier : ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeseriesIdentifiers) {
            this.guessFeature(timeseriesIdentifier);
        }
        for (String previousTimeseriesIdentifier : previousTimeseriesIdentifiers) {
            if (((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeseriesIdentifiers.contains(previousTimeseriesIdentifier)) continue;
            this.guessFeature(previousTimeseriesIdentifier);
        }
    }

    public void changeTimeVariableNoReguess(String previousTimeVariable, @Nullable GuessStatus previousGuessStatus) {
        this.checkTimeVariableColumn(true);
        this.retrievePreviousGuessStatusBooleans(previousGuessStatus);
        this.checkAllFixableSettings(false);
        this.guessFeature(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timeVariable);
        if (!StringUtils.isBlank((String)previousTimeVariable)) {
            this.guessFeature(previousTimeVariable);
        }
    }

    public void changeTimestepParamsLimitedReguess(boolean timestepParamsUpdated, boolean predictionLengthUpdated, boolean redetect, @Nullable GuessStatus previousGuessStatus, @Nullable Long previousPredictionLength, @Nullable Long validationHorizons) {
        this.retrievePreviousGuessStatusBooleans(previousGuessStatus);
        this.checkAllFixableSettings(false);
        if (predictionLengthUpdated) {
            this.setNewTestSize(previousPredictionLength, validationHorizons);
            if (((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.gapSize > ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength - 1L) {
                ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.gapSize = 0L;
            }
            if (redetect) {
                this.updateAlgorithmsContextLength(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling);
                this.setDefaultTimeseriesShiftAndWindows(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).preprocessing);
            }
        }
        if (timestepParamsUpdated && redetect) {
            this.updateAlgorithmsSeasonLength(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).modeling);
            this.setDefaultTimeseriesShiftAndWindows(((PredictionMLTask.TimeseriesForecastingMLTask)this.task).preprocessing);
            try {
                logger.info((Object)"Guessing time alignments parameters");
                TimestepParamsComputer.updateTimeAlignments((PredictionMLTask.TimeseriesForecastingMLTask)this.task, this.table);
                TimeseriesForecastingGuesser.setResamplingDates((PredictionMLTask.TimeseriesForecastingMLTask)this.task, this.table);
                this.timeStepParamsSuccessfullyGuessed = true;
            }
            catch (Exception e) {
                this.timeStepParamsSuccessfullyGuessed = false;
            }
        }
    }

    @Override
    public GuessStatus checkStatus() {
        if (!this.timeStepParamsSuccessfullyGuessed) {
            this.messages.add("Failed to guess time step parameters, falling back to default value, you may have to change the time series identifier columns and/or time variable");
        }
        GuessStatus guessStatus = super.checkStatus();
        guessStatus.timeStepParamsSuccessfullyGuessed = this.timeStepParamsSuccessfullyGuessed;
        return guessStatus;
    }

    @Override
    public void retrievePreviousGuessStatusBooleans(@Nullable GuessStatus previousGuessStatus) {
        if (previousGuessStatus != null) {
            this.timeStepParamsSuccessfullyGuessed = previousGuessStatus.timeStepParamsSuccessfullyGuessed == null || previousGuessStatus.timeStepParamsSuccessfullyGuessed != false;
        }
    }

    protected void initializeAlgorithms(PredictionModelingParams params) {
        this.updateAlgorithmsSeasonLength(params);
        this.updateAlgorithmsContextLength(params);
    }

    private void updateAlgorithmsSeasonLength(PredictionModelingParams params) {
        params.seasonal_naive_timeseries.season_length.setToSingleValueGrid(this.computeSeasonLength(1L, null));
        long seasonLengthSTL = this.computeSeasonLength(2L, null);
        params.seasonal_loess_timeseries.period.setToSingleValueGrid(seasonLengthSTL);
        params.seasonal_loess_timeseries.trend.setToSingleValueGrid(seasonLengthSTL + seasonLengthSTL % 2L + 1L);
        params.seasonal_loess_timeseries.low_pass.setToSingleValueGrid(seasonLengthSTL + seasonLengthSTL % 2L + 1L);
        params.ets_timeseries.seasonal_periods = (int)this.computeSeasonLength(2L, null);
        long autoarima_m = this.computeSeasonLength(1L, 12L);
        params.autoarima_timeseries.m.setToSingleValueGrid(autoarima_m);
        int autoarima_max_order = 1 + params.autoarima_timeseries.start_p + params.autoarima_timeseries.start_q;
        if (autoarima_m > 1L) {
            autoarima_max_order += params.autoarima_timeseries.start_P + params.autoarima_timeseries.start_Q;
        }
        params.autoarima_timeseries.max_order = Math.max(5, autoarima_max_order);
    }

    private void updateAlgorithmsContextLength(PredictionModelingParams params) {
        params.gluonts_simple_feed_forward_timeseries.context_length.setToSingleValueGrid(Math.max(10L, ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength));
        params.gluonts_deepar_timeseries.context_length.setToSingleValueGrid(Math.max(10L, ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength));
        params.gluonts_transformer_timeseries.context_length.setToSingleValueGrid(Math.max(10L, ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength));
        params.gluonts_npts_timeseries.context_length.setToSingleValueGrid(1100L);
        params.gluonts_mqcnn_timeseries.context_length.setToSingleValueGrid(Math.max(10L, 4L * ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength));
    }

    private void setDefaultTimeseriesShiftAndWindows(TimeseriesForecastingPreprocessingParams preprocessing) {
        Map<String, FeaturePreprocessingParams> selectedShiftableFeatures = preprocessing.feature_generation.getShiftableFeatures(preprocessing).stream().collect(Collectors.toMap(feature_name -> feature_name, feature_name -> (FeaturePreprocessingParams)preprocessing.per_feature.get(feature_name)));
        preprocessing.feature_generation.shifts = selectedShiftableFeatures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            FeatureGenerationParams.FeatureShiftsParams shifts = new FeatureGenerationParams.FeatureShiftsParams();
            if (((FeaturePreprocessingParams)entry.getValue()).role.name().equals("INPUT")) {
                shifts.from_forecast = Collections.emptyList();
                shifts.from_horizon = new ArrayList<Integer>(List.of(Integer.valueOf(-2), Integer.valueOf(-1), Integer.valueOf(0)));
            } else {
                shifts.from_forecast = new ArrayList<Integer>(Arrays.asList(-2, -1, 0));
                shifts.from_horizon = new ArrayList<Integer>(List.of(Integer.valueOf(-((int)((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength) - 2), Integer.valueOf(-((int)((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength) - 1), Integer.valueOf(-((int)((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength))));
            }
            return shifts;
        }));
        Map<String, FeaturePreprocessingParams> selectedWindowableFeatures = preprocessing.feature_generation.getWindowableFeatures(preprocessing).stream().collect(Collectors.toMap(feature_name -> feature_name, feature_name -> (FeaturePreprocessingParams)preprocessing.per_feature.get(feature_name)));
        FeatureGenerationParams.RollingWindowsParams rollingWindowsParams = new FeatureGenerationParams.RollingWindowsParams();
        rollingWindowsParams.shift = 0;
        rollingWindowsParams.length = Math.max((int)((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength, 2);
        rollingWindowsParams.is_from_forecast = true;
        Map<String, List> operationMap = selectedWindowableFeatures.entrySet().stream().filter(feature -> ((FeaturePreprocessingParams)feature.getValue()).type.name().equals("NUMERIC")).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> FeatureGenerationParams.createWindowOperationParams(true)));
        rollingWindowsParams.operations_map = operationMap;
        preprocessing.feature_generation.windows = new ArrayList<FeatureGenerationParams.RollingWindowsParams>();
        preprocessing.feature_generation.windows.add(rollingWindowsParams);
    }

    private long computeSeasonLength(long minSeasonLength, @Nullable Long maxSeasonLength) {
        long seasonLengthValue = switch (((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.timeunit) {
            case TimestepParams.Timeunit.SECOND, TimestepParams.Timeunit.MINUTE -> Math.max(minSeasonLength, 60L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            case TimestepParams.Timeunit.HOUR -> Math.max(minSeasonLength, 24L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            case TimestepParams.Timeunit.BUSINESS_DAY -> Math.max(minSeasonLength, 5L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            case TimestepParams.Timeunit.DAY -> Math.max(minSeasonLength, 7L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            case TimestepParams.Timeunit.WEEK, TimestepParams.Timeunit.QUARTER -> Math.max(minSeasonLength, 4L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            case TimestepParams.Timeunit.MONTH -> Math.max(minSeasonLength, 12L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            case TimestepParams.Timeunit.HALF_YEAR -> Math.max(minSeasonLength, 2L / ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).timestepParams.numberOfTimeunits);
            default -> minSeasonLength;
        };
        if (null != maxSeasonLength && seasonLengthValue > maxSeasonLength) {
            seasonLengthValue = minSeasonLength;
        }
        return seasonLengthValue;
    }

    public void setNewTestSize(@Nullable Long previousPredictionLength, @Nullable Long validationHorizons) {
        if (validationHorizons != null) {
            ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.testSize = validationHorizons * ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength;
        } else if (previousPredictionLength != null) {
            long previousValidationHorizons = ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.testSize / previousPredictionLength;
            ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).evaluationParams.testSize = previousValidationHorizons * ((PredictionMLTask.TimeseriesForecastingMLTask)this.task).predictionLength;
        }
    }

    private static Date parseDate(String v) {
        long ts = anyTemporalMeaning.longValue(v);
        if (ts == Long.MAX_VALUE) {
            return null;
        }
        return new Date(ts);
    }

    private static LocalDateTime alignDate(LocalDateTime currentDate, int target, boolean getDateBefore, TimestepParams.TimeUnitQuantity timeUnitQuantity) {
        int current = timeUnitQuantity.getCurrentDateUnitAlignment(currentDate);
        if (current == target) {
            return currentDate;
        }
        int delta = target - current;
        currentDate = currentDate.plus(delta, timeUnitQuantity.unit);
        if (delta < 0 && !getDateBefore) {
            currentDate = currentDate.plus(timeUnitQuantity.quantity, timeUnitQuantity.unit);
        }
        if (delta > 0 && getDateBefore) {
            currentDate = currentDate.minus(timeUnitQuantity.quantity, timeUnitQuantity.unit);
        }
        return currentDate;
    }

    private static LocalDateTime minusBusinessDays(LocalDateTime date, long businessDays) {
        LocalDateTime resultDate = date;
        long daysToSubtract = businessDays;
        while (daysToSubtract > 0L) {
            if ((resultDate = resultDate.minusDays(1L)).getDayOfWeek() == DayOfWeek.SATURDAY || resultDate.getDayOfWeek() == DayOfWeek.SUNDAY) continue;
            --daysToSubtract;
        }
        return resultDate;
    }

    private static LocalDateTime setZeros(LocalDateTime date, TimestepParams.Timeunit timeUnit) {
        return switch (timeUnit) {
            case TimestepParams.Timeunit.SECOND -> date.withNano(0);
            case TimestepParams.Timeunit.MINUTE -> date.withNano(0).withSecond(0);
            case TimestepParams.Timeunit.HOUR -> date.withNano(0).withSecond(0).withMinute(0);
            case TimestepParams.Timeunit.BUSINESS_DAY, TimestepParams.Timeunit.DAY, TimestepParams.Timeunit.WEEK -> date.withNano(0).withSecond(0).withMinute(0).withHour(0);
            case TimestepParams.Timeunit.QUARTER, TimestepParams.Timeunit.MONTH, TimestepParams.Timeunit.HALF_YEAR -> date.withNano(0).withSecond(0).withMinute(0).withHour(0).withDayOfMonth(1);
            case TimestepParams.Timeunit.YEAR -> date.withNano(0).withSecond(0).withMinute(0).withHour(0).withDayOfMonth(1).withMonth(1);
            default -> date;
        };
    }

    private static Pair<LocalDateTime, LocalDateTime> alignStartAndEndDate(LocalDateTime startDate, LocalDateTime endDate, TimestepParams timestepParams) {
        startDate = TimeseriesForecastingGuesser.setZeros(startDate, timestepParams.timeunit);
        endDate = TimeseriesForecastingGuesser.setZeros(endDate, timestepParams.timeunit);
        switch (timestepParams.timeunit) {
            case WEEK: {
                int targetDay = timestepParams.getEndOfWeekDay();
                startDate = TimeseriesForecastingGuesser.alignDate(startDate, targetDay, false, new TimestepParams.TimeUnitQuantity(ChronoUnit.DAYS, 7));
                endDate = TimeseriesForecastingGuesser.alignDate(endDate, targetDay, true, new TimestepParams.TimeUnitQuantity(ChronoUnit.DAYS, 7));
                break;
            }
            case BUSINESS_DAY: {
                startDate = TimeseriesForecastingGuesser.alignDate(startDate, 1, false, new TimestepParams.TimeUnitQuantity(ChronoUnit.DAYS, 7));
                endDate = TimeseriesForecastingGuesser.alignDate(endDate, 1, true, new TimestepParams.TimeUnitQuantity(ChronoUnit.DAYS, 7));
                break;
            }
            case QUARTER: {
                int targetEndMonth = timestepParams.unitAlignment;
                while (targetEndMonth + 3 < endDate.getMonthValue()) {
                    targetEndMonth += 3;
                }
                startDate = TimeseriesForecastingGuesser.alignDate(startDate, timestepParams.unitAlignment, false, new TimestepParams.TimeUnitQuantity(ChronoUnit.MONTHS, 12));
                endDate = TimeseriesForecastingGuesser.alignDate(endDate, targetEndMonth, true, new TimestepParams.TimeUnitQuantity(ChronoUnit.MONTHS, 12));
                break;
            }
            case HALF_YEAR: {
                int targetEndMonth = timestepParams.unitAlignment;
                while (targetEndMonth + 6 <= endDate.getMonthValue()) {
                    targetEndMonth += 6;
                }
                startDate = TimeseriesForecastingGuesser.alignDate(startDate, timestepParams.unitAlignment, false, new TimestepParams.TimeUnitQuantity(ChronoUnit.MONTHS, 12));
                endDate = TimeseriesForecastingGuesser.alignDate(endDate, targetEndMonth, true, new TimestepParams.TimeUnitQuantity(ChronoUnit.MONTHS, 12));
                break;
            }
        }
        return new Pair((Object)startDate, (Object)endDate.plus(timestepParams.timeunit.toTimeUnitQuantity().quantity, timestepParams.timeunit.toTimeUnitQuantity().unit));
    }

    private static void setResamplingDates(PredictionMLTask.TimeseriesForecastingMLTask task, MemTable table) {
        Date minDate = null;
        Date maxDate = null;
        int nRows = Math.min(10000, table.nrows());
        for (int i = 0; i < nRows; ++i) {
            MemRow row = table.rows.get(i);
            Date rowDate = TimeseriesForecastingGuesser.parseDate(row.get(table.column(task.timeVariable)));
            if (rowDate == null) continue;
            if (minDate == null || rowDate.before(minDate)) {
                minDate = rowDate;
            }
            if (maxDate != null && !rowDate.after(maxDate)) continue;
            maxDate = rowDate;
        }
        task.preprocessing.timeseriesSampling.setCustomStartDate(minDate);
        task.preprocessing.timeseriesSampling.setCustomEndDate(maxDate);
        task.customTrainTestIntervals = TimeseriesForecastingGuesser.guessCustomTrainTestIntervals(minDate, maxDate, task);
    }

    public static List<PredictionMLTask.TimeseriesForecastingMLTask.FoldInterval> guessCustomTrainTestIntervals(Date startDate, Date endDate, PredictionMLTask.TimeseriesForecastingMLTask task) {
        LocalDateTime startTrainDateTime = LocalDateTime.ofInstant(startDate.toInstant(), ZoneOffset.UTC);
        LocalDateTime endTestDateTime = LocalDateTime.ofInstant(endDate.toInstant(), ZoneOffset.UTC);
        TimestepParams.TimeUnitQuantity timeUnitQuantity = task.timestepParams.timeunit.toTimeUnitQuantity();
        long timeUnitDelta = task.timestepParams.numberOfTimeunits * task.predictionLength * (long)timeUnitQuantity.quantity;
        Pair<LocalDateTime, LocalDateTime> startAndEndDate = TimeseriesForecastingGuesser.alignStartAndEndDate(startTrainDateTime, endTestDateTime, task.timestepParams);
        startTrainDateTime = (LocalDateTime)startAndEndDate.first;
        endTestDateTime = (LocalDateTime)startAndEndDate.second;
        LocalDateTime startTestDateTime = task.timestepParams.timeunit == TimestepParams.Timeunit.BUSINESS_DAY ? TimeseriesForecastingGuesser.minusBusinessDays(endTestDateTime, timeUnitDelta) : endTestDateTime.minus(timeUnitDelta, timeUnitQuantity.unit);
        PredictionMLTask.TimeseriesForecastingMLTask.FoldInterval defaultCustomFoldInterval = new PredictionMLTask.TimeseriesForecastingMLTask.FoldInterval();
        DateTimeFormatter dtf = task.getDateTimeFormatter();
        defaultCustomFoldInterval.train = List.of(startTrainDateTime.format(dtf), startTestDateTime.format(dtf));
        defaultCustomFoldInterval.test = List.of(startTestDateTime.format(dtf), endTestDateTime.format(dtf));
        return List.of(defaultCustomFoldInterval);
    }
}

