/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.split;

import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.split.PredictionSplitGenerator;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSingleDatasetSplitGenerator
extends PredictionSplitGenerator {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;

    protected AbstractSingleDatasetSplitGenerator(MLTaskLoc taskLoc, AnalysisCoreParams coreParams, SplitParams params, AuthCtx authCtx) {
        super(taskLoc, coreParams, params, authCtx);
        assert (params.ttPolicy == SplitParams.TrainTestPolicy.SPLIT_SINGLE_DATASET);
    }

    protected DatasetLocUtils.DatasetLoc getDatasetLoc() {
        if (this.params.ssdDatasetSmartName == null) {
            return DatasetLocUtils.resolveSmart(this.coreParams.projectKey, this.coreParams.inputDatasetSmartName);
        }
        return DatasetLocUtils.resolveSmart(this.coreParams.projectKey, this.params.ssdDatasetSmartName);
    }

    @Override
    public String getExpectedInstanceId_NT() throws IOException {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(this.getDatasetLoc());
        }
        String md5 = DigestUtils.md5Hex((String)String.format("%s-%s-%s-%s", this.getPolicyId(), dataset.getSerializedJSONForSemanticComparison(), this.scriptStepsStr, JSON.json(this.coreParams.script.analysisColumnData)));
        return md5 + "-" + this.params.instanceIdRefresher;
    }
}

