/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import java.util.ArrayList;
import java.util.List;

public class PyKMeansMeta
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "KMeans (k=" + rpmp.k + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "k=" + rpmp.k;
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.KMeansParams km = task.modeling.kmeans_clustering;
        if (km.enabled) {
            checks.checkAllPositive(km.kValues(), "KMeans requires a (positive) number of clusters");
            checks.check(km.n_init > 0, "KMeans requires a non-zero number of initial centroids");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.KMeansParams km = task.modeling.kmeans_clustering;
        if (km.enabled) {
            for (int k : km.kValues()) {
                PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.KMEANS);
                rcmp.k = k;
                rcmp.allow_sparse_matrices = km.allow_sparse_matrices;
                rcmp.n_init = km.n_init;
                if (km.seed != 0) {
                    rcmp.seed = km.seed;
                }
                rcmp.n_jobs = km.n_jobs;
                ret.add(new WorkSet.ModelingSet(rcmp));
            }
        }
        return ret;
    }
}

