/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.utils.ErrorContext;

public class VectorFeaturePreprocessingParams
extends FeaturePreprocessingParams {
    public VectorHandlingMethod vector_handling;
    public MissingHandlingMethod missing_handling;
    public VectorImputationMethod missing_impute_with;
    public String impute_constant_value;

    public VectorFeaturePreprocessingParams() {
        this.type = FeaturePreprocessingParams.FeatureType.VECTOR;
    }

    public static VectorFeaturePreprocessingParams buildStdInput() {
        VectorFeaturePreprocessingParams ret = new VectorFeaturePreprocessingParams();
        ret.role = FeaturePreprocessingParams.Role.INPUT;
        ret.vector_handling = VectorHandlingMethod.UNFOLD;
        ret.missing_handling = MissingHandlingMethod.DROP_ROW;
        ret.missing_impute_with = VectorImputationMethod.MODE;
        return ret;
    }

    @Override
    public void check(String featureName, MLTask task) throws Exception {
        if (!this.role.isInput()) {
            return;
        }
        if (this.missing_handling == null) {
            throw ErrorContext.iaef((String)"Feature %s has no missing handling method", (Object)featureName, (Object[])new Object[0]);
        }
        if (this.vector_handling == null) {
            throw ErrorContext.iaef((String)"Feature %s has no vector handling method", (Object)featureName, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean usesCustomHandling() {
        return false;
    }

    public static enum VectorHandlingMethod {
        UNFOLD;

    }

    public static enum MissingHandlingMethod {
        NONE,
        DROP_ROW,
        IMPUTE;

    }

    public static enum VectorImputationMethod {
        MODE,
        CONSTANT;

    }
}

