/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.infra;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.SystemMetric;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.eventserver.dssmodel.EventServerSettings;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksWorkspaceDirectoryObject;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraChangedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraCreatedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraDeletedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelib.com.google.cloud.aiplatform.v1.AcceleratorType;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiNodeInfrasService
extends AbstractInfrasService<AbstractAPIServiceDeployment, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo, AbstractAPIDeploymentInfra> {
    private static final String CLOUD_K8S_FEATURE_FLAG = "dku.feature.cloudK8sDeployment.enabled";
    @Autowired
    private ApiNodeInfrasDAO deploymentInfrasDAO;
    @Autowired
    private APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private ApiNodeInfrasDAO apiNodeInfrasDAO;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;

    protected APIServiceDeploymentsService getDeploymentsService() {
        return this.apiServiceDeploymentsService;
    }

    protected ApiNodeInfrasDAO getDeploymentInfrasDAO() {
        return this.deploymentInfrasDAO;
    }

    public AbstractAPIDeploymentInfra createDeploymentInfra_NT(AuthCtx authCtx, AbstractDeploymentInfra.InfraType type, String infraId, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) throws UnauthorizedException {
        if (AbstractDeploymentInfra.InfraType.STATIC.equals((Object)type)) {
            return new StaticAPIDeploymentInfra(infraId, stage, userIdentifier, governCheckPolicy);
        }
        if (AbstractDeploymentInfra.InfraType.K8S.equals((Object)type)) {
            return this.createK8SDeploymentInfra(authCtx, infraId, stage, userIdentifier, governCheckPolicy);
        }
        if (List.of(AbstractDeploymentInfra.InfraType.AZURE_ML, AbstractDeploymentInfra.InfraType.DATABRICKS, AbstractDeploymentInfra.InfraType.SAGEMAKER, AbstractDeploymentInfra.InfraType.SNOWPARK, AbstractDeploymentInfra.InfraType.VERTEX_AI).contains((Object)type)) {
            return AbstractFullyManagedAPIDeploymentInfra.buildFullyManagedInfraWithDefaultValues_NT(type, infraId, stage, userIdentifier, governCheckPolicy);
        }
        throw ErrorContext.iae((String)("Unsupported infra type: " + String.valueOf((Object)type)));
    }

    @Nonnull
    private K8SAPIDeploymentInfra createK8SDeploymentInfra(AuthCtx authCtx, String infraId, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) throws UnauthorizedException {
        GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings cloudK8sSettings;
        if (!DKUApp.isDataikuCloud()) {
            K8SAPIDeploymentInfra k8sInfra = K8SAPIDeploymentInfra.buildDefault_NT(infraId, stage, userIdentifier, governCheckPolicy);
            k8sInfra.setRegistryHost(this.getDefaultRegistryHost(authCtx, k8sInfra));
            return k8sInfra;
        }
        this.ensureCloudK8sDeploymentAllowed();
        try (Transaction ignored = this.transactionService.beginRead();){
            cloudK8sSettings = ApplicationConfigurator.getGeneralSettings().dataikuCloudK8SApiDeploymentSettings;
        }
        if (cloudK8sSettings == null) {
            throw ErrorContext.ice((String)"Default Kubernetes cluster infrastructure settings are not set. Contact your administrator.");
        }
        this.decryptApiKeyIfPresent(cloudK8sSettings);
        return K8SAPIDeploymentInfra.buildDefaultForCloud_NT(infraId, stage, userIdentifier, governCheckPolicy, cloudK8sSettings);
    }

    private void ensureCloudK8sDeploymentAllowed() throws UnauthorizedException {
        boolean isCloudK8sInfraCreationEnabled = DKUApp.getParams().getBoolParam(CLOUD_K8S_FEATURE_FLAG, false);
        if (!isCloudK8sInfraCreationEnabled) {
            throw new UnauthorizedException("Creation of Kubernetes cluster infrastructures is restricted. Contact your administrator if you need access.", "denied");
        }
    }

    private void decryptApiKeyIfPresent(@Nonnull GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings cloudK8sSettings) {
        if (cloudK8sSettings.activityMonitoringSettings == null || cloudK8sSettings.activityMonitoringSettings.apiKey == null) {
            return;
        }
        cloudK8sSettings.activityMonitoringSettings.apiKey = this.passwordEncryptionService.decryptIfEncrypted(cloudK8sSettings.activityMonitoringSettings.apiKey);
    }

    private String getDefaultRegistryHost(AuthCtx authCtx, K8SAPIDeploymentInfra k8sInfra) {
        try {
            ClusterSettings clusterSettings = new ClusterSelector().selectForAPIDeployer(authCtx, k8sInfra);
            ContainerExecRuntimeConfig configOverrides = clusterSettings.getContainerSettings().getByNameOrNull(clusterSettings.getContainerSettings().defaultExecutionConfig);
            if (configOverrides == null) {
                return "";
            }
            return configOverrides.repositoryURL;
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Could not retrieve the default registry host", (Throwable)e);
            return "";
        }
    }

    public List<String> getAzureMLInstanceTypes_NT(AuthCtx authCtx, String authConnection, String infraId, String azWorkspace, String azResourceGroup, String azSubscription) throws IOException, InterruptedException, DKUSecurityException, AzureMLUtils.AzureAuthenticationException {
        AbstractAPIDeploymentInfra infra = this.getApiNodeInfra_CheckRead(authCtx, infraId);
        List<String> instanceTypes = new ArrayList<String>();
        if (infra instanceof AzureMLAPIDeploymentInfra) {
            String workspace = StringUtils.defaultIfBlank((String)azWorkspace, (String)((AzureMLAPIDeploymentInfra)infra).azWorkspace);
            String resourceGroup = StringUtils.defaultIfBlank((String)azResourceGroup, (String)((AzureMLAPIDeploymentInfra)infra).azResourceGroup);
            String subscription = StringUtils.defaultIfBlank((String)azSubscription, (String)((AzureMLAPIDeploymentInfra)infra).azSubscription);
            String connection = StringUtils.defaultIfBlank((String)authConnection, (String)((AzureMLAPIDeploymentInfra)infra).authConnection);
            if (Strings.isNotEmpty((String)workspace) && Strings.isNotEmpty((String)resourceGroup) && Strings.isNotEmpty((String)subscription)) {
                try (AzureMLUtils.AzureSession session = AzureMLUtils.loginOrCheckAzure_NT(authCtx, connection);){
                    Optional<AzureMLUtils.BasicWorkspace> basicWorkspace = AzureMLUtils.retrieveWorkspace_NT(session, workspace, resourceGroup, subscription);
                    if (basicWorkspace.isPresent()) {
                        instanceTypes = AzureMLUtils.getInstanceTypes_NT(session, basicWorkspace.get().location, subscription);
                    }
                    this.getLogger().debugV("Instance types not requested to AzureML since workspace %s does not exist.", new Object[]{workspace});
                }
            } else {
                this.getLogger().debugV("Instance types not requested to AzureML since workspace='%s' or resourceGroup='%s' or subscription='%s' are blank.", new Object[]{workspace, resourceGroup, subscription});
            }
        } else {
            throw ErrorContext.iae((String)"The infra provided is not an AzureML infrastructure.");
        }
        return instanceTypes;
    }

    public List<String> getVertexAIInstanceTypes_NT(@Nonnull AuthCtx authCtx, @Nullable String authConnection, @Nonnull String infraId, @Nullable String gcpProject, @Nullable String gcpRegion) throws IOException, DKUSecurityException, URISyntaxException {
        AbstractAPIDeploymentInfra infra = this.getApiNodeInfra_CheckRead(authCtx, infraId);
        if (infra instanceof VertexAIAPIDeploymentInfra) {
            VertexAIAPIDeploymentInfra vertexInfra = (VertexAIAPIDeploymentInfra)infra;
            String project = StringUtils.defaultIfBlank((String)gcpProject, (String)vertexInfra.gcpProjectId);
            String region = StringUtils.defaultIfBlank((String)gcpRegion, (String)vertexInfra.gcpRegion);
            String connection = StringUtils.defaultIfBlank((String)authConnection, (String)vertexInfra.authConnection);
            if (Strings.isNotEmpty((String)project) && Strings.isNotEmpty((String)region)) {
                VertexAIModelDeploymentConnection vertexConnection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connection);
                GoogleCredentials credentials = VertexAIUtils.getGoogleCredentials_NT(authCtx, vertexConnection);
                Set<String> machineTypes = VertexAIUtils.from(region, project, credentials, vertexConnection).getMachineTypes_NT();
                return machineTypes.stream().sorted(ApiNodeInfrasService.getMachineTypesComparator()).collect(Collectors.toList());
            }
            this.getLogger().debugV("Instance types not requested to VertexAI since GCP project='%s' or region='%s' are blank.", new Object[]{project, region});
            return Lists.newArrayList();
        }
        throw ErrorContext.iae((String)"The infra provided is not an VertexAI infrastructure.");
    }

    public LocalEventServerExtUrlAndKeys getLocalEventServerExtUrlAndKeys(boolean forK8s, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        GeneralSettingsService.AppConfig appConfig;
        GeneralSettingsDAO.GeneralSettings generalSettings;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            generalSettings = ApplicationConfigurator.getGeneralSettings();
            appConfig = this.generalSettingsService.getConfigurationInternal(req, resp);
        }
        boolean eventServerEnabled = appConfig.eventServerEnabled;
        String eventServerUrl = "";
        List<EventServerSettings.EventServerAuthKey> authKeys = new ArrayList<EventServerSettings.EventServerAuthKey>();
        if (eventServerEnabled && StringUtils.isNotBlank((String)(eventServerUrl = RemoteRunNetworkingUtils.guessLocalEventServerExtUrl(forK8s))) && generalSettings.eventServerSettings != null) {
            authKeys = generalSettings.eventServerSettings.eventsAuthenticationKeys;
        }
        return new LocalEventServerExtUrlAndKeys(eventServerEnabled, eventServerUrl, authKeys);
    }

    @Nonnull
    private static Comparator<String> getMachineTypesComparator() {
        return (type1, type2) -> {
            String prefixPower2;
            String[] elems1 = type1.split("-");
            String[] elems2 = type2.split("-");
            if (elems1.length < 3 || elems2.length < 3) {
                return type1.compareTo((String)type2);
            }
            String prefixPower1 = elems1[0] + "-" + elems1[1];
            if (!prefixPower1.equals(prefixPower2 = elems2[0] + "-" + elems2[1])) {
                return prefixPower1.compareTo(prefixPower2);
            }
            try {
                int number1 = Integer.parseInt(elems1[2].replaceAll("\\D", ""));
                int number2 = Integer.parseInt(elems2[2].replaceAll("\\D", ""));
                if (number1 != number2) {
                    return number1 - number2;
                }
            }
            catch (NumberFormatException exception) {
                return type1.compareTo((String)type2);
            }
            return type1.compareTo((String)type2);
        };
    }

    public String getInfraAuthConnection(AuthCtx authCtx, String infraId) throws UnauthorizedException, IOException {
        AbstractAPIDeploymentInfra infra = this.getApiNodeInfra_CheckRead(authCtx, infraId);
        if (infra instanceof AbstractFullyManagedAPIDeploymentInfra) {
            return ((AbstractFullyManagedAPIDeploymentInfra)infra).authConnection;
        }
        return null;
    }

    public List<String> getSageMakerInstanceTypes() {
        return SageMakerUtils.getInstanceTypes();
    }

    public List<AcceleratorType> getVertexAIAcceleratorTypes() {
        return VertexAIUtils.getAcceleratorTypes();
    }

    public List<String> getDatabricksWorkloadTypes() {
        return DatabricksUtils.getWorkloadTypes();
    }

    public List<String> getDatabricksWorkloadSizeTypes() {
        return DatabricksUtils.getWorkloadSizeTypes();
    }

    public FutureResponse<SortedSet<DatabricksWorkspaceDirectoryObject>> getDatabricksExperimentLocationSuggestions(@Nonnull AuthCtx authCtx, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws Exception {
        return DatabricksUtils.startListExperimentLocationSuggestions_NT((DSSAuthCtx)authCtx, connectionName, connectTimeout, socketTimeout);
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_Check_NT(AuthCtx authCtx, String infraId) throws IOException, DKUSecurityException {
        AbstractAPIDeploymentInfra infra = this.getApiNodeInfra_CheckRead(authCtx, infraId);
        ApiNodeInfraManager infraManager = infra.getInfraManager(this.getLogger());
        return infraManager.checkInfraStatus_NT(authCtx);
    }

    public AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo basicInfoUnsafe(AbstractAPIDeploymentInfra infra) {
        if (infra instanceof K8SAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.K8SAPIDeploymentInfraBasicInfo((K8SAPIDeploymentInfra)infra);
        }
        if (infra instanceof StaticAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.StaticAPIDeploymentInfraBasicInfo((StaticAPIDeploymentInfra)infra);
        }
        if (infra instanceof AzureMLAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.AzureMLAPIDeploymentInfraBasicInfo((AzureMLAPIDeploymentInfra)infra);
        }
        if (infra instanceof DatabricksAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.DatabricksAPIDeploymentInfraBasicInfo((DatabricksAPIDeploymentInfra)infra);
        }
        if (infra instanceof SageMakerAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.SageMakerAPIDeploymentInfraBasicInfo((SageMakerAPIDeploymentInfra)infra);
        }
        if (infra instanceof SnowparkAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.SnowparkAPIDeploymentInfraBasicInfo((SnowparkAPIDeploymentInfra)infra);
        }
        if (infra instanceof VertexAIAPIDeploymentInfra) {
            return new AbstractInfraBasicInfo.VertexAIAPIDeploymentInfraBasicInfo((VertexAIAPIDeploymentInfra)infra);
        }
        throw ErrorContext.iaef((String)"Infrastructure type is invalid: %s", (Object)JSON.getType((Object)infra), (Object[])new Object[0]);
    }

    @Override
    public List<AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo> listBasicInfoUnsafe_Check(AuthCtx authCtx) throws IOException {
        return this.getDeploymentInfrasDAO().listUnsafe().stream().filter(infra -> ApiNodeInfrasService.hasReadPermission(infra, authCtx)).map(this::basicInfoUnsafe).collect(Collectors.toList());
    }

    public AbstractAPIDeploymentInfra getApiNodeInfra_CheckRead(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException {
        AbstractAPIDeploymentInfra infra;
        try (Transaction ignored = this.transactionService.beginRead();){
            infra = (AbstractAPIDeploymentInfra)this.deploymentInfrasDAO.getMandatoryUnsafe(infraId);
        }
        if (!ApiNodeInfrasService.hasReadPermission(infra, authCtx)) {
            throw new UnauthorizedException("You may not read this infrastructure", this.getExceptionTypePrefix() + "infrastructure-action-denied");
        }
        return infra;
    }

    @Override
    protected void publishInfraCreationEventAfterTransaction(String infraId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerInfraCreatedEvent(infraId));
    }

    @Override
    protected void publishInfraChangedEventAfterTransaction(String infraId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerInfraChangedEvent(infraId));
    }

    @Override
    protected void publishInfraDeletedEventAfterTransaction(String infraId, AbstractDeploymentInfra.InfraType infraType) {
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerInfraDeletedEvent(infraId, infraType));
    }

    @Override
    protected String getExceptionTypePrefix() {
        return "mad-";
    }

    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetricsIfNeeded(AuthCtx authCtx, String infraId, int connectTimeout, int socketTimeout, String overridingConnectionName) throws Exception {
        AbstractAPIDeploymentInfra infra = this.getApiNodeInfra_CheckRead(authCtx, infraId);
        if (!(infra.activityMonitoringSettings instanceof ActivityMonitoringSettings.Pull)) {
            this.getLogger().infoV("Infra %s is not in Pull mode, not pulling the metrics from it.", new Object[]{infraId});
            return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
        }
        if (infra.activityMonitoringSettings.mode == ActivityMonitoringSettings.Mode.DISABLED) {
            this.getLogger().infoV("Activity monitoring is disabled for infra %s, not pulling the metrics from it.", new Object[]{infraId});
            return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
        }
        ApiNodeInfraManager infraManager = infra.getInfraManager(this.getLogger());
        return infraManager.getActivityMetrics_NT(authCtx, connectTimeout, socketTimeout, overridingConnectionName);
    }

    public SystemMetric.TimeAndMetricsByDeployment getSystemMetricsIfNeeded(AuthCtx authCtx, String infraId, int connectTimeout, int socketTimeout, String overridingConnectionName) throws Exception {
        AbstractAPIDeploymentInfra infra = this.getApiNodeInfra_CheckRead(authCtx, infraId);
        AbstractDeploymentInfra.InfraType infraType = infra.getInfraType();
        if (!this.hasSystemMetrics(infraType)) {
            throw ErrorContext.isef((String)"System metrics collection is not available for infrastructures of type %s", (Object)((Object)infraType), (Object[])new Object[0]);
        }
        if (infra.activityMonitoringSettings.mode == ActivityMonitoringSettings.Mode.DISABLED) {
            this.getLogger().infoV("System monitoring is disabled for infra %s, not pulling the metrics from it.", new Object[]{infraId});
            return new SystemMetric.TimeAndMetricsByDeployment.None();
        }
        ApiNodeInfraManager infraManager = infra.getInfraManager(this.getLogger());
        return infraManager.getSystemMetrics_NT(authCtx, connectTimeout, socketTimeout, overridingConnectionName);
    }

    public boolean hasSystemMetrics(AuthCtx authCtx, String infraId) {
        AbstractInfraBasicInfo infra;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            infra = this.getLightStatusUnsafe_Check(infraId, authCtx).getInfraBasicInfo();
        }
        catch (UnauthorizedException | IOException e) {
            this.getLogger().warnV(e, "Failed to get infra %s", new Object[]{infraId});
            return false;
        }
        return this.hasSystemMetrics(infra);
    }

    public boolean hasSystemMetrics(AbstractInfraBasicInfo infraBasicInfo) {
        return infraBasicInfo != null && this.hasSystemMetrics(infraBasicInfo.getInfraType());
    }

    public boolean hasSystemMetrics(AbstractDeploymentInfra.InfraType infraType) {
        return List.of(AbstractDeploymentInfra.InfraType.K8S, AbstractDeploymentInfra.InfraType.STATIC).contains((Object)infraType);
    }

    @Override
    protected DKULogger getLogger() {
        return DKULogger.getLogger((String)"dku.mad.infras.service");
    }

    public static class LocalEventServerExtUrlAndKeys {
        String eventServerExtUrl;
        List<EventServerSettings.EventServerAuthKey> authKeys;
        boolean isLocalEventServerEnabled;

        public LocalEventServerExtUrlAndKeys(boolean isLocalEventServerEnabled, String eventServerExtUrl, List<EventServerSettings.EventServerAuthKey> authKeys) {
            this.isLocalEventServerEnabled = isLocalEventServerEnabled;
            this.eventServerExtUrl = eventServerExtUrl;
            this.authKeys = authKeys;
        }
    }
}

