/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.badges;

import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.badges.TypeBadges;
import com.dataiku.dip.badges.TypeBadgesSyncResult;
import com.dataiku.dip.lambda.mgmt.FilesBasedLambdaServicesDAO;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiServiceTypeBadgesService {
    private final List<LambdaEndpointConfig.EndpointType> ML_BADGE_ENDPOINT_TYPES = List.of(LambdaEndpointConfig.EndpointType.STD_PREDICTION, LambdaEndpointConfig.EndpointType.STD_CLUSTERING, LambdaEndpointConfig.EndpointType.STD_CAUSAL_PREDICTION, LambdaEndpointConfig.EndpointType.CUSTOM_PREDICTION, LambdaEndpointConfig.EndpointType.CUSTOM_R_PREDICTION);
    private final TransactionService transactionService;
    private final FilesBasedLambdaServicesDAO lambdaServicesDAO;
    private final PubSubService pubSubService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.badges.api-service-type-badges-service");

    @Autowired
    public ApiServiceTypeBadgesService(TransactionService transactionService, FilesBasedLambdaServicesDAO lambdaServicesDAO, PubSubService pubSubService) {
        this.transactionService = transactionService;
        this.lambdaServicesDAO = lambdaServicesDAO;
        this.pubSubService = pubSubService;
    }

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("object-change", this::handleTaggableObjectChangedEvent);
    }

    public List<TypeBadge> listBadges(String projectKey) throws IOException {
        List<LambdaService> lambdaServices;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            lambdaServices = this.lambdaServicesDAO.list_noTag(projectKey, false);
        }
        return lambdaServices.stream().map(lambdaService -> lambdaService.typeBadges.keySet()).flatMap(Collection::stream).collect(Collectors.toSet()).stream().toList();
    }

    public TypeBadgesSyncResult synchronizeBadges_NT(String projectKey) throws IOException {
        List<LambdaService> lambdaServices;
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Synchronizing Type Badges for the API services of project %s", new Object[]{projectKey});
        try (Transaction t = this.transactionService.beginRead();){
            lambdaServices = this.lambdaServicesDAO.list_noTag(projectKey, false);
        }
        int nSuccesses = 0;
        int nFailures = 0;
        for (LambdaService lambdaService : lambdaServices) {
            try {
                this.synchronizeBadge_NT(projectKey, lambdaService);
                ++nSuccesses;
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to synchronize Type Badges for API service %s in project %s", new Object[]{lambdaService.getId(), projectKey});
                ++nFailures;
            }
        }
        return new TypeBadgesSyncResult(nSuccesses, nFailures);
    }

    private void synchronizeBadge_NT(String projectKey, LambdaService lambdaService) throws IOException {
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            lambdaService.typeBadges = this.computeBadges(lambdaService);
            this.lambdaServicesDAO.save_noCode(lambdaService);
            t.commitV("Updated badges of API service %s in project %s", new Object[]{lambdaService.getId(), projectKey});
        }
    }

    public List<TypeBadge> getEndpointBadges(LambdaEndpointConfig.EndpointType endpointType, List<String> tags) {
        HashSet<TypeBadge> badges = new HashSet<TypeBadge>();
        if (this.ML_BADGE_ENDPOINT_TYPES.contains((Object)endpointType)) {
            badges.add(TypeBadge.ML);
        }
        if (tags.contains("type-ml")) {
            badges.add(TypeBadge.ML);
        }
        if (tags.contains("type-llm")) {
            badges.add(TypeBadge.LLM);
        }
        if (tags.contains("type-agent")) {
            badges.add(TypeBadge.AGENT);
        }
        return new ArrayList<TypeBadge>(badges);
    }

    @VisibleForTesting
    TypeBadges computeBadges(LambdaService lambdaService) {
        logger.infoV("Starting the computation of Type Badges for API service %s in project %s", new Object[]{lambdaService.getId(), lambdaService.getProjectKey()});
        TypeBadges typeBadges = new TypeBadges();
        for (DSSLambdaEndpointConfig endpointConfig : lambdaService.endpoints) {
            List<TypeBadge> endpointBadges = this.getEndpointBadges(endpointConfig.type, endpointConfig.tags);
            endpointBadges.forEach(badge -> typeBadges.addToContributors((TypeBadge)badge, endpointConfig.id));
        }
        logger.infoV("Finished computing Type Badges for API service %s in project %s", new Object[]{lambdaService.getId(), lambdaService.getProjectKey()});
        return typeBadges;
    }

    private void handleTaggableObjectChangedEvent(TaggableObjectChangedEvent event) throws IOException {
        LambdaService lambdaService;
        if (!Objects.equals((Object)event.objectType, (Object)ITaggingService.TaggableType.LAMBDA_SERVICE)) {
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            lambdaService = this.lambdaServicesDAO.getOrNull_noTag(event.projectKey, event.objectId, false);
        }
        this.synchronizeBadge_NT(event.projectKey, lambdaService);
    }
}

