/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.JSON;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class BuildCommand
extends CLICommand {
    private static Logger logger = Logger.getLogger((String)"dku.cli.build");

    @Override
    public Options opts() {
        Options opts = new Options();
        opts.addOption("n", false, "Dry run");
        opts.addOption("R", false, "Recurse and compute dependencies, prune unneeded tasks");
        opts.addOption("m", "missing-only", false, "Recurse and compute dependencies, only build 'missing' datasets/partitions");
        opts.addOption("f", "forced", false, "Recurse and compute dependencies, rebuild all");
        opts.addOption("ms", "hive-metastore", true, "Synchronize Hive metastore");
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public String usageString() {
        return "dku build [options] dataset=partition [dataset=partition...]";
    }

    @Override
    public String description() {
        return "Compute a partition of a dataset, using the DIP recipes";
    }

    @Override
    public int execute(String[] args) throws Exception {
        String dp;
        int i;
        ApplicationConfigurator.autoconfigure();
        CommandLine cmdLine = new DefaultParser().parse(this.opts(), args);
        if (cmdLine.hasOption('h')) {
            return this.usage(0, null);
        }
        assert (cmdLine.getArgs().length >= 1);
        assert (cmdLine.getArgs()[0].equals("build"));
        CLISetup.setupVerbose(cmdLine);
        JobDef newJob = new JobDef();
        newJob.initiator = System.getProperty("user.name") + " (cli)";
        newJob.initiationTimestamp = System.currentTimeMillis();
        if (cmdLine.getArgs().length == 1) {
            return this.usage(1, "Missing output dataset=partition");
        }
        newJob.name = "build";
        for (i = 1; i < cmdLine.getArgList().size(); ++i) {
            dp = cmdLine.getArgs()[i];
            newJob.name = newJob.name + "_" + dp.replace("=", "_").replace("/", "_");
            newJob.projectKey = dp.split("\\.")[0];
        }
        newJob.name = newJob.name.substring(0, Math.min(newJob.name.length(), 200));
        for (i = 1; i < cmdLine.getArgList().size(); ++i) {
            DatasetLocUtils.DatasetLoc loc;
            dp = cmdLine.getArgs()[i];
            String[] chunks = dp.split("=");
            if (chunks.length == 1) {
                loc = DatasetLocUtils.resolveSmart(null, chunks[0]);
                newJob.outputs.add(new JobDef.JobOutput(loc.getProjectKey(), loc.getName(), null));
                continue;
            }
            if (chunks.length == 2) {
                loc = DatasetLocUtils.resolveSmart(null, chunks[0]);
                newJob.outputs.add(new JobDef.JobOutput(loc.getProjectKey(), loc.getName(), chunks[1]));
                continue;
            }
            return this.usage(2, "Bad format for output : " + dp + ", expected dataset=partition");
        }
        newJob.type = cmdLine.hasOption("R") ? JobDef.JobType.RECURSIVE_BUILD : (cmdLine.hasOption("f") ? JobDef.JobType.RECURSIVE_FORCED_BUILD : (cmdLine.hasOption("m") ? JobDef.JobType.RECURSIVE_MISSING_ONLY_BUILD : JobDef.JobType.NON_RECURSIVE_FORCED_BUILD));
        newJob.refreshHiveMetastore = false;
        if (cmdLine.hasOption("ms")) {
            newJob.refreshHiveMetastore = true;
        }
        logger.info((Object)"Requesting job start");
        try (LocalBackendPrivilegedIntercomAPIClient kac = new LocalBackendPrivilegedIntercomAPIClient();){
            JobState finalState;
            Id id = (Id)kac.postFormToJSON("/dip/api/intercom/jobs/start", Id.class, new Object[]{"data", JSON.json((Object)newJob)});
            logger.info((Object)("Job started: " + id.id));
            logger.info((Object)("Job log file: " + FlowJobUtils.jobLogFile(false, newJob.projectKey, id.id).getAbsolutePath()));
            logger.info((Object)"Waiting for end of job ...");
            while (true) {
                try {
                    EnhancedSerializedJobStatus sjs = (EnhancedSerializedJobStatus)kac.postFormToJSON("/dip/api/intercom/jobs/get-job-status", EnhancedSerializedJobStatus.class, new Object[]{"projectKey", newJob.projectKey, "jobId", id.id});
                    finalState = sjs.baseStatus.state;
                    logger.info((Object)String.valueOf((Object)finalState));
                    if (finalState == JobState.ABORTED || finalState == JobState.DONE || finalState == JobState.FAILED) {
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to get status: " + e.getMessage()));
                }
                Thread.sleep(3000L);
            }
            logger.info((Object)"Job done executing");
            int n = finalState != null && finalState == JobState.DONE ? 0 : 1;
            return n;
        }
    }
}

