/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class EnableSparkCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark");

    @Override
    public String usageString() {
        return "__enable-spark";
    }

    @Override
    public String description() {
        return "";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "__enable-spark", true);
        CLISetup.doSpringUtilsAndCoreServicesSetup();
        boolean forceRegen = "1".equals(cmdLine.getArgs()[1]);
        boolean forK8S = "1".equals(cmdLine.getArgs()[2]);
        try (DKUTransactionService ts = new DKUTransactionService();
             RWTransaction rwt = ts.beginWriteAsDSS();){
            GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)rwt.readObject("general-settings.json", GeneralSettingsDAO.GeneralSettings.class);
            SparkSettings ss = gs.sparkSettings;
            if (ss == null) {
                gs.sparkSettings = ss = new SparkSettings();
            }
            if (ss.sparkEnabled) {
                logger.warn((Object)"Spark is already enabled");
            }
            ss.sparkEnabled = true;
            if (ss.executionConfigs.size() > 0 && !forceRegen) {
                logger.warn((Object)"Execution configs already exist, not overriding");
            } else {
                ArrayList secs;
                ss.executionConfigs.clear();
                ss.additionalSparkSubmitJars.clear();
                if (forK8S) {
                    sec = new SparkExecutionConfig();
                    ((SparkExecutionConfig)sec).name = "default";
                    ((SparkExecutionConfig)sec).description = "This default configuration sets a few parameters that are suitable for a wide range of use cases.\n\nIt is designed to run on Kubernetes";
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.executor.memory", "3g"));
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.sql.shuffle.partitions", "40"));
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.kubernetes.memoryOverheadFactor", "0.2"));
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.port.maxRetries", "200"));
                    ss.executionConfigs.add((SparkExecutionConfig)sec);
                    SparkExecutionConfig localSample = new SparkExecutionConfig();
                    localSample.name = "sample-local-config";
                    localSample.description = "This sample configuration shows a possible set of parameters for running DSS Spark jobs locally (non distributed).\n\nThis can be useful for testing on small jobs but is not usually suitable for production usage";
                    localSample.conf.add(new ClusterProperty("spark.master", "local[4]"));
                    localSample.conf.add(new ClusterProperty("spark.driver.memory", "3g"));
                    localSample.conf.add(new ClusterProperty("spark.sql.shuffle.partitions", "40"));
                    localSample.conf.add(new ClusterProperty("spark.port.maxRetries", "200"));
                    ss.executionConfigs.add(localSample);
                    secs = Lists.newArrayList((Object[])new SparkExecutionConfig[]{sec, localSample});
                } else {
                    sec = new SparkExecutionConfig();
                    ((SparkExecutionConfig)sec).name = "default";
                    ((SparkExecutionConfig)sec).description = "This default configuration sets a few parameters that are suitable for a wide range of use cases.\n\nImportantly, in order to work in all circumstances, it does not set the spark master configuration.\nIt will thus use the master defined by your default Spark configuration. This may lead Spark jobs to execute locally, without using your cluster. You may need for example to add spark.master=yarn-client";
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.executor.memory", "2400m"));
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.sql.shuffle.partitions", "40"));
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.executor.memoryOverhead", "600"));
                    ((SparkExecutionConfig)sec).conf.add(new ClusterProperty("spark.port.maxRetries", "200"));
                    ss.executionConfigs.add((SparkExecutionConfig)sec);
                    SparkExecutionConfig yarnSample = new SparkExecutionConfig();
                    yarnSample.name = "sample-yarn-config";
                    yarnSample.description = "This sample configuration shows a possible set of parameters for running DSS Spark jobs on YARN.\n\nThese settings are suitable for a small cluster. You will need to tune spark.executor.instances, spark.executor.cores and memory settings based on the size of your YARN cluster";
                    yarnSample.conf.add(new ClusterProperty("spark.master", "yarn"));
                    yarnSample.conf.add(new ClusterProperty("spark.submit.deployMode", "client"));
                    yarnSample.conf.add(new ClusterProperty("spark.executor.memory", "4g"));
                    yarnSample.conf.add(new ClusterProperty("spark.executor.instances", "4"));
                    yarnSample.conf.add(new ClusterProperty("spark.executor.cores", "2"));
                    yarnSample.conf.add(new ClusterProperty("spark.sql.shuffle.partitions", "40"));
                    yarnSample.conf.add(new ClusterProperty("spark.executor.memoryOverhead", "1200"));
                    yarnSample.conf.add(new ClusterProperty("spark.port.maxRetries", "200"));
                    ss.executionConfigs.add(yarnSample);
                    SparkExecutionConfig localSample = new SparkExecutionConfig();
                    localSample.name = "sample-local-config";
                    localSample.description = "This sample configuration shows a possible set of parameters for running DSS Spark jobs locally (non distributed).\n\nThis can be useful for testing on small jobs, as local Spark jobs start faster than YARN ones, but is not suitable for production usage";
                    localSample.conf.add(new ClusterProperty("spark.master", "local[4]"));
                    localSample.conf.add(new ClusterProperty("spark.driver.memory", "3g"));
                    localSample.conf.add(new ClusterProperty("spark.sql.shuffle.partitions", "40"));
                    localSample.conf.add(new ClusterProperty("spark.port.maxRetries", "200"));
                    ss.executionConfigs.add(localSample);
                    secs = Lists.newArrayList((Object[])new SparkExecutionConfig[]{sec, yarnSample, localSample});
                }
                ss.configForJupyter = "default";
                ss.configForSEK = "default";
                if (HadoopLoader.hadoopEnabled()) {
                    if (HadoopFlavorUtils.isHDP3()) {
                        for (SparkExecutionConfig ec : secs) {
                            ec.conf.add(new ClusterProperty("spark.sql.hive.metastore.jars", "builtin"));
                            boolean isAtLeast315 = false;
                            String hdpVersion = System.getProperty("hdp.version", "3.0");
                            if (hdpVersion.startsWith("3.1.")) {
                                String rev = hdpVersion.substring("3.1.".length());
                                if (rev.indexOf(46) > 0) {
                                    rev = rev.substring(0, rev.indexOf(46));
                                }
                                try {
                                    int revInt = Integer.parseInt(rev);
                                    isAtLeast315 = revInt >= 5;
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Unexpected hdp version " + hdpVersion));
                                }
                            }
                            if (isAtLeast315) {
                                ec.conf.add(new ClusterProperty("spark.sql.hive.metastore.version", "1.2.2"));
                                continue;
                            }
                            ec.conf.add(new ClusterProperty("spark.sql.hive.metastore.version", "1.2.1"));
                        }
                    } else if (HadoopFlavorUtils.isCDHAtLeast6()) {
                        File f;
                        String hiveCP = System.getenv("DKU_HIVE_CP");
                        ArrayList extraJarsForMetastore = Lists.newArrayList();
                        if (!StringUtils.isBlank((String)hiveCP)) {
                            for (String jar : DKUtils.parseClassPath((String)hiveCP)) {
                                f = new File(jar);
                                if (!f.getName().contains("datanucleus") && !f.getName().contains("jdo-") && !f.getName().contains("-dbcp-") && !f.getName().contains("antlr-")) continue;
                                ss.additionalSparkSubmitJars.add(jar);
                                extraJarsForMetastore.add(jar);
                            }
                        }
                        if (HadoopFlavorUtils.isCDH7AtLeast(7, 3, 0) && !StringUtils.isBlank((String)hiveCP)) {
                            for (String jar : DKUtils.parseClassPath((String)hiveCP)) {
                                f = new File(jar);
                                if (!f.getName().contains("jetty-server")) continue;
                                extraJarsForMetastore.add(jar);
                            }
                        }
                        if ((double)HadoopFlavorUtils.getCDHVersion() >= 6.3) {
                            File sparkHive;
                            ArrayList cp = Lists.newArrayList();
                            File sparkJars = new File(System.getenv("DKU_SPARK_HOME"), "jars");
                            if (sparkJars.exists()) {
                                cp.add(sparkJars.getAbsolutePath() + "/*");
                            }
                            if ((sparkHive = new File(System.getenv("DKU_SPARK_HOME"), "hive")).exists()) {
                                cp.add(sparkHive.getAbsolutePath() + "/*");
                            }
                            cp.addAll(extraJarsForMetastore);
                            for (SparkExecutionConfig ec : secs) {
                                ec.conf.add(new ClusterProperty("spark.sql.hive.metastore.jars", Joiner.on((String)":").join((Iterable)cp)));
                            }
                        }
                        if (HadoopFlavorUtils.isCDH7()) {
                            for (SparkExecutionConfig ec : secs) {
                                ec.conf.add(new ClusterProperty("spark.hadoop.hive.metastore.transactional.event.listeners", ""));
                            }
                            String hive3Shims = DKUApp.getInstallFile((String[])new String[]{"lib", "shims", "hive3-shims.jar"}).getAbsolutePath();
                            if (!ss.additionalSparkSubmitJars.stream().anyMatch(j -> j.equals(hive3Shims))) {
                                ss.additionalSparkSubmitJars.add(hive3Shims);
                            }
                        }
                    }
                }
            }
            rwt.writeObject("general-settings.json", (Object)gs);
            rwt.commit("CLI: Enabled Spark (from command-line)");
        }
        return 0;
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }
}

