/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ContainerOverrideMask {
    public boolean enabled;
    public boolean properties;
    public boolean defaultWebappsK8SExposition;

    public static ContainerOverrideMask fromJsonObject(JsonObject settings) {
        ContainerOverrideMask mask = new ContainerOverrideMask();
        if (settings == null) {
            return mask;
        }
        mask.enabled = true;
        if (settings.has("executionConfigs") && !settings.get("executionConfigs").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("executionConfigsGenericOverrides") && !settings.get("executionConfigsGenericOverrides").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("defaultWebappsK8SExposition") && !settings.get("defaultWebappsK8SExposition").isJsonNull()) {
            mask.defaultWebappsK8SExposition = true;
        }
        return mask;
    }

    public ContainerSettings apply(ContainerSettings base, ContainerSettings overrides) {
        ContainerSettings overriden = (ContainerSettings)JSON.deepCopy((Object)base);
        if (!this.enabled) {
            return overriden;
        }
        if (this.properties) {
            overriden.executionConfigsGenericOverrides = overrides.executionConfigsGenericOverrides;
            HashMap baseConfigs = Maps.newHashMap();
            for (ContainerExecRuntimeConfig containerExecRuntimeConfig : base.executionConfigs) {
                baseConfigs.put(containerExecRuntimeConfig.name, containerExecRuntimeConfig);
            }
            HashMap overridesConfigs = Maps.newHashMap();
            for (ContainerExecRuntimeConfig config : overrides.executionConfigs) {
                overridesConfigs.put(config.name, config);
            }
            HashSet hashSet = Sets.newHashSet();
            hashSet.addAll(baseConfigs.keySet());
            hashSet.addAll(overridesConfigs.keySet());
            ArrayList configs = Lists.newArrayList();
            for (String name : hashSet) {
                ContainerExecRuntimeConfig baseConfig = (ContainerExecRuntimeConfig)baseConfigs.get(name);
                ContainerExecRuntimeConfig overridesConfig = (ContainerExecRuntimeConfig)overridesConfigs.get(name);
                if (baseConfig != null && overridesConfig != null) {
                    configs.add(ContainerOverrideMask.getOverriden(baseConfig, overridesConfig));
                    continue;
                }
                if (baseConfig != null) {
                    configs.add(baseConfig);
                    continue;
                }
                configs.add(overridesConfig);
            }
            ArrayList configsWithGenericOverrides = Lists.newArrayList();
            for (ContainerExecRuntimeConfig config : configs) {
                configsWithGenericOverrides.add(ContainerOverrideMask.getOverriden(config, overrides.executionConfigsGenericOverrides));
            }
            overriden.executionConfigs = configsWithGenericOverrides;
        }
        if (this.defaultWebappsK8SExposition) {
            overriden.defaultWebappsK8SExposition = overrides.defaultWebappsK8SExposition;
        }
        return overriden;
    }

    public SparkSettings apply(SparkSettings base, ContainerSettings overrides) {
        SparkSettings overriden = (SparkSettings)JSON.deepCopy((Object)base);
        if (!this.enabled) {
            return overriden;
        }
        if (this.properties) {
            for (SparkExecutionConfig conf : overriden.executionConfigs) {
                if (!conf.kubernetesSettings.managedKubernetes) continue;
                conf.kubernetesSettings.kubeCtlContext = StringUtils.defaultIfBlank((String)overrides.executionConfigsGenericOverrides.kubeCtlContext, (String)conf.kubernetesSettings.kubeCtlContext);
                conf.kubernetesSettings.kubeConfigPath = StringUtils.defaultIfBlank((String)overrides.executionConfigsGenericOverrides.kubeConfigPath, (String)conf.kubernetesSettings.kubeConfigPath);
            }
        }
        return overriden;
    }

    public static ContainerExecRuntimeConfig getOverriden(ContainerExecRuntimeConfig base, ContainerExecRuntimeConfig overrides) {
        if (null == base || null == base.type) {
            if (null == overrides || null == overrides.type) {
                return overrides;
            }
            return (ContainerExecRuntimeConfig)JSON.deepCopy((Object)overrides);
        }
        if (null == overrides) {
            return (ContainerExecRuntimeConfig)JSON.deepCopy((Object)base);
        }
        ContainerExecRuntimeConfig config = (ContainerExecRuntimeConfig)JSON.deepCopy((Object)base);
        if (!config.isFinal) {
            config.properties = ContainerOverrideMask.getOverriden(config.properties, overrides.properties);
            config.baseImage = StringUtils.defaultIfBlank((String)overrides.baseImage, (String)config.baseImage);
            config.repositoryURL = StringUtils.defaultIfBlank((String)overrides.repositoryURL, (String)config.repositoryURL);
            config.imagePullSecretName = StringUtils.defaultIfBlank((String)overrides.imagePullSecretName, (String)config.imagePullSecretName);
            config.prePushScript = StringUtils.defaultIfBlank((String)overrides.prePushScript, (String)config.prePushScript);
            config.dockerCertPath = StringUtils.defaultIfBlank((String)overrides.dockerCertPath, (String)config.dockerCertPath);
            config.dockerHost = StringUtils.defaultIfBlank((String)overrides.dockerHost, (String)config.dockerHost);
            config.dockerNetwork = StringUtils.defaultIfBlank((String)overrides.dockerNetwork, (String)config.dockerNetwork);
            config.dockerRuntime = StringUtils.defaultIfBlank((String)overrides.dockerRuntime, (String)config.dockerRuntime);
            config.dockerGpus = StringUtils.defaultIfBlank((String)overrides.dockerGpus, (String)config.dockerGpus);
            config.kubeCtlContext = StringUtils.defaultIfBlank((String)overrides.kubeCtlContext, (String)config.kubeCtlContext);
            config.kubeConfigPath = StringUtils.defaultIfBlank((String)overrides.kubeConfigPath, (String)config.kubeConfigPath);
            config.kubernetesNamespace = StringUtils.defaultIfBlank((String)overrides.kubernetesNamespace, (String)config.kubernetesNamespace);
            config.createNamespace = overrides.createNamespace || config.createNamespace;
            config.ensureNamespaceCompliance = overrides.ensureNamespaceCompliance || config.ensureNamespaceCompliance;
        }
        return config;
    }

    private static List<SimpleKeyValue> getOverriden(List<SimpleKeyValue> base, List<SimpleKeyValue> overrides) {
        HashMap overridesMap = Maps.newHashMap();
        for (SimpleKeyValue kv : overrides) {
            overridesMap.put(kv.key, kv);
        }
        HashSet keys = Sets.newHashSet();
        ArrayList ret = Lists.newArrayList();
        for (SimpleKeyValue kv : base) {
            if (overridesMap.containsKey(kv.key)) {
                ret.add((SimpleKeyValue)overridesMap.get(kv.key));
            } else {
                ret.add(kv);
            }
            keys.add(kv.key);
        }
        for (SimpleKeyValue kv : overrides) {
            if (keys.contains(kv.key)) continue;
            ret.add(kv);
        }
        return ret;
    }
}

