/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.aws.ShadedS3ConnectionAWSSessionCredentialsProviderV2;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.bedrock.BedrockPricing;
import com.dataiku.dip.llm.online.sagemakergeneric.GenericLLMHandling;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.regions.RegionUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.s3.AmazonS3Client;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BedrockConnection
extends AbstractLLMConnection<BedrockModel, HardcodedBedrockModel, CustomBedrockModel> {
    public BedrockConnectionParams params = new BedrockConnectionParams();
    public static final String connectionType = "Bedrock";
    private static final Pattern APPLICATION_INFERENCE_PATTERN = Pattern.compile("^arn:aws(|-us-gov|-cn|-iso|-iso-b):bedrock:(|[0-9a-z-]{0,20}):(|[0-9]{12}):(inference-profile|application-inference-profile)/[a-zA-Z0-9-:.]+$");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.bedrock");

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    public AwsCredentials getAWSCredentials(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
        return creds.toAWSCredentials();
    }

    public AwsCredentialsProvider getCredentialsProvider(AuthCtx authCtx) {
        return new ShadedS3ConnectionAWSSessionCredentialsProviderV2(authCtx, this);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class));
        EC2Connection ec2Conn = this.getEC2Connection(ctx.authCtx);
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = ec2Conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(ctx.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
        return clazz.cast(creds);
    }

    public EC2Connection getEC2Connection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        EC2Connection ec2Conn;
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            ec2Conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, this.params.s3Connection, EC2Connection.class);
        }
        return ec2Conn;
    }

    public AmazonS3Client getS3Client(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        EC2Connection ec2Connection = this.getEC2Connection(authCtx);
        AmazonS3Client s3client = ec2Connection.getS3ClientSdk1(authCtx);
        s3client.setRegion(RegionUtils.getRegion((String)this.params.region));
        return s3client;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public AbstractLLMConnection.AbstractLLMConnectionParams getLLMConnectionParams() {
        return this.params;
    }

    @Override
    protected boolean isHardcodedModelEnabled(HardcodedBedrockModel bedrockModel) {
        return bedrockModel.allowedModel.apply(this.params);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    public List<HardcodedBedrockModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedBedrockModel.values());
    }

    public Optional<Boolean> getConverseFlag(BedrockModel model) {
        return this.getCustomPropertyFlag("useConverseAPI", AbstractLLMConnection.QueryType.fromModel(model), model.id);
    }

    protected Optional<String> getInferenceProfile(BedrockModel model) {
        Optional<String> inferenceProfileFromProp = this.getCustomProperty("inferenceProfile", AbstractLLMConnection.QueryType.fromModel(model), model.id).map(property -> property.value);
        if (inferenceProfileFromProp.isPresent() && !Strings.isNullOrEmpty((String)inferenceProfileFromProp.get())) {
            return inferenceProfileFromProp;
        }
        if (!Strings.isNullOrEmpty((String)this.params.inferenceProfile)) {
            return Optional.of(this.params.inferenceProfile);
        }
        return Optional.empty();
    }

    @Override
    protected BedrockModel loadRawHardcodedModel(HardcodedBedrockModel hardcodedModel) {
        BedrockModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        this.getConverseFlag(model).ifPresent(value -> {
            model.supportsConverseAPI = value;
        });
        this.getInferenceProfile(model).ifPresent(value -> {
            model.inferenceProfile = value;
        });
        return model;
    }

    @Override
    protected List<CustomBedrockModel> listRawCustomModels() {
        return this.params.customModels;
    }

    private static void safeAddInferenceProfileToCustomModel(BedrockModel model, String inferenceProfile) {
        Matcher matcher = APPLICATION_INFERENCE_PATTERN.matcher(model.id);
        if (matcher.matches()) {
            logger.debug((Object)"Custom model id is an application inference profile. The cross-region inference profile prefix will not be applied to this model.");
        } else {
            model.inferenceProfile = inferenceProfile;
        }
    }

    @Override
    protected BedrockModel loadRawCustomModel(CustomBedrockModel rawCustomModel) {
        BedrockModel model = rawCustomModel.toModel();
        this.loadDefaultCustomModelSettings(rawCustomModel, model);
        this.getConverseFlag(model).ifPresent(value -> {
            model.supportsConverseAPI = value;
        });
        this.getInferenceProfile(model).ifPresent(value -> BedrockConnection.safeAddInferenceProfileToCustomModel(model, value));
        return model;
    }

    public double getEstimatedImageGenerationCost(String model, LLMClient.ImageGenerationQuery query) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        for (CustomBedrockModel customModel : this.params.customModels) {
            if (!model.equals(customModel.id)) continue;
            return 0.0;
        }
        return BedrockPricing.getBedrockImageGenerationCost(model, query);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testBedrock(this, authCtx);
    }

    public static class BedrockConnectionParams
    extends AbstractLLMConnection.AbstractLLMConnectionParams {
        public AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = new AbstractLLMConnection.HTTPBasedLLMNetworkSettings();
        public int maxParallelism = 8;
        public String s3Connection;
        public String region;
        @Nullable
        public String inferenceProfile;
        public boolean useBedrockGuardrail;
        @Nullable
        public String guardrailIdentifier;
        @Nullable
        public String guardrailVersion;
        public boolean allowAWSNovaPro = false;
        public boolean allowAWSNovaLite = false;
        public boolean allowAWSNovaMicro = false;
        public boolean allowAWSTitanTextPremierV1 = false;
        public boolean allowAWSTitanTextLiteV1 = false;
        public boolean allowAWSTitanTextExpressV1 = false;
        public boolean allowAWSTitanLarge = false;
        public boolean allowAnthropicClaude45Sonnet = false;
        public boolean allowAnthropicClaude41Opus = false;
        public boolean allowAnthropicClaude4Sonnet = false;
        public boolean allowAnthropicClaude4Opus = false;
        public boolean allowAnthropicClaude37Sonnet = false;
        public boolean allowAnthropicClaude35SonnetV2 = false;
        public boolean allowAnthropicClaude35Sonnet = false;
        public boolean allowAnthropicClaude3Sonnet = false;
        public boolean allowAnthropicClaude45Haiku = false;
        public boolean allowAnthropicClaude35Haiku = false;
        public boolean allowAnthropicClaude3Haiku = false;
        public boolean allowAnthropicClaude3Opus = false;
        public boolean allowAI21Jurassic2Ultra = false;
        public boolean allowAI21Jurassic2Mid = false;
        public boolean allowCohereCommandRPlus = false;
        public boolean allowCohereCommandR = false;
        public boolean allowMetaLlama33_70BInstruct = false;
        public boolean allowMetaLlama31_8BInstruct = false;
        public boolean allowMetaLlama31_70BInstruct = false;
        public boolean allowMetaLlama31_405BInstruct = false;
        public boolean allowMetaLlama38BInstruct = false;
        public boolean allowMetaLlama370BInstruct = false;
        public boolean allowMistral7BInstruct = false;
        public boolean allowMixtral8X7BInstruct = false;
        public boolean allowMistralSmall = false;
        public boolean allowMistralLarge = false;
        public boolean allowMistralLarge2 = false;
        public boolean allowAWSTitanEmbedTextV2 = false;
        public boolean allowAWSTitanEmbedText = false;
        public boolean allowAWSTitanMultimodalEmbedV1 = false;
        public boolean allowCohereEmbedEnglish = false;
        public boolean allowCohereEmbedMultilingual = false;
        public boolean allowAWSTitanImageGeneratorV1 = false;
        public boolean allowDeepSeekR1 = false;
        public List<CustomBedrockModel> customModels = new ArrayList<CustomBedrockModel>();
        public BedrockFineTuningSettings fineTuningSettings = new BedrockFineTuningSettings();

        public boolean isFineTuningSetup() {
            return this.fineTuningSettings.isSetup();
        }
    }

    public static enum HardcodedBedrockModel implements AbstractLLMConnection.IHardcodedConnectionModel<BedrockModel>
    {
        ANTHROPIC_CLAUDE_V45_SONNET("anthropic.claude-sonnet-4-5-20250929-v1:0", "Anthropic Claude 4.5 Sonnet through Bedrock", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude45Sonnet),
        ANTHROPIC_CLAUDE_V41_OPUS("anthropic.claude-opus-4-1-20250805-v1:0", "Anthropic Claude 4.1 Opus through Bedrock", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude41Opus),
        ANTHROPIC_CLAUDE_V4_SONNET("anthropic.claude-sonnet-4-20250514-v1:0", "Anthropic Claude 4 Sonnet through Bedrock", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude4Sonnet),
        ANTHROPIC_CLAUDE_V4_OPUS("anthropic.claude-opus-4-20250514-v1:0", "Anthropic Claude 4 Opus through Bedrock (deprecated / scheduled for retirement on May. 31st, 2026)", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude4Opus),
        ANTHROPIC_CLAUDE_V37_SONNET("anthropic.claude-3-7-sonnet-20250219-v1:0", "Anthropic Claude 3.7 Sonnet through Bedrock", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude37Sonnet),
        ANTHROPIC_CLAUDE_V35_SONNET_V2("anthropic.claude-3-5-sonnet-20241022-v2:0", "Anthropic Claude 3.5 Sonnet V2 (Oct. 24) through Bedrock (deprecated / scheduled for retirement on Mar. 1st, 2026)", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude35SonnetV2),
        ANTHROPIC_CLAUDE_V35_SONNET("anthropic.claude-3-5-sonnet-20240620-v1:0", "Anthropic Claude 3.5 Sonnet V1 (Jun. 24) through Bedrock (deprecated / scheduled for retirement on Mar. 1st, 2026)", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude35Sonnet),
        ANTHROPIC_CLAUDE_V3_SONNET("anthropic.claude-3-sonnet-20240229-v1:0", "Anthropic Claude 3 Sonnet through Bedrock (deprecated / scheduled for retirement on Jul. 21st, 2025)", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude3Sonnet),
        ANTHROPIC_CLAUDE_V45_HAIKU("anthropic.claude-haiku-4-5-20251001-v1:0", "Anthropic Claude 4.5 Haiku through Bedrock", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude45Haiku),
        ANTHROPIC_CLAUDE_V35_HAIKU("anthropic.claude-3-5-haiku-20241022-v1:0", "Anthropic Claude 3.5 Haiku through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude35Haiku),
        ANTHROPIC_CLAUDE_V3_HAIKU("anthropic.claude-3-haiku-20240307-v1:0", "Anthropic Claude 3 Haiku through Bedrock", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, true, p -> p.allowAnthropicClaude3Haiku),
        ANTHROPIC_CLAUDE_V3_OPUS("anthropic.claude-3-opus-20240229-v1:0", "Anthropic Claude 3 Opus through Bedrock (deprecated / scheduled for retirement on Jan. 15th, 2026)", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.ANTHROPIC_CLAUDE_CHAT, true, false, p -> p.allowAnthropicClaude3Opus),
        AI21_JURASSIC_ULTRA("ai21.j2-ultra-v1", "AI21 Labs Jurassic 2 Ultra through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AI21_J2, false, false, false, p -> p.allowAI21Jurassic2Ultra),
        AI21_JURASSIC_MID("ai21.j2-mid-v1", "AI21 Labs Jurassic 2 Mid through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AI21_J2, false, false, false, p -> p.allowAI21Jurassic2Mid),
        AWS_NOVA_MICRO("amazon.nova-micro-v1:0", "AWS Nova Micro", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AMAZON_NOVA, true, true, p -> p.allowAWSNovaMicro),
        AWS_NOVA_LITE("amazon.nova-lite-v1:0", "AWS Nova Lite", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.AMAZON_NOVA, true, true, p -> p.allowAWSNovaLite),
        AWS_NOVA_PRO("amazon.nova-pro-v1:0", "AWS Nova Pro", BedrockModelType.MULTIMODAL_MODEL, GenericLLMHandling.AMAZON_NOVA, true, true, p -> p.allowAWSNovaPro),
        AWS_TITAN_LARGE("amazon.titan-tg1-large", "AWS Titan Large (deprecated)", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AMAZON_TITAN, false, false, p -> p.allowAWSTitanLarge),
        AWS_TITAN_TEXT_LITE_V1("amazon.titan-text-lite-v1", "AWS Titan Text G1 Lite (deprecated / scheduled for retirement on Aug. 15th, 2025)", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AMAZON_TITAN, false, true, p -> p.allowAWSTitanTextLiteV1),
        AWS_TITAN_TEXT_EXPRESS_V1("amazon.titan-text-express-v1", "AWS Titan Text G1 Express (deprecated / scheduled for retirement on Aug. 15th, 2025)", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AMAZON_TITAN, false, true, p -> p.allowAWSTitanTextExpressV1),
        AWS_TITAN_TEXT_PREMIER_V1("amazon.titan-text-premier-v1:0", "AWS Titan Text G1 Premier (deprecated / scheduled for retirement on Aug. 15th, 2025)", BedrockModelType.TEXT_MODEL, GenericLLMHandling.AMAZON_TITAN, false, false, p -> p.allowAWSTitanTextPremierV1),
        AWS_TITAN_EMBEDDINGS_TEXT_V1("amazon.titan-embed-text-v1", "AWS Titan Embeddings G1 - Text", BedrockModelType.TEXT_EMBEDDING_EXTRACTION, GenericLLMHandling.AMAZON_TITAN_TEXT_EMBEDDING, false, false, false, p -> p.allowAWSTitanEmbedText, 8192),
        AWS_TITAN_EMBEDDINGS_MULTIMODAL_V1("amazon.titan-embed-image-v1", "AWS Titan Embeddings G1 - Multimodal", BedrockModelType.TEXT_IMAGE_EMBEDDING_EXTRACTION, GenericLLMHandling.AMAZON_TITAN_TEXT_IMAGE_EMBEDDING, false, false, false, p -> p.allowAWSTitanMultimodalEmbedV1, 256),
        AWS_TITAN_EMBEDDINGS_TEXT_V2("amazon.titan-embed-text-v2:0", "AWS Titan Text Embeddings V2", BedrockModelType.TEXT_EMBEDDING_EXTRACTION, GenericLLMHandling.AMAZON_TITAN_TEXT_EMBEDDING, false, false, false, p -> p.allowAWSTitanEmbedTextV2, 8192),
        AWS_TITAN_IMAGE_GENERATOR_V1("amazon.titan-image-generator-v1", "AWS Titan Image Generator (deprecated / scheduled for retirement on Aug. 15th, 2025)", BedrockModelType.IMAGE_GENERATION, GenericLLMHandling.AMAZON_TITAN, false, false, false, p -> p.allowAWSTitanImageGeneratorV1),
        COHERE_COMMAND_R("cohere.command-r-v1:0", "Cohere Command R through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.COHERE_COMMAND_CHAT, true, false, p -> p.allowCohereCommandR),
        COHERE_COMMAND_R_PLUS("cohere.command-r-plus-v1:0", "Cohere Command R+ through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.COHERE_COMMAND_CHAT, true, false, p -> p.allowCohereCommandRPlus),
        COHERE_EMBED_ENGLISH("cohere.embed-english-v3", "Cohere Embed English through Bedrock", BedrockModelType.TEXT_EMBEDDING_EXTRACTION, GenericLLMHandling.COHERE_EMBED, false, false, false, p -> p.allowCohereEmbedEnglish, 512),
        COHERE_EMBED_MULTILINGUAL("cohere.embed-multilingual-v3", "Cohere Embed Multilingual through Bedrock", BedrockModelType.TEXT_EMBEDDING_EXTRACTION, GenericLLMHandling.COHERE_EMBED, false, false, false, p -> p.allowCohereEmbedMultilingual, 512),
        META_LLAMA3_8B_INSTRUCT("meta.llama3-8b-instruct-v1:0", "Meta Llama 3 8B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.META_LLAMA_3_BEDROCK, true, false, p -> p.allowMetaLlama38BInstruct),
        META_LLAMA3_70B_INSTRUCT("meta.llama3-70b-instruct-v1:0", "Meta Llama 3 70B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.META_LLAMA_3_BEDROCK, true, false, p -> p.allowMetaLlama370BInstruct),
        META_LLAMA31_8B_INSTRUCT("meta.llama3-1-8b-instruct-v1:0", "Meta Llama 3.1 8B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.META_LLAMA_3_BEDROCK, true, true, p -> p.allowMetaLlama31_8BInstruct),
        META_LLAMA31_70B_INSTRUCT("meta.llama3-1-70b-instruct-v1:0", "Meta Llama 3.1 70B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.META_LLAMA_3_BEDROCK, true, true, p -> p.allowMetaLlama31_70BInstruct),
        META_LLAMA31_405B_INSTRUCT("meta.llama3-1-405b-instruct-v1:0", "Meta Llama 3.1 405B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.META_LLAMA_3_BEDROCK, true, false, p -> p.allowMetaLlama31_405BInstruct),
        META_LLAMA33_70B_INSTRUCT("meta.llama3-3-70b-instruct-v1:0", "Meta Llama 3.3 70B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.META_LLAMA_3_BEDROCK, true, false, p -> p.allowMetaLlama33_70BInstruct),
        MISTRAL_7B_INSTRUCT("mistral.mistral-7b-instruct-v0:2", "Mistral 7B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.MISTRAL_AI, false, false, p -> p.allowMistral7BInstruct),
        MIXTRAL_8X7B_INSTRUCT("mistral.mixtral-8x7b-instruct-v0:1", "Mixtral 8X7B Instruct through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.MISTRAL_AI, false, false, p -> p.allowMixtral8X7BInstruct),
        MISTRAL_LARGE("mistral.mistral-large-2402-v1:0", "Mistral Large through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.MISTRAL_AI_CHAT, true, false, p -> p.allowMistralLarge),
        MISTRAL_LARGE_2("mistral.mistral-large-2407-v1:0", "Mistral Large 2 through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.MISTRAL_AI_CHAT, true, false, p -> p.allowMistralLarge2),
        MISTRAL_SMALL("mistral.mistral-small-2402-v1:0", "Mistral Small through Bedrock", BedrockModelType.TEXT_MODEL, GenericLLMHandling.MISTRAL_AI, true, false, p -> p.allowMistralSmall),
        DEEPSEEK_R1("deepseek.r1-v1:0", "DeepSeek-R1", BedrockModelType.TEXT_MODEL, GenericLLMHandling.DEEPSEEK, true, false, p -> p.allowDeepSeekR1);

        public final String id;
        public final String displayName;
        public final BedrockModelType type;
        public final GenericLLMHandling handlingMode;
        public final Function<BedrockConnectionParams, Boolean> allowedModel;
        public final boolean supportsConverseAPI;
        public final boolean supportsSystemPrompt;
        public final boolean canBeFineTuned;
        public final Integer maxTokensLimit;

        private HardcodedBedrockModel(String id, String displayName, BedrockModelType type, GenericLLMHandling handlingMode, boolean supportsSystemPrompt, boolean canBeFineTuned, Function<BedrockConnectionParams, Boolean> allowedModel) {
            this(id, displayName, type, handlingMode, true, supportsSystemPrompt, canBeFineTuned, allowedModel, null);
        }

        private HardcodedBedrockModel(String id, String displayName, BedrockModelType type, GenericLLMHandling handlingMode, boolean supportsConverseAPI, boolean supportsSystemPrompt, boolean canBeFineTuned, Function<BedrockConnectionParams, Boolean> allowedModel) {
            this(id, displayName, type, handlingMode, supportsConverseAPI, supportsSystemPrompt, canBeFineTuned, allowedModel, null);
        }

        private HardcodedBedrockModel(String id, String displayName, BedrockModelType type, GenericLLMHandling handlingMode, boolean supportsConverseAPI, boolean supportsSystemPrompt, boolean canBeFineTuned, Function<BedrockConnectionParams, Boolean> allowedModel, Integer maxTokensLimit) {
            this.id = id;
            this.displayName = displayName;
            this.type = type;
            this.handlingMode = handlingMode;
            this.allowedModel = allowedModel;
            this.supportsConverseAPI = supportsConverseAPI;
            this.supportsSystemPrompt = supportsSystemPrompt;
            this.canBeFineTuned = canBeFineTuned;
            this.maxTokensLimit = maxTokensLimit;
        }

        @Override
        public BedrockModel toModel() {
            BedrockModel model = new BedrockModel();
            model.id = this.id;
            model.displayName = this.displayName;
            model.modelType = this.type;
            model.handlingMode = this.handlingMode;
            model.supportsConverseAPI = this.supportsConverseAPI;
            model.supportsSystemPrompt = this.supportsSystemPrompt;
            model.canBeFineTuned = this.canBeFineTuned;
            model.maxTokensLimit = this.maxTokensLimit;
            if (model.modelType.matchesPurpose(AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION) || model.modelType.matchesPurpose(AbstractLLMConnection.LLMUsagePurpose.IMAGE_EMBEDDING_EXTRACTION)) {
                if (model.modelType.matchesPurpose(AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)) {
                    model.embeddingCost = BedrockPricing.getBedrockEmbeddingCostPer1KTokens(this.id);
                }
                if (model.modelType.matchesPurpose(AbstractLLMConnection.LLMUsagePurpose.IMAGE_EMBEDDING_EXTRACTION)) {
                    model.imageEmbeddingCost = BedrockPricing.getBedrockEmbeddingCostPerImage(this.id);
                }
            } else if (!model.modelType.matchesPurpose(AbstractLLMConnection.LLMUsagePurpose.IMAGE_GENERATION)) {
                model.completionCost = BedrockPricing.getBedrockCompletionCostPer1KTokens(this.id);
                model.promptCost = BedrockPricing.getBedrockPromptCostPer1KTokens(this.id);
            }
            return model;
        }
    }

    public static class BedrockModel
    extends AbstractLLMConnection.BaseModel
    implements LLMModelHandle.FineTuneableModel<BedrockModel> {
        @Nullable
        public String baseModelId;
        public BedrockModelType modelType;
        public GenericLLMHandling handlingMode;
        @Nullable
        public String deploymentId;
        @Nullable
        public String inferenceProfile;
        public boolean supportsConverseAPI = false;
        public boolean supportsSystemPrompt = false;
        public boolean isDKUFineTuned = false;

        @Override
        public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
            AbstractLLMConnection.ModelCapabilities capabilities = new AbstractLLMConnection.ModelCapabilities();
            capabilities.handlesSystemMessage = this.supportsSystemPrompt;
            capabilities.canGenerateCrossLanguageOutput = true;
            boolean bl = capabilities.supportsImageInputs = this.modelType == BedrockModelType.MULTIMODAL_MODEL;
            if (this.handlingMode != null) {
                if (this.handlingMode.temperatureRange != null) {
                    capabilities.temperatureRange = new EnrichedLLMStructuredRef.FieldRange(this.handlingMode.temperatureRange);
                }
                if (this.handlingMode.topKRange != null) {
                    capabilities.topKRange = new EnrichedLLMStructuredRef.FieldRange(this.handlingMode.topKRange);
                }
            }
            return capabilities;
        }

        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forBedrockConnection(connection, this.getId());
        }

        @Override
        public boolean canBeUsedForPurpose(@Nonnull AbstractLLMConnection.LLMUsagePurpose purpose) {
            if (this.modelType == null) {
                return false;
            }
            if (purpose.equals((Object)AbstractLLMConnection.LLMUsagePurpose.FINE_TUNING)) {
                return this.canBeFineTuned();
            }
            return this.modelType.matchesPurpose(purpose);
        }

        @Override
        public Optional<String> getInvalidityReason() {
            if (StringUtils.isBlank((CharSequence)this.getId())) {
                return Optional.of("Empty model id");
            }
            if (this.modelType == null) {
                return Optional.of("Missing model type");
            }
            if (this.handlingMode == null) {
                return Optional.of("Missing handling mode");
            }
            return Optional.empty();
        }

        @Override
        public double getEstimatedImageGenerationCost(LLMClient.ImageGenerationQuery query) {
            if (StringUtils.isBlank((CharSequence)this.id)) {
                return 0.0;
            }
            if (this.id.equals(HardcodedBedrockModel.AWS_TITAN_IMAGE_GENERATOR_V1.id)) {
                int nbPixels = (query.height == null ? 1408 : query.height) * (query.width == null ? 1408 : query.width);
                if (nbPixels < 737280) {
                    double lowQual = 0.008;
                    double highQual = 0.01;
                    return lowQual;
                }
                double lowQual = 0.01;
                double highQual = 0.012;
                return lowQual;
            }
            logger.warn((Object)("Unknown pricing for Bedrock model: " + this.id));
            return 0.0;
        }

        private GenericLLMHandling getHandlingMode() {
            return Arrays.stream(GenericLLMHandling.values()).filter(glh -> glh.modelPrefix != null && this.getId().startsWith(glh.modelPrefix)).findFirst().orElse(GenericLLMHandling.FULLY_CUSTOM);
        }

        @Override
        public BedrockModel toFineTunedModel(LLMModelSnippetData snippetData) {
            BedrockModel fineTunedModel = new BedrockModel();
            fineTunedModel.id = snippetData.llmSMInfo.remoteModelId;
            fineTunedModel.handlingMode = this.getHandlingMode();
            if (snippetData.deployment != null) {
                fineTunedModel.deploymentId = snippetData.deployment.deploymentId;
            }
            fineTunedModel.baseModelId = this.getId();
            fineTunedModel.isDKUFineTuned = true;
            fineTunedModel.canBeFineTuned = true;
            fineTunedModel.displayName = this.displayName;
            fineTunedModel.embeddingSize = this.embeddingSize;
            fineTunedModel.maxTokensLimit = this.maxTokensLimit;
            return fineTunedModel;
        }

        @Override
        public String getBaseModelId() {
            return this.isDKUFineTuned ? this.baseModelId : null;
        }

        public String getInferenceModelId() {
            if (Strings.isNullOrEmpty((String)this.inferenceProfile)) {
                return this.id;
            }
            return this.inferenceProfile + "." + this.id;
        }
    }

    public static class CustomBedrockModel
    extends AbstractLLMConnection.CustomModel<BedrockModel> {
        public String id;
        public String displayName;
        public BedrockModelType modelType;
        public GenericLLMHandling handlingMode;
        public boolean useConverseAPI = false;
        public boolean supportsSystemPrompt = false;

        @Override
        public BedrockModel toModel() {
            BedrockModel model = new BedrockModel();
            model.loadFromCustomModel(this);
            model.id = this.id;
            model.displayName = this.displayName;
            model.modelType = this.modelType;
            model.canBeFineTuned = this.canBeFineTuned;
            model.handlingMode = this.handlingMode;
            model.supportsConverseAPI = this.useConverseAPI;
            model.supportsSystemPrompt = this.supportsSystemPrompt;
            return model;
        }
    }

    public static class BedrockFineTuningSettings {
        public String roleARN;
        public String bucketName;

        public boolean isSetup() {
            return !StringUtils.isBlank((CharSequence)this.bucketName) && !StringUtils.isBlank((CharSequence)this.roleARN);
        }
    }

    public static enum BedrockModelType {
        TEXT_MODEL(AbstractLLMConnection.PROMPT_DRIVEN_PURPOSE_SET),
        MULTIMODAL_MODEL(AbstractLLMConnection.PROMPT_DRIVEN_PURPOSE_SET_WITH_VISION),
        TEXT_EMBEDDING_EXTRACTION(EnumSet.of(AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)),
        TEXT_IMAGE_EMBEDDING_EXTRACTION(EnumSet.of(AbstractLLMConnection.LLMUsagePurpose.IMAGE_EMBEDDING_EXTRACTION, AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)),
        IMAGE_GENERATION(EnumSet.of(AbstractLLMConnection.LLMUsagePurpose.IMAGE_GENERATION));

        public final Set<AbstractLLMConnection.LLMUsagePurpose> matchingPurposes;

        private BedrockModelType(Set<AbstractLLMConnection.LLMUsagePurpose> purposes) {
            this.matchingPurposes = purposes;
        }

        public boolean matchesPurpose(AbstractLLMConnection.LLMUsagePurpose purpose) {
            return this.matchingPurposes.contains((Object)purpose);
        }
    }
}

