/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.PostgreSQLConnection;
import com.dataiku.dip.sql.DatabricksLakebaseSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import org.apache.commons.lang.StringUtils;

public class DatabricksLakebaseConnection
extends PostgreSQLConnection {
    private static final DatabricksLakebaseSQLDialect dialect = new DatabricksLakebaseSQLDialect();
    public static final String connectionType = "DatabricksLakebase";

    @Override
    public SQLDialect getDialect() {
        return dialect;
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Databricks Lakebase connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:postgresql://" + this.params.host + ":" + this.params.port + "/" + this.params.db + "?application_name=dataiku";
    }

    @Override
    public String getType() {
        return connectionType;
    }
}

