/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AutoFastPathConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RedshiftConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
AutoFastPathConnection {
    public static final String connectionType = "Redshift";
    public Params params = new Params();
    private Boolean useOldTypes = null;
    private static RedshiftSQLDialect dialectV1;
    private static RedshiftSQLDialect dialectV2;

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public RedshiftSQLDialect getDialect() {
        if (this.useOldTypes == null) {
            this.useOldTypes = this.getDkuPropertiesAsParams().getBoolParam("dku.useTimestampForDatetimeTz", true);
        }
        if (this.useOldTypes.booleanValue()) {
            if (dialectV1 == null) {
                dialectV1 = new RedshiftSQLDialect();
                dialectV1.setOldStyleDatetimeTz(true);
            }
            return dialectV1;
        }
        if (dialectV2 == null) {
            dialectV2 = new RedshiftSQLDialect();
            dialectV2.setOldStyleDatetimeTz(false);
        }
        return dialectV2;
    }

    @Override
    String getDriver() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.driver;
        }
        switch (this.params.driverMode) {
            case MANAGED_REDSHIFT: 
            case CUSTOM_REDSHIFT: {
                return "com.amazon.redshift.jdbc42.Driver";
            }
            case MANAGED_LEGACY_POSTGRESQL: 
            case CUSTOM_LEGACY_POSTGRESQL: {
                return "org.postgresql.Driver";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Redshift connection JDBC URL is not set");
            }
            return this.params.url;
        }
        switch (this.params.driverMode) {
            case MANAGED_REDSHIFT: 
            case CUSTOM_REDSHIFT: {
                switch (this.params.redshiftAuthenticationMode) {
                    case USER_PASSWORD: {
                        return "jdbc:redshift://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
                    }
                    case IAM_WITH_HOST: {
                        return "jdbc:redshift:iam://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
                    }
                    case IAM_WITH_CLUSTER_ID: {
                        return "jdbc:redshift:iam://" + this.params.clusterId + ":" + this.params.clusterRegion + "/" + this.params.db;
                    }
                }
                throw new Error("unreachable");
            }
            case MANAGED_LEGACY_POSTGRESQL: 
            case CUSTOM_LEGACY_POSTGRESQL: {
                return "jdbc:postgresql://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.jarsDirectory;
        }
        switch (this.params.driverMode) {
            case MANAGED_REDSHIFT: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "jdbc", "managed-redshift"}).getAbsolutePath();
            }
            case CUSTOM_REDSHIFT: {
                return this.params.jarsDirectory;
            }
            case MANAGED_LEGACY_POSTGRESQL: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-legacy-postgresql"}).getAbsolutePath();
            }
            case CUSTOM_LEGACY_POSTGRESQL: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.redshiftAuthenticationMode == RedshiftDriverAuthenticationMode.USER_PASSWORD;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        return super.getFullyResolvedCredentials_internal(ctx, clazz);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (this.params.redshiftAuthenticationMode != RedshiftDriverAuthenticationMode.USER_PASSWORD) {
            ret.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Auth mode " + String.valueOf((Object)this.params.redshiftAuthenticationMode) + " isn't compatible with direct access from Spark");
        }
        return ret;
    }

    @Override
    public boolean useAutoFastConnection() {
        return this.params.useAutoFastPath;
    }

    @Override
    public String getAutoFastPathConnection() {
        return this.params.autoFastPathConnection;
    }

    @Override
    public String getAutoFastPathConnectionPath() {
        return this.params.autoFastPathConnectionPath;
    }

    @Override
    public boolean isSupportedCloudStorage(AbstractCloudStorageConnection connection) {
        return connection instanceof EC2Connection;
    }

    @Override
    void fillConnectionData(SQLConnectionProvider.SQLConnectionData cd) {
        super.fillConnectionData(cd);
        if (!cd.hasProperty("enableFetchRingBuffer")) {
            cd.withProperty("enableFetchRingBuffer", "false");
            cd.withProperty("defaultRowFetchSize", String.valueOf(SQLUtils.retrieveFetchSize(cd)));
        }
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public RedshiftDriverAuthenticationMode redshiftAuthenticationMode = RedshiftDriverAuthenticationMode.USER_PASSWORD;
        public int port = 5439;
        public String clusterId;
        public String clusterRegion;
        public String iamRole;
        public RedshiftDriverMode driverMode = RedshiftDriverMode.MANAGED_LEGACY_POSTGRESQL;
        public String driver;
        public boolean useAutoFastPath;
        public String autoFastPathConnection;
        public String autoFastPathConnectionPath;

        @Override
        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            super.expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
            this.iamRole = vc.expand(this.iamRole);
        }
    }

    public static enum RedshiftDriverMode {
        MANAGED_REDSHIFT,
        MANAGED_LEGACY_POSTGRESQL,
        CUSTOM_REDSHIFT,
        CUSTOM_LEGACY_POSTGRESQL;

    }

    public static enum RedshiftDriverAuthenticationMode {
        USER_PASSWORD,
        IAM_WITH_HOST,
        IAM_WITH_CLUSTER_ID;

    }
}

