/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.AbstractDatabaseMetaData;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryDataType;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryInformationSchema;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryJdbcConnection;
import com.dataiku.dip.connections.bigquery.builtin.QueryParameter;
import com.dataiku.dip.connections.bigquery.builtin.SimpleResult;
import com.dataiku.dip.connections.bigquery.builtin.SimpleResultSet;
import com.dataiku.dip.sql.bigquery.QueryResult;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.ProjectList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryException;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.DatasetId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldValue;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldValueList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.StandardSQLTypeName;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BigQueryDatabaseMetadata
extends AbstractDatabaseMetaData {
    private static final String TABLE_CATALOG = "TABLE_CATALOG";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String REMARKS = "REMARKS";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String NULLABLE = "NULLABLE";
    private static final long METADATA_PAGE_SIZE = 10000L;
    private final BigQueryJdbcConnection connection;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.jdbc");

    public BigQueryDatabaseMetadata(BigQueryJdbcConnection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getDriverName() {
        return "BigQuery built-in client";
    }

    @Override
    public String getDriverVersion() {
        return "1.0.0";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDatabaseProductName() {
        return "Google BigQuery";
    }

    @Override
    public String getDatabaseProductVersion() {
        return "2.0";
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 2;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public ResultSet getTables(String catalogPattern, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        List<BigQueryInformationSchema.TableInfo> tables = new BigQueryInformationSchema(this.connection).listTablesInfo(catalogPattern, schemaPattern, tableNamePattern);
        SimpleResult.Schema schema = new SimpleResult.Schema().withColumn(TABLE_CAT).withColumn(TABLE_SCHEM).withColumn(TABLE_NAME).withColumn(TABLE_TYPE).withColumn(REMARKS).withColumn("TYPE_CAT").withColumn("TYPE_SCHEM").withColumn(TYPE_NAME).withColumn("SELF_REFERENCING_COL_NAME").withColumn("REF_GENERATION");
        SimpleResult outputData = new SimpleResult(schema);
        for (BigQueryInformationSchema.TableInfo table : tables) {
            outputData.newRow().withValue(TABLE_CAT, table.tableId.getProject()).withValue(TABLE_SCHEM, table.tableId.getDataset()).withValue(TABLE_NAME, table.tableId.getTable()).withValue(TABLE_TYPE, table.tableType).withValue(REMARKS, table.description);
        }
        return new SimpleResultSet(outputData);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        SimpleResult.Schema schema = new SimpleResult.Schema().withColumn(TABLE_CATALOG).withColumn(TABLE_SCHEM);
        SimpleResult outputData = new SimpleResult(schema);
        List<DatasetId> datasetIds = new BigQueryInformationSchema(this.connection).listDatasetsIds(null, null);
        for (DatasetId datasetId : datasetIds) {
            outputData.newRow().withValue(TABLE_CATALOG, datasetId.getProject()).withValue(TABLE_SCHEM, datasetId.getDataset());
        }
        return new SimpleResultSet(outputData);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        SimpleResult.Schema schema = new SimpleResult.Schema().withColumn(TABLE_CAT);
        SimpleResult outputData = new SimpleResult(schema);
        logger.debug((Object)"Listing all BigQuery projects");
        for (ProjectList.Projects project : new BigQueryInformationSchema(this.connection).listProjects()) {
            outputData.newRow().withValue(TABLE_CAT, project.getId());
        }
        return new SimpleResultSet(outputData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String columnNamePattern) throws SQLException {
        SimpleResult outputData;
        SimpleResult.Schema schema = new SimpleResult.Schema().withColumn(TABLE_CAT).withColumn(TABLE_SCHEM).withColumn(TABLE_NAME).withColumn(COLUMN_NAME).withColumn(DATA_TYPE, 4).withColumn(TYPE_NAME).withColumn(COLUMN_SIZE, 4).withColumn("BUFFER_LENGTH").withColumn(DECIMAL_DIGITS, 4).withColumn("NUM_PREC_RADIX", 4).withColumn(NULLABLE, 4).withColumn(REMARKS).withColumn("COLUMN_DEF").withColumn("SQL_DATA_TYPE", 4).withColumn("SQL_DATETIME_SUB", 4).withColumn("CHAR_OCTET_LENGTH", 4).withColumn(ORDINAL_POSITION, 4).withColumn(IS_NULLABLE).withColumn("SCOPE_CATALOG").withColumn("SCOPE_SCHEMA").withColumn("SCOPE_TABLE").withColumn("SOURCE_DATA_TYPE", 5).withColumn("IS_AUTOINCREMENT").withColumn("IS_GENERATEDCOLUMN");
        List<DatasetId> datasetIds = new BigQueryInformationSchema(this.connection).listDatasetsIds(catalog, schemaPattern);
        String query = "SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, ORDINAL_POSITION, IS_NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE ? AND COLUMN_NAME LIKE ?";
        List<QueryParameter> parameters = Arrays.asList(new QueryParameter(StringUtils.isBlank((String)tableNamePattern) ? "%" : tableNamePattern, StandardSQLTypeName.STRING), new QueryParameter(StringUtils.isBlank((String)columnNamePattern) ? "%" : columnNamePattern, StandardSQLTypeName.STRING));
        if (datasetIds.isEmpty()) {
            outputData = new SimpleResult(schema);
        } else if (datasetIds.size() == 1) {
            outputData = this.getColumns(datasetIds.get(0), query, parameters, schema);
        } else {
            ExecutorService executorService = BigQueryInformationSchema.newExecutorService("BigQueryGetColumns-%d");
            List threadSafeSimpleResults = Collections.synchronizedList(new ArrayList());
            logger.debug((Object)("Listing all columns matching the table name pattern " + tableNamePattern + " and the column name pattern " + columnNamePattern));
            for (DatasetId datasetId : datasetIds) {
                executorService.submit(() -> {
                    try {
                        threadSafeSimpleResults.add(this.getColumns(datasetId, query, parameters, schema));
                    }
                    catch (BigQueryException | SQLException e) {
                        logger.warn((Object)("Unable to list columns of dataset " + BigQueryInformationSchema.toPrettyString(datasetId)), e);
                    }
                });
            }
            BigQueryInformationSchema.shutdownExecutor(executorService);
            outputData = new SimpleResult(schema);
            List list = threadSafeSimpleResults;
            synchronized (list) {
                outputData.rows.addAll(threadSafeSimpleResults.stream().flatMap(results -> results.rows.stream()).collect(Collectors.toList()));
            }
        }
        return new SimpleResultSet(outputData);
    }

    private SimpleResult getColumns(DatasetId datasetId, String query, List<QueryParameter> parameters, SimpleResult.Schema schema) throws SQLFeatureNotSupportedException {
        QueryResult queryResult = this.connection.getBigQueryClient().executeQuery(datasetId, query, parameters, false, 10000L);
        SimpleResult outputData = new SimpleResult(schema);
        for (FieldValueList row : queryResult.tableResult.iterateAll()) {
            String dataType = BigQueryDatabaseMetadata.getColumnValue(row, DATA_TYPE);
            assert (dataType != null);
            BigQueryDataType bqDataType = BigQueryDataType.fromType(dataType);
            String isNullable = BigQueryDatabaseMetadata.getColumnValue(row, IS_NULLABLE);
            outputData.newRow().withValue(TABLE_CAT, BigQueryDatabaseMetadata.getColumnValue(row, TABLE_CATALOG)).withValue(TABLE_SCHEM, BigQueryDatabaseMetadata.getColumnValue(row, "TABLE_SCHEMA")).withValue(TABLE_NAME, BigQueryDatabaseMetadata.getColumnValue(row, TABLE_NAME)).withValue(COLUMN_NAME, BigQueryDatabaseMetadata.getColumnValue(row, COLUMN_NAME)).withValue(DATA_TYPE, bqDataType.sqlType).withValue(TYPE_NAME, dataType).withValue(COLUMN_SIZE, bqDataType.precision).withValue(DECIMAL_DIGITS, bqDataType.decimalDigits).withValue(REMARKS, null).withValue(ORDINAL_POSITION, BigQueryDatabaseMetadata.getColumnValue(row, ORDINAL_POSITION)).withValue(NULLABLE, BigQueryDatabaseMetadata.computeNullable(isNullable)).withValue(IS_NULLABLE, isNullable);
        }
        return outputData;
    }

    private static String getColumnValue(FieldValueList row, String columnName) {
        FieldValue fieldValue = row.get(columnName);
        return fieldValue.isNull() ? null : fieldValue.getStringValue();
    }

    private static int computeNullable(String isNullable) {
        if ("YES".equalsIgnoreCase(isNullable)) {
            return 1;
        }
        if ("NO".equalsIgnoreCase(isNullable)) {
            return 0;
        }
        return 2;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        SimpleResult.Schema schema = new SimpleResult.Schema().withColumn(TABLE_SCHEM);
        SimpleResult outputData = new SimpleResult(schema);
        List<DatasetId> datasetIds = new BigQueryInformationSchema(this.connection).listDatasetsIds(catalog, schemaPattern);
        for (DatasetId datasetId : datasetIds) {
            outputData.newRow().withValue(TABLE_SCHEM, datasetId.getDataset());
        }
        return new SimpleResultSet(outputData);
    }
}

