/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedRecipesDAO
extends AbstractStandardDAO<SerializedRecipe>
implements RecipesDAO {
    @Autowired
    private FlowGraphService graphService;

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.RECIPE.toHumanReadableString();
    }

    @Override
    protected List<SerializedRecipe> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<SerializedRecipe> ret = new ArrayList<SerializedRecipe>();
        RelFile recipesFolder = this.getRecipesFolder(projectKey);
        if (!t.exists(recipesFolder)) {
            return ret;
        }
        for (RelFile f : t.listFiles(recipesFolder, (RelFileFilter)ExtensionFilter.json())) {
            try {
                String name = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                SerializedRecipe sr = this.getOrNull_noTag(projectKey, name, unsafe);
                if (sr == null) continue;
                ret.add(sr);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read recipe file: " + String.valueOf(f) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public List<String> listUsedNames(String projectKey) throws IOException {
        RelFile recipesFolder;
        ArrayList<String> names = new ArrayList<String>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(recipesFolder = this.getRecipesFolder(projectKey))) {
            return names;
        }
        for (RelFile rf : t.listFiles(recipesFolder, (RelFileFilter)FileFilter.json())) {
            String fileName = rf.getLeafName();
            if (!StringUtils.endsWith((String)fileName, (String)".json")) {
                this.logger.error((Object)("Expected a file with .json extension, got '" + fileName + "'. Skipping."));
            }
            names.add(fileName.substring(0, fileName.length() - 5));
        }
        return names;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile recipesFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(recipesFolder = this.getRecipesFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(recipesFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    protected SerializedRecipe getOrNull_noTag(String projectKey, String recipeName, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile recipeFile = this.getDAOFile(projectKey, recipeName);
        this.logger.trace((Object)("Reading recipe file " + String.valueOf(recipeFile)));
        if (!t.isFile(recipeFile)) {
            return null;
        }
        SerializedRecipe sr = unsafe ? (SerializedRecipe)t.readObjectUnsafe(recipeFile, SerializedRecipe.class) : (SerializedRecipe)t.readObject(recipeFile, SerializedRecipe.class);
        sr.projectKey = projectKey;
        sr.name = recipeName;
        return sr;
    }

    @Override
    public void save(String projectKey, String recipeName, SerializedRecipe recipe, String payload) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        RelFile recipeFile = this.getDAOFile(projectKey, recipeName);
        if (t.isFile(recipeFile) && recipe == null) {
            recipe = (SerializedRecipe)this.getMandatoryUnsafe(projectKey, recipeName);
        } else if (recipe == null) {
            throw ErrorContext.iae((String)"Recipe data not given, and no previous version exists");
        }
        super.save(recipe);
        if (payload != null) {
            RelFile payloadFile = this.getPayloadFile(projectKey, recipeName, recipe.type);
            t.writeStringUTF8(payloadFile, payload);
        }
    }

    @Override
    public void changeType(String projectKey, String recipeName, String newType) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        RelFile recipeFile = this.getDAOFile(projectKey, recipeName);
        SerializedRecipe recipe = (SerializedRecipe)this.getMandatoryUnsafe(projectKey, recipeName);
        RelFile payloadFile = this.getPayloadFile(projectKey, recipeName, recipe.type);
        recipe.type = newType;
        t.writeObject(recipeFile, (Object)recipe);
        if (t.exists(payloadFile)) {
            RelFile newPayloadFile = this.getPayloadFile(projectKey, recipeName, newType);
            t.moveFile(payloadFile, newPayloadFile);
        }
    }

    @Override
    public void rename(String projectKey, String oldName, String newName) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        SerializedRecipe recipe = (SerializedRecipe)this.getMandatoryUnsafe(projectKey, oldName);
        RelFile oldFile = this.getDAOFile(projectKey, oldName);
        RelFile newFile = this.getDAOFile(projectKey, newName);
        if (t.exists(newFile)) {
            throw new IOException("Target recipe already exists: " + projectKey + "." + newName);
        }
        t.moveFile(oldFile, newFile);
        RelFile payloadFile = this.getPayloadFile(projectKey, oldName, recipe.type);
        if (t.exists(payloadFile)) {
            RelFile newPayloadFile = this.getPayloadFile(projectKey, newName, recipe.type);
            t.moveFile(payloadFile, newPayloadFile);
        }
    }

    @Override
    public void delete(String projectKey, String recipeName) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        SerializedRecipe recipe = (SerializedRecipe)this.getMandatoryUnsafe(projectKey, recipeName);
        RelFile recipeFile = this.getDAOFile(projectKey, recipeName);
        t.deleteFile(recipeFile);
        RelFile payloadFile = this.getPayloadFile(projectKey, recipeName, recipe.type);
        if (t.exists(payloadFile)) {
            t.deleteFile(payloadFile);
        }
    }

    @Override
    public String getPayloadOrNull(String projectKey, String name) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        SerializedRecipe recipe = (SerializedRecipe)this.getOrNull(projectKey, name);
        if (recipe == null) {
            return null;
        }
        RelFile payloadFile = this.getPayloadFile(projectKey, name, recipe.type);
        if (!t.isFile(payloadFile)) {
            return null;
        }
        this.logger.trace((Object)("Reading payload file " + String.valueOf(payloadFile)));
        return t.readStringUTF8(payloadFile);
    }

    private RelFile getRecipesFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "recipes"});
    }

    private RelFile getPayloadFile(String projectKey, String name, String recipeType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Recipe name is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipeType), (Object)"Recipe type is not specified");
        String extension = recipeType;
        switch (recipeType) {
            case "sql_query": 
            case "sql_script": 
            case "spark_sql_query": {
                extension = "sql";
                break;
            }
            case "python": 
            case "pyspark": 
            case "streaming_pyspark": 
            case "cpython": {
                extension = "py";
                break;
            }
            case "sparkr": 
            case "streaming_sparkr": {
                extension = "r";
                break;
            }
            case "spark_scala": 
            case "streaming_spark_scala": {
                extension = "scala";
            }
        }
        return new RelFile(new String[]{"projects", projectKey, "recipes", name + "." + extension});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Recipe name is not specified");
        return new RelFile(this.getRecipesFolder(projectKey), new String[]{name + ".json"});
    }
}

