/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.commands.PartitionRefreshCommand;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ComputeImpactedOutputPartitions {
    private PartitionRefreshCommand command;
    private RunnableSubgraph subgraph;
    private DatasetsDAO dao;
    private static Logger logger = Logger.getLogger((String)"dku.flow.compute.op");

    public ComputeImpactedOutputPartitions(DatasetsDAO dao, PartitionRefreshCommand command, RunnableSubgraph subgraph) {
        this.dao = dao;
        this.command = command;
        this.subgraph = subgraph;
    }

    public void compute() throws IOException {
        logger.info((Object)("Compute output partitions for subgraph, with target : " + this.command.target.getFullId() + " and partition: " + this.command.partition.id()));
        if (this.subgraph.isAllTargetPartitions()) {
            for (FlowComputable flowComputable : this.subgraph.getTargets()) {
                if (flowComputable.isPartitionable()) {
                    PartitioningScheme partitioningScheme = ((FlowPartitionable)((Object)this.command.target)).getPartitioned(this.dao).getPartitioningSchema();
                    this.subgraph.getTargetPartitions().put(flowComputable.getFullId(), Partition.newALL((PartitioningScheme)partitioningScheme));
                    continue;
                }
                this.subgraph.getTargetPartitions().put(flowComputable.getFullId(), Partition.newNP());
            }
            return;
        }
        if (this.command.target.getType() == FlowComputable.FCType.SAVED_MODEL && this.subgraph.listRecipes().size() == 1 && this.subgraph.listRecipes().get(0).getSuccessors().size() == 1) {
            this.subgraph.getTargetPartitions().put(this.command.target.getFullId(), this.command.partition.copy());
            return;
        }
        PartitioningScheme mainScheme = new PartitioningScheme();
        if (this.command.target.isPartitionable()) {
            mainScheme = ((FlowPartitionable)((Object)this.command.target)).getPartitioned(this.dao).getPartitioningSchema();
        }
        assert (mainScheme != null);
        for (FlowComputable flowComputable : this.subgraph.getTargets()) {
            PartitioningScheme addScheme = new PartitioningScheme();
            if (flowComputable.isPartitionable()) {
                addScheme = ((FlowPartitionable)((Object)flowComputable)).getPartitioned(this.dao).getPartitioningSchema();
            }
            assert (addScheme != null);
            Partition ret = null;
            if (!addScheme.isPartitioned()) {
                logger.info((Object)("Target " + flowComputable.getFullId() + " is not partitioned"));
                ret = new Partition(null);
            } else if (addScheme.isEqual(mainScheme)) {
                logger.info((Object)("Target " + flowComputable.getFullId() + " has same partitioning as " + this.command.target.getFullId()));
                ret = this.command.partition.copy();
            } else {
                throw new IllegalArgumentException("non-matching partitioning scheme for " + flowComputable.getFullId());
            }
            assert (ret != null);
            logger.info((Object)("Add output partition for " + flowComputable.getFullId() + " : " + ret.id()));
            this.subgraph.getTargetPartitions().put(flowComputable.getFullId(), ret);
        }
    }
}

