/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.grouping.Grouper2;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.window.Windower;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractStagedThreadedBuiltinRunner
extends AbstractInitializedRunner {
    protected final List<ComputationStage> stages = Lists.newArrayList();
    protected Sorter.MergeSortParams mergeSortParams;
    protected boolean autoPiping;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.abstractthreaded.builtin");

    public AbstractStagedThreadedBuiltinRunner(JobActivity activity) {
        this(activity, true);
    }

    public AbstractStagedThreadedBuiltinRunner(JobActivity activity, boolean autoPiping) {
        super(activity);
        SpringUtils.getInstance().autowire((Object)this);
        this.mergeSortParams = new Sorter.MergeSortParams();
        this.autoPiping = autoPiping;
    }

    @Override
    public void notifyBeforeAborting() {
    }

    protected abstract List<AbstractInitializedRunner.Output> prepareStages(File var1) throws Exception;

    @Override
    public void run() throws Exception {
        try (AutoDelete tempDirectory = FlowJobUtils.getTmpFolder("staged-runner", "tmp");){
            List<AbstractInitializedRunner.Output> usedOutputs = this.prepareStages((File)tempDirectory);
            if (this.stages.isEmpty()) {
                throw new RuntimeException("Recipe has no stage");
            }
            if (this.autoPiping) {
                if (!this.inputs.containsKey("main") || ((List)this.inputs.get("main")).isEmpty() || !this.outputs.containsKey("main") || ((List)this.outputs.get("main")).isEmpty()) {
                    throw new RuntimeException("Cannot auto-pipe the stages together, because there is no main input or no main output. Consider turning autoPiping to false.");
                }
                AbstractInitializedRunner.Input mainInput = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
                AbstractInitializedRunner.Output mainOutput = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
                StreamColumnFactory lastCf = mainInput.cf;
                StreamRowFactory lastRf = null;
                RowInputStream lastInput = mainInput.is;
                for (int i = 0; i < this.stages.size(); ++i) {
                    ComputationStage stage = this.stages.get(i);
                    stage.setInputFactories((ColumnFactory)lastCf, (RowFactory)lastRf, lastInput);
                    if (i == this.stages.size() - 1) {
                        stage.setOutputFactories((ColumnFactory)mainOutput.cf, (RowFactory)mainOutput.rf, (ProcessorOutput)new ProcessorOutputToSIP(mainOutput.out));
                        stage.setEmitLastRow(false);
                        continue;
                    }
                    StreamColumnFactory nextCf = new StreamColumnFactory();
                    StreamRowFactory nextRf = new StreamRowFactory();
                    UniversalSingleThreadPuller.Stream stream = new UniversalSingleThreadPuller.Stream();
                    stage.setOutputFactories((ColumnFactory)nextCf, (RowFactory)nextRf, stream);
                    lastCf = nextCf;
                    lastRf = nextRf;
                    lastInput = stream;
                    stage.setEmitLastRow(true);
                }
            }
            this.startStages();
            this.waitStages();
            for (ComputationStage stage : this.stages) {
                if (stage.getException() == null) continue;
                throw new Exception("One stage failed", stage.getException());
            }
            for (AbstractInitializedRunner.Output output : usedOutputs) {
                output.out.postProcess();
            }
        }
    }

    private synchronized void startStages() {
        for (ComputationStage stage : this.stages) {
            stage.start();
        }
    }

    private void waitStages() throws InterruptedException {
        for (ComputationStage stage : this.stages) {
            try {
                stage.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Object)"Failed to join with thread", (Throwable)e);
                throw e;
            }
        }
    }

    protected synchronized void interruptStages() {
        logger.warn((Object)"Interrupting staged recipe runner");
        for (ComputationStage stage : this.stages) {
            stage.interrupt();
        }
    }

    protected abstract class ComputationStage
    extends Thread {
        protected boolean emitLastRow;

        protected ComputationStage() {
        }

        @Override
        public abstract void run();

        public abstract void setInputFactories(ColumnFactory var1, RowFactory var2, RowInputStream var3);

        public abstract void setOutputFactories(ColumnFactory var1, RowFactory var2, ProcessorOutput var3);

        protected abstract Throwable getException();

        public void setEmitLastRow(boolean emitLastRow) {
            this.emitLastRow = emitLastRow;
        }
    }

    protected class WindowerThread
    extends ComputationStage {
        private final Windower windower;
        private final Schema inputSchema;
        private ProcessorOutput output;
        private RowInputStream input;
        private RowFactory outputRf;
        private ColumnFactory outputCf;
        private ColumnFactory inputCf;
        private Throwable exception;

        public WindowerThread(Windower windower, Schema inputSchema) {
            this.windower = windower;
            this.inputSchema = inputSchema;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.inputCf = cf;
            this.input = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCf = cf;
            this.outputRf = rf;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                this.windower.compute(this.input, this.output, this.inputCf, this.outputCf, this.inputSchema, this.outputRf);
                if (this.emitLastRow) {
                    this.output.lastRowEmitted();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted window aggregator");
                try {
                    this.windower.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Window aggregation failed", (Throwable)e);
                AbstractStagedThreadedBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GrouperThread
    extends ComputationStage {
        private final Grouper2 grouper;
        private final Schema inputSchema;
        private ProcessorOutput output;
        private RowInputStream input;
        private RowFactory outputRf;
        private ColumnFactory outputCf;
        private ColumnFactory inputCf;
        private Throwable exception;

        public GrouperThread(Grouper2 grouper, Schema inputSchema) {
            this.grouper = grouper;
            this.inputSchema = inputSchema;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.inputCf = cf;
            this.input = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCf = cf;
            this.outputRf = rf;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                this.grouper.compute(this.input, this.output, this.inputCf, this.outputCf, this.inputSchema, this.outputRf);
                if (this.emitLastRow) {
                    this.output.lastRowEmitted();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted grouper aggregator");
                try {
                    this.grouper.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Grouper aggregation failed", (Throwable)e);
                AbstractStagedThreadedBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
            finally {
                try {
                    this.grouper.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Grouper aggregation cleanup failed", (Throwable)e);
                }
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }

    public class KeepDistinctRowsThread
    extends ComputationStage {
        private final Schema schema;
        private final File folder;
        private Throwable exception;
        private RowInputStream input;
        private ProcessorOutput output;
        private RowFactory outputRf;
        private ColumnFactory outputCf;
        private ColumnFactory inputCf;

        public KeepDistinctRowsThread(Schema schema, File folder) {
            this.schema = schema;
            this.folder = folder;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.input = input;
            this.inputCf = cf;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.output = output;
            this.outputRf = rf;
            this.outputCf = cf;
            if (this.inputCf != null && this.outputCf != null) {
                for (Column c2 : this.inputCf.columns()) {
                    this.outputCf.column(c2.getName());
                }
            }
        }

        @Override
        public void run() {
            KeepDistinctRowsProcessorOutput processor = null;
            try {
                processor = new KeepDistinctRowsProcessorOutput(this.output, this.schema, this.outputRf, this.inputCf, this.outputCf, this.folder, AbstractStagedThreadedBuiltinRunner.this.mergeSortParams);
                processor.emitLastRow = this.emitLastRow;
                Row row = this.input.next();
                while (row != null) {
                    processor.emitRow(row);
                    row = this.input.next();
                }
                processor.lastRowEmitted();
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted keeping distinct rows");
                try {
                    processor.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Keep distinct rows failed", (Throwable)e);
                AbstractStagedThreadedBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }

        @Override
        protected Throwable getException() {
            return this.exception;
        }
    }

    public static class KeepDistinctRowsProcessorOutput
    extends SinkProcessorOutput {
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.processor.keepdistinct");
        private final ProcessorOutput output;
        public final Sorter sorter;
        private final SpilledRowsStorage storage;
        private final List<Sorter.SortSpec> outputSpecs;
        private final File folder;
        private long inputRowCount = 0L;
        private long outputRowCount = 0L;
        public boolean emitLastRow = true;

        public KeepDistinctRowsProcessorOutput(ProcessorOutput output, Schema schema, RowFactory outputRf, ColumnFactory inputCf, ColumnFactory outputCf, File folder, Sorter.MergeSortParams mergeSortParams) throws IOException {
            this.output = output;
            List<Sorter.SortSpec> inputSpecs = this.buildSpecs(schema, inputCf);
            this.outputSpecs = this.buildSpecs(schema, outputCf);
            this.folder = folder;
            this.storage = new SpilledRowsStorage(this.folder, SpilledRowsStorage.factoryColumnsOfSchema(inputCf, schema), mergeSortParams);
            this.sorter = new Sorter(inputSpecs, schema, inputCf, this.storage, outputRf, outputCf, mergeSortParams);
        }

        public void emitRow(Row row) throws Exception {
            try {
                this.sorter.emitRow(row);
                ++this.inputRowCount;
                if (this.inputRowCount % 1000L == 0L) {
                    logger.info((Object)("Done " + this.inputRowCount));
                }
            }
            catch (Exception e) {
                this.cancel();
                this.closeStorage();
                throw e;
            }
        }

        public void lastRowEmitted() throws Exception {
            try {
                logger.info((Object)("Read " + this.inputRowCount + " rows"));
                this.sorter.lastRowEmitted();
                this.storage.doneWriting();
                logger.info((Object)"Done sorting, start removing duplicates");
                RowsComparator outputComparator = new RowsComparator(this.outputSpecs, RowsComparator.NullsOrdering.AUTO);
                SortedRowsIterator rowsIterator = this.sorter.read();
                NumberedRow lastPeer = null;
                while (rowsIterator.hasNext()) {
                    NumberedRow row = rowsIterator.next().row;
                    if (lastPeer != null && outputComparator.compare(lastPeer, row) == 0) continue;
                    lastPeer = row;
                    this.output.emitRow(row.row);
                    ++this.outputRowCount;
                }
                if (this.emitLastRow) {
                    this.output.lastRowEmitted();
                }
                logger.info((Object)("Kept " + this.outputRowCount + " distinct rows out of " + this.inputRowCount));
            }
            catch (Exception e) {
                this.cancel();
                throw e;
            }
            finally {
                this.closeStorage();
            }
        }

        private void closeStorage() {
            try {
                logger.infoV("Deleting temporary storage: %s", new Object[]{this.folder.getAbsolutePath()});
                this.storage.close();
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Failed to close temporary storage: %s", new Object[]{this.folder.getAbsolutePath()});
            }
        }

        public void cancel() throws Exception {
            this.sorter.cancel();
            this.output.cancel();
        }

        public void setMaxMemoryUsed(long size) {
            this.sorter.setMaxMemoryUsed(size);
        }

        private List<Sorter.SortSpec> buildSpecs(Schema schema, ColumnFactory cf) {
            ArrayList specs = Lists.newArrayList();
            for (SchemaColumn schemaColumn : schema.getColumns()) {
                Sorter.SortSpec spec = new Sorter.SortSpec(schemaColumn.getName(), true);
                spec.schemaColumn = schemaColumn;
                spec.factoryColumn = cf.column(schemaColumn.getName());
                specs.add(spec);
            }
            return specs;
        }
    }

    public static class FilteringRowsProcessorOutput
    extends SinkProcessorOutput {
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.processor.filtering");
        private final ProcessorOutput output;
        private long inputRowCount = 0L;
        private long outputRowCount = 0L;
        public boolean emitLastRow = true;
        private final GrelExpression grelFilter;
        private Expression filter;

        public FilteringRowsProcessorOutput(ProcessorOutput output, ColumnFactory inputCf, GrelExpression grelFilter) {
            this.output = output;
            this.grelFilter = grelFilter;
            this.filter = GrelExpression.build(this.grelFilter);
            this.filter.setColumnFactory(inputCf);
        }

        public void emitRow(Row row) throws Exception {
            try {
                ++this.inputRowCount;
                if (this.inputRowCount % 1000L == 0L) {
                    logger.info((Object)("Done " + this.inputRowCount));
                }
                if (this.filter.isTrueish(row)) {
                    this.output.emitRow(row);
                    ++this.outputRowCount;
                }
            }
            catch (Exception e) {
                this.cancel();
                throw e;
            }
        }

        public void lastRowEmitted() throws Exception {
            try {
                logger.info((Object)("Read " + this.inputRowCount + " rows"));
                if (this.emitLastRow) {
                    this.output.lastRowEmitted();
                }
                logger.info((Object)"Done filtering.");
                logger.info((Object)("Kept " + this.outputRowCount + " filtered rows out of " + this.inputRowCount));
            }
            catch (Exception e) {
                this.cancel();
                throw e;
            }
        }

        public void cancel() throws Exception {
            this.output.cancel();
        }
    }

    protected class FilteringThread
    extends ComputationStage {
        private final GrelExpression grelFilter;
        private Expression filter;
        private Throwable exception;
        private RowInputStream input;
        private ProcessorOutput output;
        private ColumnFactory inputCf;

        public FilteringThread(GrelExpression grelFilter) {
            this.grelFilter = grelFilter;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.input = input;
            this.inputCf = cf;
            this.filter = GrelExpression.build(this.grelFilter);
            this.filter.setColumnFactory(cf);
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.output = output;
            if (this.inputCf != null && cf != null) {
                for (Column c2 : this.inputCf.columns()) {
                    cf.column(c2.getName());
                }
            }
        }

        @Override
        protected Throwable getException() {
            return this.exception;
        }

        @Override
        public void run() {
            FilteringRowsProcessorOutput processor = null;
            try {
                processor = new FilteringRowsProcessorOutput(this.output, this.inputCf, this.grelFilter);
                processor.emitLastRow = this.emitLastRow;
                Row row = this.input.next();
                while (row != null) {
                    processor.emitRow(row);
                    row = this.input.next();
                }
                processor.lastRowEmitted();
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted filtering rows");
                try {
                    processor.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Filtering rows failed", (Throwable)e);
                AbstractStagedThreadedBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }
    }

    protected class ComputedColumnsThread
    extends ComputationStage {
        private final List<ComputedColumn> computedColumns;
        private final Map<String, Expression> compiledExpressions = Maps.newHashMap();
        private Throwable exception;
        private RowInputStream input;
        private ColumnFactory inputCf;
        private long rowCount = 0L;
        private ProcessorOutput output;
        private ColumnFactory outputCf;
        private RowFactory outputRf;

        public ComputedColumnsThread(List<ComputedColumn> computedColumns) {
            this.computedColumns = computedColumns;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.input = input;
            this.inputCf = cf;
            for (ComputedColumn cc : this.computedColumns) {
                if (cc.mode != ComputedColumn.Mode.GREL) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Cannot use DSS engine with formula of type " + String.valueOf((Object)cc.mode));
                }
                Expression exp = new Expression(cc.expr);
                exp.setVariablesContext(cc.exprVariablesContext);
                exp.setColumnFactory(this.inputCf);
                this.compiledExpressions.put(cc.expr, exp);
            }
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.output = output;
            this.outputCf = cf;
            this.outputRf = rf;
            if (this.inputCf != null && this.outputCf != null) {
                for (Column c2 : this.inputCf.columns()) {
                    this.outputCf.column(c2.getName());
                }
            }
        }

        @Override
        protected Throwable getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                Row row = this.input.next();
                while (row != null) {
                    ++this.rowCount;
                    Row outRow = this.outputRf.row();
                    for (Column c2 : this.inputCf.columns()) {
                        outRow.put(c2, row.get(c2));
                    }
                    for (ComputedColumn cc : this.computedColumns) {
                        Column col = this.outputCf.column(cc.name);
                        Expression exp = this.compiledExpressions.get(cc.expr);
                        Object out = exp.evaluate(row);
                        if (out instanceof ExpressionError) {
                            throw new IllegalArgumentException("Computed column evaluation of '" + cc.expr + "' failed: " + ((ExpressionError)out).message);
                        }
                        if (out instanceof String) {
                            outRow.put(col, (String)out);
                            continue;
                        }
                        if (out instanceof Boolean) {
                            outRow.put(col, ((Boolean)out).booleanValue());
                            continue;
                        }
                        if (out instanceof Number) {
                            outRow.put(col, ((Number)out).toString());
                            continue;
                        }
                        if (out == null) {
                            outRow.put(col, null);
                            continue;
                        }
                        logger.warn((Object)("Unknown type of formula result: " + cc.expr));
                        outRow.put(col, out.toString());
                    }
                    this.output.emitRow(outRow);
                    row = this.input.next();
                }
                if (this.emitLastRow) {
                    this.output.lastRowEmitted();
                }
                logger.info((Object)("Computed " + this.rowCount + " rows with computed columns"));
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted computed columns");
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Computed columns failed", (Throwable)e);
                AbstractStagedThreadedBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }
    }

    protected class RenamingThread
    extends ComputationStage {
        private final ColumnRenamer columnRenamer;
        private Throwable exception;
        private RowInputStream input;
        private RowFactory inputRf;
        private long rowCount = 0L;
        private ProcessorOutput output;
        private ColumnFactory inputCf;
        private Schema inputSchema;

        public RenamingThread(ColumnRenamer columnRenamer, Schema inputSchema) {
            this.columnRenamer = columnRenamer;
            this.inputSchema = inputSchema;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.input = input;
            this.inputRf = rf;
            this.inputCf = cf;
            if (this.inputCf != null) {
                for (SchemaColumn c2 : this.inputSchema.getColumns()) {
                    this.inputCf.column(c2.getName());
                }
            }
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.output = output;
            if (this.inputCf != null && cf != null) {
                for (Column c2 : this.inputCf.columns()) {
                    cf.column(c2.getName());
                }
            }
        }

        @Override
        public void run() {
            try {
                Row row = this.input.next();
                while (row != null) {
                    ++this.rowCount;
                    Row currentRow = this.inputRf.row();
                    for (Column sc : this.inputCf.columns()) {
                        currentRow.put(sc, row.get(sc));
                    }
                    this.columnRenamer.processRow(currentRow);
                    this.output.emitRow(currentRow);
                    row = this.input.next();
                }
                if (this.emitLastRow) {
                    this.output.lastRowEmitted();
                }
                logger.info((Object)("Renamed columns in " + this.rowCount + " rows"));
            }
            catch (InterruptedException e) {
                logger.info((Object)("Interrupted renaming columns after " + this.rowCount + " rows"));
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)("Renaming columns failed after " + this.rowCount + " rows"), (Throwable)e);
                AbstractStagedThreadedBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }

        @Override
        protected Throwable getException() {
            return this.exception;
        }
    }
}

