/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.ColumnForComputation;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureContainer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.TimeWindow;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FeatureUtils {
    public static final String ENTITY_FEATURE_DESCRIPTION_TEMPLATE = "%s of %s";
    public static final String FORWARD_FEATURE_DESCRIPTION_TEMPLATE = "%s for each %s%s in %s";
    public static final String BACKWARD_FEATURE_DESCRIPTION_TEMPLATE = "%s of %s for each %s%s in %s";
    public static final String GLOBAL_FEATURE_DESCRIPTION_TEMPLATE = "%s of %s";
    public static final String CUTOFF_TIME_DESCRIPTION_TEMPLATE = " (%sprior to the cutoff time)";
    public static final String TIME_WINDOW_DESCRIPTION_TEMPLATE = "in the %s to %s %s ";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.autofeaturegeneration");

    public static List<ColumnForComputation> getEntityFeatureColumns(RelationshipGraph.Node node, AutoFeatureGenerationRecipePayloadParams params, Integer identifierMaxLength) {
        List<FeatureContainer> entityFeatures = FeatureUtils.getEntityFeatures(node, params, identifierMaxLength);
        return FeatureUtils.convertToColumns(entityFeatures);
    }

    public static List<ColumnForComputation> getForwardFeatureColumns(RelationshipGraph.ForwardEdge forwardEdge, AutoFeatureGenerationRecipePayloadParams params, Integer identifierMaxLength) {
        List<FeatureContainer> forwardFeatures = FeatureUtils.getForwardFeatures(forwardEdge, params, identifierMaxLength);
        return FeatureUtils.convertToColumns(forwardFeatures);
    }

    public static List<ColumnForComputation> getBackwardFeatureColumns(RelationshipGraph.BackwardEdge backwardEdge, AutoFeatureGenerationRecipePayloadParams params, Integer identifierMaxLength) {
        List<FeatureContainer> backwardFeatures = FeatureUtils.getBackwardFeatures(backwardEdge, params, identifierMaxLength, new Schema());
        return FeatureUtils.convertToColumns(backwardFeatures);
    }

    public static List<FeatureContainer> getEntityFeatures(RelationshipGraph.Node node, AutoFeatureGenerationRecipePayloadParams params, Integer identifierMaxLength) {
        ArrayList<FeatureContainer> features = new ArrayList<FeatureContainer>();
        SchemaUtils.SafeColumnIdentifierSuffixer suffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, new Schema());
        StringTransmogrifier transmogrifier = FeatureUtils.initializeTransmogrifier(node.getSchema(), identifierMaxLength);
        for (ColumnForComputation column : node.getColumnsForEntityComputation()) {
            for (AutoFeatureGenerationRecipePayloadParams.Feature feature : params.getEntityFeaturesForType(column.variableType)) {
                if (column.schemaType == Type.DATEONLY && feature == AutoFeatureGenerationRecipePayloadParams.Feature.HOUR_OF_DAY) continue;
                String alias = FeatureUtils.generateNameForEntityFeature(feature, column.name, suffixer, transmogrifier);
                String description = FeatureUtils.generateEntityFeatureDescriptionForColumn(feature, column.name, column.description);
                FeatureContainer featureContainer = new FeatureContainer(column, feature, alias, description);
                features.add(featureContainer);
            }
        }
        return features;
    }

    public static List<FeatureContainer> getForwardFeatures(RelationshipGraph.ForwardEdge forwardEdge, AutoFeatureGenerationRecipePayloadParams params, Integer identifierMaxLength) {
        ArrayList<FeatureContainer> forwardFeatures = new ArrayList<FeatureContainer>();
        String relatedDatasetSanitizedLabel = forwardEdge.getRelatedNodeSanitizedLabel();
        String timeWindowSuffix = forwardEdge.getSingleTimeWindowSuffix();
        SchemaUtils.SafeColumnIdentifierSuffixer suffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, new Schema());
        StringTransmogrifier transmogrifier = FeatureUtils.initializeTransmogrifier(forwardEdge.getSchemaFromCurrentNode(), identifierMaxLength);
        for (ColumnForComputation column : forwardEdge.getColumnsForComputationFromRelatedNode()) {
            String alias = FeatureUtils.generateNameForForwardFeature(relatedDatasetSanitizedLabel, column.name, timeWindowSuffix, suffixer, transmogrifier);
            String description = FeatureUtils.generateForwardFeatureDescriptionForColumn(column.name, column.description, params, forwardEdge);
            FeatureContainer featureContainer = new FeatureContainer(column, alias, description);
            forwardFeatures.add(featureContainer);
        }
        return forwardFeatures;
    }

    public static List<FeatureContainer> getBackwardFeatures(RelationshipGraph.BackwardEdge backwardEdge, AutoFeatureGenerationRecipePayloadParams params, Integer identifierMaxLength, Schema sourceSchema) {
        ArrayList<FeatureContainer> features = new ArrayList<FeatureContainer>();
        String relatedNodeSanitizedLabel = backwardEdge.getRelatedNodeSanitizedLabel();
        String timeWindowSuffix = backwardEdge.getSingleTimeWindowSuffix();
        SchemaUtils.SafeColumnIdentifierSuffixer suffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, new Schema());
        StringTransmogrifier transmogrifier = FeatureUtils.initializeTransmogrifier(backwardEdge.getSchemaFromCurrentNode(), identifierMaxLength);
        SchemaUtils.SafeColumnIdentifierSuffixer groupBySuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, sourceSchema);
        StringTransmogrifier groupByTransmogrifier = FeatureUtils.initializeGroupingTransmogrifier(backwardEdge);
        for (ColumnForComputation column : backwardEdge.getColumnsToAggregate()) {
            for (AutoFeatureGenerationRecipePayloadParams.Feature feature2 : params.getRelationalFeaturesForType(column.variableType)) {
                String alias = FeatureUtils.generateNameForBackwardFeature(feature2, relatedNodeSanitizedLabel, column.name, timeWindowSuffix, suffixer, transmogrifier);
                String groupingQueryColumnName = FeatureUtils.getGroupingQueryColumnName(column.name, feature2, groupBySuffixer, groupByTransmogrifier);
                String description = FeatureUtils.generateBackwardFeatureDescriptionForColumn(feature2, column.name, column.description, params, backwardEdge);
                FeatureContainer featureContainer = new FeatureContainer(column, groupingQueryColumnName, feature2, alias, description);
                features.add(featureContainer);
            }
        }
        if (params.features.stream().anyMatch(feature -> Objects.equals(feature, (Object)AutoFeatureGenerationRecipePayloadParams.Feature.COUNT))) {
            String alias = FeatureUtils.generateNameForGlobalFeature(AutoFeatureGenerationRecipePayloadParams.Feature.COUNT, relatedNodeSanitizedLabel, timeWindowSuffix, suffixer, transmogrifier);
            String description = FeatureUtils.generateGlobalFeatureDescriptionForColumn(AutoFeatureGenerationRecipePayloadParams.Feature.COUNT, backwardEdge.getRelatedNodeLabel());
            FeatureContainer countFeatureContainer = new FeatureContainer(null, groupByTransmogrifier.transmogrify("count"), AutoFeatureGenerationRecipePayloadParams.Feature.COUNT, alias, description);
            features.add(countFeatureContainer);
        }
        return features;
    }

    private static StringTransmogrifier initializeTransmogrifier(Schema existingSchema, Integer identifierMaxLength) {
        StringTransmogrifier transmogrifier = new StringTransmogrifier("_", 0, identifierMaxLength);
        for (SchemaColumn column : existingSchema.getColumns()) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(column.getName());
        }
        return transmogrifier;
    }

    private static StringTransmogrifier initializeGroupingTransmogrifier(RelationshipGraph.BackwardEdge backwardEdge) {
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        for (GroupingRecipePayloadParams.GroupingKey key : backwardEdge.getGroupingKeys()) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(key.column);
        }
        return transmogrifier;
    }

    private static String getGroupingQueryColumnName(String inputColumnName, AutoFeatureGenerationRecipePayloadParams.Feature feature, SchemaUtils.SafeColumnIdentifierSuffixer suffixer, StringTransmogrifier st2) {
        String outputColumnName = inputColumnName;
        switch (feature) {
            case MIN: {
                outputColumnName = suffixer.addSuffix(inputColumnName, "_min");
                break;
            }
            case MAX: {
                outputColumnName = suffixer.addSuffix(inputColumnName, "_max");
                break;
            }
            case DISTINCT: {
                outputColumnName = suffixer.addSuffix(inputColumnName, "_distinct");
                break;
            }
            case AVG: {
                outputColumnName = suffixer.addSuffix(inputColumnName, "_avg");
                break;
            }
            case SUM: {
                outputColumnName = suffixer.addSuffix(inputColumnName, "_sum");
            }
        }
        st2.addAlreadyTransmogrified(outputColumnName);
        return outputColumnName;
    }

    public static List<ColumnForComputation> convertToColumns(List<FeatureContainer> featureContainer) {
        ArrayList<ColumnForComputation> columns = new ArrayList<ColumnForComputation>();
        for (FeatureContainer feature : featureContainer) {
            columns.add(feature.convertToColumn());
        }
        return columns;
    }

    private static String generateNameForEntityFeature(AutoFeatureGenerationRecipePayloadParams.Feature feature, String inputColumnName, SchemaUtils.SafeColumnIdentifierSuffixer suffixer, StringTransmogrifier transmogrifier) {
        String fullColumnName = feature.shortName + "_" + inputColumnName;
        return transmogrifier.transmogrify(suffixer.addSuffix(fullColumnName, ""));
    }

    private static String generateEntityFeatureDescriptionForColumn(AutoFeatureGenerationRecipePayloadParams.Feature feature, String inputColumnName, String inputColumnDescription) {
        return String.format("%s of %s", feature.description, StringUtils.isNotBlank((String)inputColumnDescription) ? inputColumnDescription : inputColumnName);
    }

    private static String generateNameForForwardFeature(String relatedDatasetLabel, String columnName, String timeWindowSuffix, SchemaUtils.SafeColumnIdentifierSuffixer suffixer, StringTransmogrifier transmogrifier) {
        String fullColumnName = relatedDatasetLabel.toUpperCase() + timeWindowSuffix + "_" + columnName;
        return transmogrifier.transmogrify(suffixer.addSuffix(fullColumnName, ""));
    }

    private static String generateForwardFeatureDescriptionForColumn(String relatedColumName, String relatedColumnDescription, AutoFeatureGenerationRecipePayloadParams params, RelationshipGraph.ForwardEdge forwardEdge) {
        if (forwardEdge.matchingConditions.isEmpty()) {
            logger.warn((Object)"Matching conditions are empty, unable to create column description");
            return null;
        }
        String joinKeys = forwardEdge.matchingConditions.stream().map(matchingCondition -> matchingCondition.column1.name).collect(Collectors.joining(", "));
        String timeWindowDescription = FeatureUtils.getTimeSettingsDescription(params, forwardEdge);
        return String.format(FORWARD_FEATURE_DESCRIPTION_TEMPLATE, StringUtils.isNotBlank((String)relatedColumnDescription) ? relatedColumnDescription : relatedColumName, joinKeys, timeWindowDescription, forwardEdge.getRelatedNodeLabel());
    }

    private static String generateNameForBackwardFeature(AutoFeatureGenerationRecipePayloadParams.Feature feature, String relatedDatasetLabel, String columnName, String timeWindowSuffix, SchemaUtils.SafeColumnIdentifierSuffixer suffixer, StringTransmogrifier transmogrifier) {
        String fullColumnName = feature.shortName + "_" + relatedDatasetLabel.toUpperCase() + timeWindowSuffix + "_" + columnName;
        return transmogrifier.transmogrify(suffixer.addSuffix(fullColumnName, ""));
    }

    private static String generateBackwardFeatureDescriptionForColumn(AutoFeatureGenerationRecipePayloadParams.Feature feature, String relatedColumnName, String relatedColumnDescription, AutoFeatureGenerationRecipePayloadParams params, RelationshipGraph.BackwardEdge backwardEdge) {
        if (backwardEdge.matchingConditions.isEmpty()) {
            logger.warn((Object)"Matching conditions are empty, unable to create column description");
            return null;
        }
        String joinKeys = backwardEdge.matchingConditions.stream().map(matchingCondition -> matchingCondition.column2.name).collect(Collectors.joining(", "));
        String timeWindowDescription = FeatureUtils.getTimeSettingsDescription(params, backwardEdge);
        return String.format(BACKWARD_FEATURE_DESCRIPTION_TEMPLATE, feature.description, StringUtils.isNotBlank((String)relatedColumnDescription) ? relatedColumnDescription : relatedColumnName, joinKeys, timeWindowDescription, backwardEdge.getRelatedNodeLabel());
    }

    private static String generateNameForGlobalFeature(AutoFeatureGenerationRecipePayloadParams.Feature feature, String relatedDatasetLabel, String timeWindowSuffix, SchemaUtils.SafeColumnIdentifierSuffixer suffixer, StringTransmogrifier transmogrifier) {
        String fullColumnName = feature.shortName + "_" + relatedDatasetLabel.toUpperCase() + timeWindowSuffix;
        return transmogrifier.transmogrify(suffixer.addSuffix(fullColumnName, ""));
    }

    private static String generateGlobalFeatureDescriptionForColumn(AutoFeatureGenerationRecipePayloadParams.Feature feature, String datasetName) {
        return String.format("%s of %s", feature.description, datasetName);
    }

    public static Integer getIdentifierMaxLength(SQLDialect dialect) {
        if (dialect == null) {
            return null;
        }
        int maxLength = dialect.getIdentifiersMaxLength();
        if (dialect instanceof SnowflakeSQLDialect) {
            maxLength -= 5;
        }
        return maxLength;
    }

    private static String getTimeSettingsDescription(AutoFeatureGenerationRecipePayloadParams params, RelationshipGraph.Edge edge) {
        if (params.cutoffTime.mode != AutoFeatureGenerationRecipePayloadParams.CutoffTime.CutoffTimeMode.COLUMN) {
            return "";
        }
        RelationshipGraph.Node relatedNode = edge.getRelatedNode();
        if (!relatedNode.hasTimeIndexColumn()) {
            return "";
        }
        List<TimeWindow> timeWindows = relatedNode.getTimeWindows();
        String timeWindowDescription = "";
        if (timeWindows != null && !timeWindows.isEmpty()) {
            TimeWindow timeWindow = timeWindows.get(0);
            timeWindowDescription = String.format(TIME_WINDOW_DESCRIPTION_TEMPLATE, timeWindow.from, timeWindow.to, timeWindow.windowUnit.name().toLowerCase() + "s");
        }
        return String.format(CUTOFF_TIME_DESCRIPTION_TEMPLATE, timeWindowDescription);
    }
}

