/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.FuzzyJoinRecords;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Record;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.CandidateBlocksContainer;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.Node;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.Stage;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.CandidateSelectionAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class CandidateSelectorPipeline {
    public boolean isBuilding;
    public Record target;
    private final List<Stage> stages;
    private final CandidateBlocksContainer candidateBlocksContainer = new CandidateBlocksContainer();

    public CandidateSelectorPipeline(FuzzyJoinRecipePayloadParams.JoinDesc matchingConditions, FuzzyJoinRecords referenceRecords, boolean debugMode) throws Exception {
        this.stages = this.buildStages(matchingConditions, debugMode);
        this.populateWithCandidates(referenceRecords);
    }

    public List<Record> selectCandidates(Record query) {
        HashSet<Record> candidates = new HashSet<Record>();
        for (Node outputNode : this.executePipeline(query, false)) {
            candidates.addAll(this.candidateBlocksContainer.getBlockOfCandidates(outputNode));
        }
        return new ArrayList<Record>(candidates);
    }

    private void writeToInput() {
        Queue<Node> input = this.stages.get((int)0).inputQueue;
        input.add(Node.newStartSignal());
        input.add(Node.newDefaultNode());
        input.add(Node.newStopSignal());
    }

    private List<Node> readFromOutput() {
        ArrayList<Node> validNodes = new ArrayList<Node>();
        Queue<Node> output = this.stages.get((int)(this.stages.size() - 1)).outputQueue;
        while (true) {
            Node node;
            if ((node = output.poll()) == null || node.isStartSignal()) {
                continue;
            }
            if (node.isStopSignal()) {
                return validNodes;
            }
            validNodes.add(node);
        }
    }

    private List<Stage> buildStages(FuzzyJoinRecipePayloadParams.JoinDesc joinDesc, boolean debugMode) {
        List<Stage> ret = new ArrayList<Stage>();
        List matchingConditions = joinDesc.on;
        Map<CandidateSelectionAlgorithm, List<Integer>> indexOfJoinValueByCandidateSelectionAlgo = this.mapInstancesToJoinValues(matchingConditions);
        for (Map.Entry<CandidateSelectionAlgorithm, List<Integer>> entry : indexOfJoinValueByCandidateSelectionAlgo.entrySet()) {
            CandidateSelectionAlgorithm candidateSelectionAlgorithm = entry.getKey();
            List<Integer> indexesJoinValues = entry.getValue();
            if (candidateSelectionAlgorithm.hasMultipleJoinValues()) {
                ArrayList<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> listOfMatchDesc = new ArrayList<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc>();
                for (int idxJoinValue : indexesJoinValues) {
                    listOfMatchDesc.add(((FuzzyJoinRecipePayloadParams.MatchingCondition)matchingConditions.get((int)idxJoinValue)).fuzzyMatchDesc);
                }
                ret.add(new Stage(this, candidateSelectionAlgorithm, indexesJoinValues, listOfMatchDesc));
                continue;
            }
            for (Integer idxJoinValue : indexesJoinValues) {
                List<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> listOfMatchDesc = Collections.singletonList(((FuzzyJoinRecipePayloadParams.MatchingCondition)matchingConditions.get((int)idxJoinValue.intValue())).fuzzyMatchDesc);
                ret.add(new Stage(this, candidateSelectionAlgorithm, Collections.singletonList(idxJoinValue), listOfMatchDesc));
            }
        }
        if (ret.isEmpty() || debugMode) {
            ret = Collections.singletonList(new Stage(this, CandidateSelectionAlgorithm.DUMMY, new ArrayList<Integer>(), new ArrayList<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc>()));
        } else {
            Collections.sort(ret);
            CandidateSelectorPipeline.chain(ret);
        }
        return ret;
    }

    private List<Node> executePipeline(Record target, boolean isBuilding) {
        this.target = target;
        this.isBuilding = isBuilding;
        this.writeToInput();
        for (Stage stage : this.stages) {
            stage.processInputs();
        }
        return this.readFromOutput();
    }

    private Map<CandidateSelectionAlgorithm, List<Integer>> mapInstancesToJoinValues(List<FuzzyJoinRecipePayloadParams.MatchingCondition> matchingConditions) {
        HashMap<CandidateSelectionAlgorithm, List<Integer>> selectionExecutorToIndexOfJoinValue = new HashMap<CandidateSelectionAlgorithm, List<Integer>>();
        for (int idxJoinValue = 0; idxJoinValue < matchingConditions.size(); ++idxJoinValue) {
            FuzzyJoinRecipePayloadParams.MatchingCondition condition = matchingConditions.get(idxJoinValue);
            List<CandidateSelectionAlgorithm> candidateSelectionAlgorithms = condition.fuzzyMatchDesc.distanceType.getCandidateSelectionAlgorithms();
            for (CandidateSelectionAlgorithm candidateSelectionAlgorithm : candidateSelectionAlgorithms) {
                if (!selectionExecutorToIndexOfJoinValue.containsKey((Object)candidateSelectionAlgorithm)) {
                    selectionExecutorToIndexOfJoinValue.put(candidateSelectionAlgorithm, new ArrayList());
                }
                ((List)selectionExecutorToIndexOfJoinValue.get((Object)candidateSelectionAlgorithm)).add(idxJoinValue);
            }
        }
        return selectionExecutorToIndexOfJoinValue;
    }

    private static void chain(List<Stage> stages) {
        for (int i = 1; i < stages.size(); ++i) {
            stages.get((int)i).inputQueue = stages.get((int)(i - 1)).outputQueue;
        }
    }

    private void populateWithCandidates(FuzzyJoinRecords referenceRecords) throws Exception {
        try (FuzzyJoinRecords.RecordsIterator candidateIterator = referenceRecords.iterator();){
            while (candidateIterator.hasNext()) {
                Record candidate = candidateIterator.next();
                this.addCandidate(candidate);
            }
        }
    }

    private void addCandidate(Record candidate) {
        List<Node> nodes = this.executePipeline(candidate, true);
        for (Node outputNode : nodes) {
            this.candidateBlocksContainer.addCandidate(candidate, outputNode);
        }
    }
}

