/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeCreator;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeRunner;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeStatusComputer;
import com.dataiku.dip.dataflow.pipeline.GroupingRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.MetaWithContainerizablePayload;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class GroupingRecipeMeta
extends RecipeMeta
implements BasicRecipeLineageHandler,
MetaWithContainerizablePayload {
    public static final GroupingRecipeMeta META = new GroupingRecipeMeta();
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.recipe.group");

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return NoParams.class;
    }

    @Override
    public String getType() {
        return "grouping";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new GroupingRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new GroupingRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new GroupingRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new GroupingRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return RecipeDesc.newSisoDesc(ts.translate(lang, "RECIPE.GROUPING.NAME", "group", new Object[0]), null).multiEngine(true);
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualSQL().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        params.engineType = engine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        params.engineParams.impala.forceStreamMode = runInStreamMode;
        return JSON.pretty((Object)params);
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return ((GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class)).engineParams.sparkSQL.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        params.engineParams.sparkSQL.readParams = inputDatasetsReadParams;
        return JSON.pretty((Object)params);
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new GroupingRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public ContainerExecSelection getContainerExecSelection(SerializedRecipe sr, String payload) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        return params.getContainerSelection();
    }

    @Override
    public Class<? extends ParamsWithContainerizable> getContainerizableBearingParamsClass() {
        return GroupingRecipePayloadParams.class;
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
        if (predecessors.datasets.isEmpty() || successors.datasets.isEmpty()) {
            return new RecipeLineage();
        }
        Preconditions.checkArgument((predecessors.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Grouping recipe can have only one input dataset");
        Preconditions.checkArgument((successors.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Grouping recipe can have only one output dataset");
        SerializedDataset inputDataset = predecessors.datasets.get(0);
        SerializedDataset outputDataset = successors.datasets.get(0);
        GroupingRecipePayloadParams payloadParams = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        RecipeLineage recipeLineage = this.buildBasicRecipeLineage((BasicRecipeLineageHandler.Params)payloadParams, inputDataset, outputDataset);
        Schema inputSchema = inputDataset.getSchema();
        for (GroupingRecipePayloadParams.GroupingKey keyDesc : payloadParams.getRawGroupingKeys()) {
            recipeLineage.addFactorizedColumnRelations(keyDesc.column, keyDesc.column, inputDataset, outputDataset);
        }
        OracleSQLDialect dialect = inputDataset.type.equals(BuiltinSQLDatasets.ORACLE_META.getType()) ? new OracleSQLDialect(authCtx, Dataset.fromSerialized(inputDataset)) : null;
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), inputSchema);
        List<GroupingRecipePayloadParams.GroupingValue> groupingValues = payloadParams.values.stream().filter(value -> value.column != null && value.hasAnyAggr()).toList();
        for (GroupingRecipePayloadParams.GroupingValue groupingValue : groupingValues) {
            SchemaColumn schemaColumn = ExpressionUtils.getSchemaColumn(groupingValue.column, inputSchema, payloadParams.computedColumns);
            ArrayList<SchemaColumn> derivedColumns = groupingValue.getDerivedColumns(payloadParams, schemaColumn.getType(), safeSuffixer);
            for (SchemaColumn derivedColumn : derivedColumns) {
                String outputColumnName = derivedColumn.getName();
                recipeLineage.addFactorizedColumnRelations(groupingValue.column, outputColumnName, inputDataset, outputDataset);
                for (GroupingRecipePayloadParams.GroupingKey keyDesc : payloadParams.getRawGroupingKeys()) {
                    recipeLineage.addFactorizedColumnRelations(keyDesc.column, outputColumnName, inputDataset, outputDataset, true);
                }
            }
        }
        DatasetPairLineage datasetPairLineage = recipeLineage.getDatasetPairLineage(inputDataset.getFullName(), outputDataset.getFullName());
        if (datasetPairLineage != null) {
            for (GroupingRecipePayloadParams.GroupingValue groupingValue : groupingValues) {
                datasetPairLineage.removeRelationsOnColumn(groupingValue.column);
            }
        }
        this.handleColumnNameOverrides(payloadParams, recipeLineage);
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }
}

