/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeQueryGenerator;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class JoinQueryGenerator
extends JoinLikeQueryGenerator<JoinRecipePayloadParams, JoinRecipePayloadParams.MatchingCondition, JoinRecipePayloadParams.JoinDesc> {
    public JoinQueryGenerator(JoinRecipePayloadParams params, Map<String, Dataset> sources, Map<String, SQLUtils.SQLTable> tables, Dataset outputDataset, JoinOutputRole role) {
        super(params, sources, tables, outputDataset, role);
    }

    @Override
    protected void joinUsingTypeSpecificOperators(SelectQueryBuilder wrapper, SelectQueryBuilder query, JoinRecipePayloadParams.JoinDesc join, SelectQueryBuilder.JoinClauseBuilder joinBuilder, JoinInputDescBase table1Desc, JoinInputDescBase table2Desc) {
        ExpressionBuilder orderExpression = ef.cst(1);
        int maxMatches = 0;
        boolean strict = false;
        if (join.getRightLimit() != null) {
            maxMatches = join.getRightLimit().maxMatches;
            strict = join.getRightLimit().strict;
        }
        for (JoinRecipePayloadParams.MatchingCondition cond : join.getJoinConditions()) {
            Type type2;
            ExpressionBuilder col1 = this.col(cond.column1);
            ExpressionBuilder col2 = this.col(cond.column2);
            col1 = this.applyColumnPreparationSteps(cond, col1);
            col2 = this.applyColumnPreparationSteps(cond, col2);
            Map<String, SchemaColumn> flatVirtualColumnsMap = this.virtualColumnsByDataset.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
            SchemaColumn schemaColumn1 = ExpressionUtils.getSchemaColumn(cond.column1.name, ((Dataset)this.sources.get(table1Desc.name)).getSchema(), table1Desc.computedColumns, flatVirtualColumnsMap);
            SchemaColumn schemaColumn2 = ExpressionUtils.getSchemaColumn(cond.column2.name, ((Dataset)this.sources.get(table2Desc.name)).getSchema(), table2Desc.computedColumns, flatVirtualColumnsMap);
            Type type1 = schemaColumn1.getType();
            if (JoinRecipePayloadParams.incompatibleTypesForJoinCondition(type1, type2 = schemaColumn2.getType()) && ((JoinRecipePayloadParams)this.params).enableAutoCastInJoinConditions) {
                if (type1 != Type.STRING) {
                    col1 = col1.castToString(this.dialect.getDefaultVarcharLen());
                }
                if (type2 != Type.STRING) {
                    col2 = col2.castToString(this.dialect.getDefaultVarcharLen());
                }
            }
            col1.expr.outputType.dssType = type1;
            col2.expr.outputType.dssType = type2;
            switch (cond.type) {
                case EQ: {
                    joinBuilder.on(col1.nullUnsafeEq(col2));
                    break;
                }
                case LTE: {
                    joinBuilder.on(col1.lte(col2));
                    break;
                }
                case LT: {
                    joinBuilder.on(col1.lt(col2));
                    break;
                }
                case GTE: {
                    joinBuilder.on(col1.gte(col2));
                    break;
                }
                case GT: {
                    joinBuilder.on(col1.gt(col2));
                    break;
                }
                case NE: {
                    joinBuilder.on(col1.ne(col2));
                    break;
                }
                case CONTAINS: {
                    joinBuilder.on(col1.contains(col2));
                    break;
                }
                case STARTS_WITH: {
                    joinBuilder.on(col1.startsWith(col2));
                    break;
                }
                case K_NEAREST: 
                case WITHIN_RANGE: {
                    ExpressionBuilder absDiff = ExpressionUtils.diff(col1, col2, type2, cond.dateDiffUnit).abs();
                    joinBuilder.on(absDiff.lte(cond.maxDistance));
                    orderExpression = absDiff;
                    maxMatches = cond.maxMatches;
                    strict = cond.strict;
                    break;
                }
                case K_NEAREST_INFERIOR: {
                    ExpressionBuilder diff = ExpressionUtils.diff(col1, col2, type2, cond.dateDiffUnit);
                    joinBuilder.on(diff.gte(0));
                    joinBuilder.on(diff.lte(cond.maxDistance));
                    orderExpression = diff;
                    maxMatches = cond.maxMatches;
                    strict = cond.strict;
                    break;
                }
                case WITHIN_WINDOW_OF: {
                    if (this.dialect.getOperator(QueryUtils.OperatorType.DATE_ADD) != null) {
                        joinBuilder.on(col2.gt(col1.dateAdd(-1L * cond.windowFrom, cond.dateDiffUnit)));
                        if (cond.windowTo == 0L) {
                            joinBuilder.on(col2.lt(col1));
                            break;
                        }
                        joinBuilder.on(col2.lte(col1.dateAdd(-1L * cond.windowTo, cond.dateDiffUnit)));
                        break;
                    }
                    ExpressionBuilder withinDiff = ExpressionUtils.diff(col1, col2, type2, cond.dateDiffUnit);
                    joinBuilder.on(withinDiff.lt(cond.windowFrom));
                    if (cond.windowTo == 0L) {
                        joinBuilder.on(col1.gt(col2));
                        break;
                    }
                    joinBuilder.on(withinDiff.gte(cond.windowTo));
                }
            }
        }
        if (join.type != JoinType.CROSS && join.conditionsMode == ConditionsMode.CUSTOM) {
            String left = this.dialect.quoteIdentifier(((JoinRecipePayloadParams.InputDesc)((JoinRecipePayloadParams)this.params).virtualInputs.get((int)join.table1)).alias);
            String right = this.dialect.quoteIdentifier(((JoinRecipePayloadParams.InputDesc)((JoinRecipePayloadParams)this.params).virtualInputs.get((int)join.table2)).alias);
            if (StringUtils.isBlank((String)join.customSQLCondition)) {
                throw ErrorContext.iae((String)"Empty custom join condition");
            }
            String expandedCondition = join.customSQLCondition.replaceAll("(?i)\\$left", left).replaceAll("(?i)\\$right", right);
            joinBuilder.on(ef.expr(expandedCondition));
        }
        if (this.requiresUniqueKey(join)) {
            String rowNumber = this.addTemporaryUniqueKey(query);
            this.limitMatches(wrapper, query, Lists.newArrayList((Object[])new ExpressionBuilder[]{ef.col(rowNumber)}), orderExpression, maxMatches, strict);
        }
    }

    @Override
    protected ExpressionBuilder applyColumnPreparationSteps(JoinRecipePayloadParams.MatchingCondition condition, ExpressionBuilder eb) {
        if (condition.normalizeText) {
            eb = eb.normalizeText();
        }
        if (condition.caseInsensitive) {
            eb = eb.lower();
        }
        return eb;
    }

    @Override
    protected boolean requiresWrapper(JoinRecipePayloadParams.JoinDesc join) {
        for (JoinRecipePayloadParams.MatchingCondition cond : join.getJoinConditions()) {
            switch (cond.type) {
                case EQ: 
                case LTE: 
                case GTE: 
                case NE: 
                case CONTAINS: 
                case STARTS_WITH: 
                case WITHIN_WINDOW_OF: {
                    break;
                }
                case K_NEAREST: 
                case WITHIN_RANGE: 
                case K_NEAREST_INFERIOR: {
                    if (cond.maxMatches == 0 || join.getJoinConditions().size() <= 1) break;
                    return true;
                }
            }
        }
        return this.requiresUniqueKey(join);
    }
}

