/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeCreator;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeRunner;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.pipeline.JoinRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.datalineage.DataLineageUtils;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MetaWithContainerizablePayload;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JoinRecipeMeta
extends RecipeMeta
implements MetaWithContainerizablePayload {
    public static final JoinRecipeMeta META = new JoinRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return NoParams.class;
    }

    @Override
    public String getType() {
        return "join";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new JoinRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new JoinRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new JoinRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new JoinRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc desc = RecipeDesc.newSisoDesc(ts.translate(lang, "RECIPE.JOIN.NAME", "join", new Object[0]), null);
        RecipeDesc.IORoleDef mainInput = desc.inputRoles.get(0);
        mainInput.arity = RecipeDesc.IOArity.NARY;
        mainInput.withEditable(true, false);
        mainInput.description = ts.translate(lang, "RECIPE.JOIN.DESC.INPUT_DATASETS", "Input datasets can be added/removed from the settings tab", new Object[0]);
        desc.isMultiEngine = true;
        RecipeDesc.IORoleDef leftUnmatched = RecipeDesc.IORoleDef.newUnaryDataset(JoinOutputRole.UNMATCHED_ROWS_LEFT.name, ts.translate(lang, "RECIPE.JOIN.DESC.UNMATCHED_ROWS_LEFT", "Unmatched rows from left input", new Object[0]));
        leftUnmatched.withEditable(true, false);
        leftUnmatched.description = ts.translate(lang, "RECIPE.JOIN.DESC.UNMATCHED_ROWS_SETTINGS", "Unmatched outputs can be managed from the settings tab", new Object[0]);
        desc.outputRoles.add(leftUnmatched);
        RecipeDesc.IORoleDef rightUnmatched = RecipeDesc.IORoleDef.newUnaryDataset(JoinOutputRole.UNMATCHED_ROWS_RIGHT.name, ts.translate(lang, "RECIPE.JOIN.DESC.UNMATCHED_ROWS_RIGHT", "Unmatched rows from right input", new Object[0]));
        rightUnmatched.withEditable(true, false);
        rightUnmatched.description = ts.translate(lang, "RECIPE.JOIN.DESC.UNMATCHED_ROWS_SETTINGS", "Unmatched outputs can be managed from the settings tab", new Object[0]);
        desc.outputRoles.add(rightUnmatched);
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualSQL().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        params.engineType = engine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        params.engineParams.impala.forceStreamMode = runInStreamMode;
        return JSON.pretty((Object)params);
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return ((JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class)).engineParams.sparkSQL.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        params.engineParams.sparkSQL.readParams = inputDatasetsReadParams;
        return JSON.pretty((Object)params);
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new JoinRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
        List<ExpandedMatchingCondition> expandedMatchingConditions;
        RecipeLineage recipeLineage = new RecipeLineage();
        if (predecessors.datasets.isEmpty() || successors.datasets.isEmpty()) {
            return recipeLineage;
        }
        JoinRecipeSchemaComputer computer = new JoinRecipeSchemaComputer(authCtx, activity);
        JoinRecipePayloadParams payloadParams = computer.getHelper().loadParams(payload, computer.getRecipe());
        computer.setParams(payloadParams);
        DatasetPairLineage leftUnmatchedDatasetPairLineage = this.createDatasetPairLineageForUnmatchedDataset(predecessors, successors, computer, payloadParams, JoinOutputRole.UNMATCHED_ROWS_LEFT, 0);
        recipeLineage.addDatasetPairLineage(leftUnmatchedDatasetPairLineage);
        DatasetPairLineage rightUnmatchedDatasetPairLineage = this.createDatasetPairLineageForUnmatchedDataset(predecessors, successors, computer, payloadParams, JoinOutputRole.UNMATCHED_ROWS_RIGHT, 1);
        recipeLineage.addDatasetPairLineage(rightUnmatchedDatasetPairLineage);
        String mainOutputName = computer.getOutputFullName(JoinOutputRole.MAIN);
        SerializedDataset mainOutputDataset = this.getSerializedDataset(successors.datasets, mainOutputName);
        payloadParams.virtualInputs.forEach(virtualInput -> {
            SerializedDataset inputDataset = this.getSerializedDataset(predecessors.datasets, virtualInput.name);
            DatasetPairLineage mainOutputLineage = recipeLineage.getOrCreateDatasetPairLineage(inputDataset, mainOutputDataset);
            mainOutputLineage.initializeDirectColumnRelations();
            recipeLineage.setUncertain(recipeLineage.isUncertain() || DataLineageUtils.shouldMarkLineageUncertain(virtualInput.getComputedColumns()));
            Map<String, List<String>> usedColumnsByComputedColumn = DataLineageUtils.getComputedColumnsInputs(virtualInput.getComputedColumns());
            JoinRecipeMeta.addComputedColumnRelations(usedColumnsByComputedColumn, recipeLineage, inputDataset, mainOutputDataset);
            if (computer.hasOutput(JoinOutputRole.UNMATCHED_ROWS_LEFT) && inputDataset.getFullName().equals(((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)0)).name)) {
                SerializedDataset leftOutputDataset = this.getSerializedDataset(successors.datasets, computer.getOutputFullName(JoinOutputRole.UNMATCHED_ROWS_LEFT));
                JoinRecipeMeta.addComputedColumnRelations(usedColumnsByComputedColumn, recipeLineage, inputDataset, leftOutputDataset);
            }
            if (computer.hasOutput(JoinOutputRole.UNMATCHED_ROWS_RIGHT) && inputDataset.getFullName().equals(((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)1)).name)) {
                SerializedDataset rightOutputDataset = this.getSerializedDataset(successors.datasets, computer.getOutputFullName(JoinOutputRole.UNMATCHED_ROWS_RIGHT));
                JoinRecipeMeta.addComputedColumnRelations(usedColumnsByComputedColumn, recipeLineage, inputDataset, rightOutputDataset);
            }
        });
        try {
            computer.getSchema(JoinOutputRole.MAIN);
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Join Recipe: Failed to compute main output schema", (Throwable)e);
        }
        for (ColumnDesc columnDesc : payloadParams.getSelectedColumns()) {
            String inputColumnName = columnDesc.name;
            String inputDatasetName = ((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)columnDesc.table)).name;
            if (inputDatasetName == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Join Recipe: Input dataset name cannot be null");
            }
            SerializedDataset inputDataset = this.getSerializedDataset(predecessors.datasets, inputDatasetName);
            String outputColumnName = columnDesc.alias;
            recipeLineage.addFactorizedColumnRelations(inputColumnName, outputColumnName, inputDataset, mainOutputDataset);
        }
        recipeLineage.setUncertain(recipeLineage.isUncertain() || DataLineageUtils.shouldMarkLineageUncertain(payloadParams.getComputedColumns()));
        Map<String, List<String>> usedColumnsByComputedColumn = DataLineageUtils.getComputedColumnsInputs(payloadParams.getComputedColumns());
        payloadParams.virtualInputs.forEach(virtualInput -> {
            SerializedDataset inputDataset = this.getSerializedDataset(predecessors.datasets, virtualInput.name);
            JoinRecipeMeta.addComputedColumnRelations(usedColumnsByComputedColumn, recipeLineage, inputDataset, mainOutputDataset);
        });
        if (payloadParams.joins.stream().anyMatch(joinDesc -> ConditionsMode.CUSTOM.equals((Object)joinDesc.conditionsMode))) {
            recipeLineage.setUncertain(true);
        }
        if (!(expandedMatchingConditions = this.getExpandedMatchingConditions(payloadParams)).isEmpty()) {
            VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine;
            try {
                selectedEngine = computer.getEngine();
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Join Recipe: Failed to get engine", (Throwable)e);
            }
            for (ExpandedMatchingCondition expandedMatchingCondition : expandedMatchingConditions) {
                String column2Alias;
                String column1Alias;
                String inputDatasetName1 = expandedMatchingCondition.inputDataset1;
                String inputDatasetName2 = expandedMatchingCondition.inputDataset2;
                String inputColumn1 = expandedMatchingCondition.column1.name;
                String inputColumn2 = expandedMatchingCondition.column2.name;
                try {
                    column1Alias = computer.computeColumnAlias(expandedMatchingCondition.column1, expandedMatchingCondition.prefix1, selectedEngine);
                    column2Alias = computer.computeColumnAlias(expandedMatchingCondition.column2, expandedMatchingCondition.prefix2, selectedEngine);
                }
                catch (Exception e) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Join Recipe: Failed to compute column aliases", (Throwable)e);
                }
                SerializedDataset inputDataset1 = this.getSerializedDataset(predecessors.datasets, inputDatasetName1);
                SerializedDataset inputDataset2 = this.getSerializedDataset(predecessors.datasets, inputDatasetName2);
                recipeLineage.addFactorizedColumnRelations(inputColumn1, column1Alias, inputDataset1, mainOutputDataset);
                recipeLineage.addFactorizedColumnRelations(inputColumn2, column1Alias, inputDataset2, mainOutputDataset);
                recipeLineage.addFactorizedColumnRelations(inputColumn1, column2Alias, inputDataset1, mainOutputDataset);
                recipeLineage.addFactorizedColumnRelations(inputColumn2, column2Alias, inputDataset2, mainOutputDataset);
            }
        }
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }

    private static void addComputedColumnRelations(Map<String, List<String>> usedColumnsByComputedColumn, RecipeLineage recipeLineage, SerializedDataset inputDataset, SerializedDataset mainOutputDataset) {
        usedColumnsByComputedColumn.forEach((computedColumn, usedColumns) -> usedColumns.forEach(usedColumn -> recipeLineage.addFactorizedColumnRelations((String)usedColumn, (String)computedColumn, inputDataset, mainOutputDataset)));
    }

    private DatasetPairLineage createDatasetPairLineageForUnmatchedDataset(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, JoinRecipeSchemaComputer computer, JoinRecipePayloadParams payloadParams, JoinOutputRole joinOutputRole, int joinVirtualInputIndex) {
        DatasetPairLineage datasetPairLineage = null;
        if (computer.hasOutput(joinOutputRole)) {
            String inputDatasetName = ((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)joinVirtualInputIndex)).name;
            String outputDatasetName = computer.getOutputFullName(joinOutputRole);
            SerializedDataset inputDataset = this.getSerializedDataset(predecessors.datasets, inputDatasetName);
            SerializedDataset outputDataset = this.getSerializedDataset(successors.datasets, outputDatasetName);
            datasetPairLineage = new DatasetPairLineage(inputDataset, outputDataset);
            datasetPairLineage.initializeDirectColumnRelations();
        }
        return datasetPairLineage;
    }

    private List<ExpandedMatchingCondition> getExpandedMatchingConditions(JoinRecipePayloadParams payloadParams) {
        ArrayList<ExpandedMatchingCondition> expandedMatchingConditions = new ArrayList<ExpandedMatchingCondition>();
        HashMap<ColumnDescWithDatasetAndPrefix, Set> equalColumnsMap = new HashMap<ColumnDescWithDatasetAndPrefix, Set>();
        for (JoinRecipePayloadParams.JoinDesc joinDesc : payloadParams.joins) {
            String inputDataset1 = ((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)joinDesc.table1)).name;
            String inputDataset2 = ((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)joinDesc.table2)).name;
            String prefix1 = ((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)joinDesc.table1)).prefix;
            String prefix2 = ((JoinRecipePayloadParams.InputDesc)payloadParams.virtualInputs.get((int)joinDesc.table2)).prefix;
            for (JoinRecipePayloadParams.MatchingCondition matchingCondition : joinDesc.on) {
                ColumnDescWithDatasetAndPrefix column1 = new ColumnDescWithDatasetAndPrefix(matchingCondition.column1, inputDataset1, prefix1);
                ColumnDescWithDatasetAndPrefix column2 = new ColumnDescWithDatasetAndPrefix(matchingCondition.column2, inputDataset2, prefix2);
                if (matchingCondition.type.equals((Object)JoinRecipePayloadParams.MatchingType.EQ)) {
                    equalColumnsMap.computeIfAbsent(column1, k -> new HashSet()).add(column1);
                    equalColumnsMap.computeIfAbsent(column2, k -> new HashSet()).add(column2);
                    ((Set)equalColumnsMap.get(column1)).addAll((Collection)equalColumnsMap.get(column2));
                    ((Set)equalColumnsMap.get(column2)).addAll((Collection)equalColumnsMap.get(column1));
                    continue;
                }
                expandedMatchingConditions.add(new ExpandedMatchingCondition(matchingCondition.column1, matchingCondition.column2, inputDataset1, inputDataset2, prefix1, prefix2));
            }
        }
        HashSet uniqueEqualColumnsSets = new HashSet(equalColumnsMap.values());
        for (Set equalColumns : uniqueEqualColumnsSets) {
            ArrayList equalColumnsList = new ArrayList(equalColumns);
            for (int i = 0; i < equalColumnsList.size(); ++i) {
                for (int j = i + 1; j < equalColumnsList.size(); ++j) {
                    ColumnDescWithDatasetAndPrefix column1 = (ColumnDescWithDatasetAndPrefix)equalColumnsList.get(i);
                    ColumnDescWithDatasetAndPrefix column2 = (ColumnDescWithDatasetAndPrefix)equalColumnsList.get(j);
                    expandedMatchingConditions.add(new ExpandedMatchingCondition(column1.columnDesc, column2.columnDesc, column1.dataset, column2.dataset, column1.prefix, column2.prefix));
                }
            }
        }
        return expandedMatchingConditions;
    }

    @Override
    public ContainerExecSelection getContainerExecSelection(SerializedRecipe sr, String payload) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        return params.getContainerSelection();
    }

    @Override
    public Class<? extends ParamsWithContainerizable> getContainerizableBearingParamsClass() {
        return JoinRecipePayloadParams.class;
    }

    private static class ExpandedMatchingCondition {
        ColumnDesc column1;
        ColumnDesc column2;
        String inputDataset1;
        String inputDataset2;
        String prefix1;
        String prefix2;

        public ExpandedMatchingCondition(ColumnDesc column1, ColumnDesc column2, String inputDataset1, String inputDataset2, String prefix1, String prefix2) {
            this.column1 = column1;
            this.column2 = column2;
            this.inputDataset1 = inputDataset1;
            this.inputDataset2 = inputDataset2;
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
        }
    }

    private static class ColumnDescWithDatasetAndPrefix {
        public ColumnDesc columnDesc;
        public String dataset;
        public String prefix;

        public ColumnDescWithDatasetAndPrefix(ColumnDesc columnDesc, String dataset, String prefix) {
            this.columnDesc = columnDesc;
            this.dataset = dataset;
            this.prefix = prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnDescWithDatasetAndPrefix that = (ColumnDescWithDatasetAndPrefix)o;
            return Objects.equals(this.columnDesc, that.columnDesc) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.prefix, that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.columnDesc, this.dataset, this.prefix);
        }
    }
}

