/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLQueryRecipeCreator
extends SingleOutputDatasetRecipeCreator {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private SQLNotebooksService sqlNotebookService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sql.creation");

    public SQLQueryRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta, true);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        RecipeCreator.CreationResult creationResult = super.create_NT(recipe, creationData);
        String sqlNotebookId = recipe.getParamsAs(SQLQueryRecipeMeta.SQLQueryRecipeParams.class).sqlNotebookId;
        if (StringUtils.isNotBlank((String)sqlNotebookId)) {
            logger.infoV("SQL query recipe '%s' is linked to SQL notebook '%s', saving the recipe id in the notebook", new Object[]{recipe.name, sqlNotebookId});
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
                this.sqlNotebookService.associateNotebookToRecipe(recipe.projectKey, sqlNotebookId, creationResult.id);
                t.commitV("Saved recipe id '%s' in notebook '%s'", new Object[]{creationResult.id, sqlNotebookId});
            }
        }
        return creationResult;
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        try {
            String prefill;
            String string = prefill = data.has("script") ? data.get("script").getAsString() : null;
            if (StringUtils.isNotBlank((String)prefill)) {
                return prefill;
            }
            List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
            if (inputs.isEmpty()) {
                logger.debug((Object)"No inputs to this SQL Query recipe, leaving the initial query blank");
                return null;
            }
            String firstInputRef = inputs.get((int)0).ref;
            SerializedDataset inputSD = (SerializedDataset)this.datasetsDAO.getMandatory(AnyLoc.resolveSmart(recipe.projectKey, firstInputRef));
            SerializedDataset outputSD = (SerializedDataset)this.datasetsDAO.getMandatory(AnyLoc.resolveSmart(recipe.projectKey, recipe.getOutputsForRole((String)"main").get((int)0).ref));
            Dataset outputDS = Dataset.fromSerialized(outputSD);
            Dataset inputDS = Dataset.fromSerialized(inputSD);
            PartitioningScheme partitioning = outputDS.getPartitioningSchema();
            String connectionName = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(this.authCtx, inputDS);
            SQLDialect dialect = SQLConnectionProvider.getConnectionDialect(this.authCtx, connectionName);
            SelectQueryBuilder query = new SelectQueryBuilder();
            SerializedProject project = this.projectsDAO.getMandatory(recipe.projectKey);
            SerializedProject.SQLLikeRecipeInitializationMode mode = project.settings.relocationSettings.sqlLikeRecipesInitializationMode;
            AbstractSQLDatasetHandler.AbstractSQLConfig config = inputSD.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            if (config.mode.equals("query")) {
                String virtualName = "${tbl:" + firstInputRef + "}";
                query.from(new QueryAst.TableVariableReference(virtualName, "This variable contains the query dataset " + firstInputRef + " as if it were a standalone table."));
            } else {
                switch (mode) {
                    case DATASET_REFERENCES: {
                        String virtualName = "${tbl:" + firstInputRef + "}";
                        query.from(new QueryAst.TableVariableReference(virtualName, "This variable contains the table name for input dataset " + firstInputRef));
                        break;
                    }
                    case VARIABILIZED_TABLE_REFERENCES: {
                        if (!recipe.projectKey.equals(inputSD.getProjectKey())) {
                            String virtualName = "${tbl:" + firstInputRef + "}";
                            query.from(new QueryAst.TableVariableReference(virtualName, "This variable contains the table name for input dataset " + firstInputRef));
                            break;
                        }
                        SQLUtils.SQLTable sqlTable = DatasetUtils.getUnresolvedTable(inputSD, dialect, true, false);
                        query.from(sqlTable, null);
                        break;
                    }
                    case RESOLVED_TABLE_REFERENCES: {
                        SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTable(inputSD, dialect, true, false);
                        query.from(sqlTable, null);
                        break;
                    }
                }
            }
            SQLQueryRecipeCreator.handlePartitioningInQuery(inputSD, outputDS, partitioning, query, true);
            return query.toSQL(dialect);
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to autofill recipe", t);
            return null;
        }
    }

    public static void handlePartitioningInQuery(SerializedDataset inputSD, Dataset outputDS, PartitioningScheme partitioning, SelectQueryBuilder query, boolean withFilter) {
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        if (partitioning != null && partitioning.getDimensionNames().size() > 0) {
            if (!DatasetInspector.isFSLike(outputDS)) {
                for (String dimensionName : partitioning.getDimensionNames()) {
                    query.select(ef.dstPartitionId(inputSD.getSchema().getColumnOrDefault(dimensionName, Type.STRING), partitioning.getDimension(dimensionName)), dimensionName);
                }
            }
            HashSet partitioningColumns = Sets.newHashSet((Iterable)partitioning.getDimensionNames());
            for (SchemaColumn column : inputSD.getSchema().getColumns()) {
                if (partitioningColumns.contains(column.getName())) continue;
                query.select(ef.col(column.getName()));
            }
            if (withFilter) {
                query.where(ef.expr("${DKU_PARTITION_FILTER_" + inputSD.name + "}"));
            }
        }
    }
}

