/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sql;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeCreator;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeRunner;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SqlQueryRecipePipelineHelper;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.CodeRecipeParams;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.SqlPipelineRecipeParams;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeSchemaComputer;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeStatusComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import javax.annotation.Nullable;

public class SQLQueryRecipeMeta
extends RecipeMeta {
    public static final SQLQueryRecipeMeta META = new SQLQueryRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return SQLQueryRecipeParams.class;
    }

    @Override
    public String getType() {
        return "sql_query";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new SQLQueryRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.EXPENSIVE;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new SQLQueryRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new SQLQueryRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc desc = RecipeDesc.newDescWithNaryDatasets("SQL query", null);
        desc.inputRoles.get((int)0).mustBeSQLAble = true;
        RecipeDesc.IORoleDef out = desc.outputRoles.get(0);
        out.arity = RecipeDesc.IOArity.UNARY;
        String secondaryRoleLabel = ts.translate(lang, "RECIPE.SHAKER.DESC.VELOOP_DATASET", "Parameters dataset", new Object[0]);
        RecipeDesc.IORoleDef secondaryRole = new RecipeDesc.IORoleDef("veloop", secondaryRoleLabel).withEditable(false, false);
        secondaryRole.arity = RecipeDesc.IOArity.NARY;
        secondaryRole.description = ts.translate(lang, "RECIPE.SHAKER.DESC.VELOOP_DATASET.HELP", "This input is added for 'dynamic repeat' recipes.\nEdit the recipe parameters dataset to change it.", new Object[0]);
        desc.inputRoles.add(secondaryRole);
        return desc;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new SQLQueryRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withUserCode();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new SqlQueryRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    public static class SQLQueryRecipeParams
    extends CodeRecipeParams
    implements ParamsWithVariablesExpansionLoopConfig {
        public boolean allowMultipleConnections = false;
        public String mainConnectionDataset;
        public boolean displayExecutionPlan = true;
        public SqlPipelineRecipeParams sqlPipelineParams = new SqlPipelineRecipeParams();
        public VariablesExpansionLoopConfig variablesExpansionLoopConfig = new VariablesExpansionLoopConfig();
        @Nullable
        public String sqlNotebookId;

        @Override
        public VariablesExpansionLoopConfig getVariablesExpansionLoopConfig() {
            return this.variablesExpansionLoopConfig;
        }

        @Override
        public void setVariablesExpansionLoopConfig(VariablesExpansionLoopConfig variablesExpansionLoopConfig) {
            this.variablesExpansionLoopConfig = variablesExpansionLoopConfig;
        }
    }
}

