/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.stream;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.WithFactories;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.utils.SingleCallAsserter;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PartitionMappingStreamer {
    private final AuthCtx authCtx;
    private final Dataset targetDataset;
    private final ColumnFactory cf;
    private final WarningsContext warningsContext;
    private final PartitioningScheme ps;
    private final int maxConcurrentWrites;
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private List<Column> partitionColumns = new ArrayList<Column>();
    private AnyTemporal anyTemporal = new AnyTemporal();
    private Map<String, OutputWriterAndDatasetHandler> writers = new HashMap<String, OutputWriterAndDatasetHandler>();
    private long useCount = 0L;
    private long writerCreationCount = 0L;
    private long writerEvictionCount = 0L;
    private double writerEvictionAgeSum = 0.0;
    private SingleCallAsserter sca = new SingleCallAsserter();
    private static Logger logger = Logger.getLogger((String)"dku.partitioning");

    public PartitionMappingStreamer(AuthCtx authCtx, Dataset targetDataset, ColumnFactory cf, WarningsContext warningsContext) {
        this.authCtx = authCtx;
        this.targetDataset = targetDataset;
        this.cf = cf;
        this.ps = targetDataset.getPartitioningSchema();
        this.warningsContext = warningsContext;
        for (String dimName : this.ps.getDimensionNames()) {
            this.dimensions.add(this.ps.getDimension(dimName));
            this.partitionColumns.add(cf.column(dimName));
        }
        int maxConcurrentWritesInstance = ApplicationConfigurator.getParams().getIntParam("dku.datasets.partitioningRedispatch.maxConcurrentWriters", Integer.valueOf(Integer.MAX_VALUE));
        int maxConcurrentWritesConnection = this.getMaxConcurrentWritesFromConnection(authCtx, targetDataset);
        int maxConcurrentWritesDataset = this.getMaxConcurrentWritesFromDataset(targetDataset);
        this.maxConcurrentWrites = maxConcurrentWritesDataset < Integer.MAX_VALUE ? maxConcurrentWritesDataset : (maxConcurrentWritesConnection < Integer.MAX_VALUE ? maxConcurrentWritesConnection : maxConcurrentWritesInstance);
        if (this.maxConcurrentWrites == Integer.MAX_VALUE || this.maxConcurrentWrites <= 0) {
            logger.info((Object)"Redispatch with no limit on the number of concurrent writers");
        } else {
            logger.warn((Object)("Redispatch with up to " + Integer.toString(this.maxConcurrentWrites) + " concurrent writers. Performance may be degraded if writer concurrency if too low w.r.t. the number of partitions."));
        }
    }

    private int getMaxConcurrentWritesFromConnection(AuthCtx authCtx, Dataset dataset) {
        try {
            DSSConnection connection = ConnectionsDAO.get().getConnectionUnsafeUnexpanded(authCtx, dataset.getParams().getConnection());
            for (AbstractSQLConnection.CustomDatabaseProperty prop : connection.getDkuProperties()) {
                if (!StringUtils.equals((String)prop.name, (String)"dku.connection.partitioningRedispatch.maxConcurrentWriters")) continue;
                return Integer.parseInt(prop.value);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot get connection-level max concurrency for writes", (Throwable)e);
        }
        return Integer.MAX_VALUE;
    }

    private int getMaxConcurrentWritesFromDataset(Dataset dataset) {
        try {
            for (AbstractSQLConnection.CustomDatabaseProperty prop : dataset.getModel().dkuProperties) {
                if (!StringUtils.equals((String)prop.name, (String)"dku.dataset.partitioningRedispatch.maxConcurrentWriters")) continue;
                return Integer.parseInt(prop.value);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot get dataset-level max concurrency for writes", (Throwable)e);
        }
        return Integer.MAX_VALUE;
    }

    public SingleInputRowProcessor getAsProcessor() throws Exception {
        this.sca.call("ToDatasetStreamer::get");
        return new Streamer();
    }

    public ProcessorOutput getAsOutput() throws Exception {
        return new ProcessorOutputToSIP(this.getAsProcessor());
    }

    private Partition getPartitionFromRow(Row r) {
        Partition p = new Partition(this.ps);
        for (int dimIdx = 0; dimIdx < this.dimensions.size(); ++dimIdx) {
            String value = r.get(this.partitionColumns.get(dimIdx));
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            Dimension dim = this.dimensions.get(dimIdx);
            if (dim instanceof TimeDimension && this.anyTemporal.validates(value)) {
                long msSinceEpoch = this.anyTemporal.msSinceEpoch(value);
                p.setDimensionValue(dim.getName(), ((TimeDimension)dim).getValueFromDate(new Date(msSinceEpoch)));
                continue;
            }
            p.setDimensionValue(dim.getName(), dim.getValueFromId(value));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRowSeparateWriters(Partition p, Row r) throws Exception {
        OutputWriterAndDatasetHandler writer = this.writers.get(p.id());
        if (writer == null) {
            DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, this.targetDataset);
            Output od = dh.buildOutput(p, 0, 1, this.warningsContext);
            writer = new OutputWriterAndDatasetHandler(p, od.getWriter(Output.WriteMode.APPEND), dh);
            writer.writer.init(this.cf);
            ++this.writerCreationCount;
            if (this.maxConcurrentWrites > 0 && this.writers.size() >= this.maxConcurrentWrites) {
                ArrayList allWriters = Lists.newArrayList(this.writers.values());
                OutputWriterAndDatasetHandler evicted = allWriters.stream().min(Comparator.comparingLong(w -> w.lastUse)).get();
                logger.debug((Object)("Evict writer for " + evicted.p.id()));
                try {
                    evicted.writer.lastRowEmitted();
                }
                finally {
                    evicted.handler.close();
                }
                this.writers.remove(evicted.p.id());
                ++this.writerEvictionCount;
                this.writerEvictionAgeSum += (double)(this.useCount - evicted.lastUse);
            }
            this.writers.put(p.id(), writer);
        }
        writer.writer.emitRow(r);
        writer.lastUse = this.useCount++;
    }

    private class Streamer
    implements SingleInputRowProcessor,
    WithFactories {
        private Streamer() {
        }

        public void processRow(Row row) throws Exception {
            Partition p = PartitionMappingStreamer.this.getPartitionFromRow(row);
            if (p == null) {
                logger.warn((Object)("Partition not found, dropping row: " + String.valueOf(row)));
            } else {
                PartitionMappingStreamer.this.dispatchRowSeparateWriters(p, row);
            }
        }

        public void postProcess() throws Exception {
            for (OutputWriterAndDatasetHandler wr : PartitionMappingStreamer.this.writers.values()) {
                try {
                    wr.writer.lastRowEmitted();
                }
                finally {
                    wr.handler.close();
                }
            }
            logger.info((Object)("Opened " + PartitionMappingStreamer.this.writerCreationCount + " writers, evicted " + PartitionMappingStreamer.this.writerEvictionCount + " (avg eviction age " + PartitionMappingStreamer.this.writerEvictionAgeSum / (double)PartitionMappingStreamer.this.writerEvictionCount + ")"));
        }

        @Override
        public void setFactories(ColumnFactory cf, RowFactory rf) {
        }

        public void cancel() throws Exception {
            for (OutputWriterAndDatasetHandler wr : PartitionMappingStreamer.this.writers.values()) {
                wr.handler.close();
            }
        }
    }

    private static class OutputWriterAndDatasetHandler {
        final OutputWriter writer;
        final Partition p;
        final DatasetHandler handler;
        long lastUse;

        OutputWriterAndDatasetHandler(Partition p, OutputWriter writer, DatasetHandler handler) {
            this.p = p;
            this.writer = writer;
            this.handler = handler;
        }
    }
}

