/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CloudBlobSupport {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.cloudblob");

    private static void setAvroCompression(Dataset ds, CopyMode mode) {
        AvroFormatConfig config = ds.getFormatParamsAs(AvroFormatConfig.class);
        switch (config.avroCompressionMethod) {
            case NONE: 
            case SNAPPY: {
                mode.avroCompressionMethod = config.avroCompressionMethod;
                break;
            }
            default: {
                throw new CloudBlobToSQLImpossibleException("Compression not supported: " + String.valueOf((Object)config.avroCompressionMethod));
            }
        }
    }

    private static void setOrcCompression(Dataset ds, CopyMode mode) {
        ORCFileFormatConfig config = ds.getFormatParamsAs(ORCFileFormatConfig.class);
        switch (config.compressionMethod) {
            case NONE: 
            case ZLIB: 
            case SNAPPY: {
                mode.orcCompressionMethod = config.compressionMethod;
                break;
            }
            default: {
                throw new CloudBlobToSQLImpossibleException("Compression not supported: " + String.valueOf((Object)config.compressionMethod));
            }
        }
    }

    private static void setParquetCompression(Dataset ds, CopyMode mode) {
        ParquetFormatConfig config = ds.getFormatParamsAs(ParquetFormatConfig.class);
        switch (config.parquetCompressionMethod) {
            case GZIP: 
            case SNAPPY: 
            case UNCOMPRESSED: 
            case ZSTD: {
                mode.parquetCompressionMethod = config.parquetCompressionMethod;
                break;
            }
            default: {
                throw new CloudBlobToSQLImpossibleException("Compression not supported: " + String.valueOf((Object)config.parquetCompressionMethod));
            }
        }
    }

    private static void setCSVCompression(CSVFormatConfig config, CopyMode mode) {
        if (StringUtils.isNotBlank((String)config.compress) && !"gz".equalsIgnoreCase(config.compress)) {
            throw new CloudBlobToSQLImpossibleException("File compression not supported: '" + config.compress + "'");
        }
        mode.csvCompressionMethod = config.compress;
    }

    private static void setCSVQuoting(CSVFormatConfig config, CopyMode mode) {
        switch (config.style) {
            case EXCEL: {
                mode.quote = config.getQuoteChar();
                break;
            }
            case UNIX: {
                mode.quote = config.getQuoteChar();
                break;
            }
        }
        if (mode.quote != '\u0000' && (config.getQuoteChar() == '\u0000' || config.getQuoteChar() > '\u00ff')) {
            throw new CloudBlobToSQLImpossibleException("Input quoting character not supported: '" + config.getQuoteChar() + "'");
        }
    }

    private static void setCSVEscaping(CSVFormatConfig config, CopyMode mode, boolean canEscape) {
        switch (config.style) {
            case UNIX: 
            case ESCAPE_ONLY_NO_QUOTE: {
                if (canEscape) {
                    mode.escape = config.getEscapeChar();
                    break;
                }
                logger.warn((Object)"Escape character is ignored, Azure loader doesn't handle it");
                break;
            }
        }
        if (mode.quote != '\u0000' && (config.getQuoteChar() == '\u0000' || config.getQuoteChar() > '\u00ff')) {
            throw new CloudBlobToSQLImpossibleException("Input quoting character not supported: '" + config.getQuoteChar() + "'");
        }
    }

    static CopyMode getOrcToDatabricks(Dataset ds) {
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.ORC;
        CloudBlobSupport.setOrcCompression(ds, mode);
        return mode;
    }

    static CopyMode getOrcToSynapse(Dataset ds) {
        if (ds.getSchema().columns.stream().map(SchemaColumn::getType).anyMatch(t -> !t.isPrimitive() || t.isGeo())) {
            throw new CloudBlobToSQLImpossibleException("Cannot load ORC data containing non-primitive types");
        }
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.ORC;
        CloudBlobSupport.setOrcCompression(ds, mode);
        return mode;
    }

    static CopyMode getAvroToDatabricks(Dataset ds) {
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.AVRO;
        CloudBlobSupport.setAvroCompression(ds, mode);
        return mode;
    }

    static CopyMode getParquetToDatabricks(Dataset ds) {
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.PARQUET;
        CloudBlobSupport.setParquetCompression(ds, mode);
        return mode;
    }

    static CopyMode getParquetToSynapse(Dataset ds) {
        if (ds.getSchema().columns.stream().map(SchemaColumn::getType).anyMatch(t -> !t.isPrimitive() || t.isGeo())) {
            throw new CloudBlobToSQLImpossibleException("Cannot load Parquet data containing non-primitive types");
        }
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.PARQUET;
        CloudBlobSupport.setParquetCompression(ds, mode);
        return mode;
    }

    static CopyMode getCsvToDatabricks(Dataset ds, boolean databricksToCloud) {
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.CSV;
        CSVFormatConfig config = ds.getFormatParamsAs(CSVFormatConfig.class);
        mode.delimiter = config.getSeparatorChar();
        if (mode.delimiter == '\u0000' || mode.delimiter > '\u007f') {
            throw new CloudBlobToSQLImpossibleException("Input separator not supported: '" + config.getSeparatorStr() + "'");
        }
        if (!Sets.newHashSet((Object[])new String[]{"utf8", "utf-8"}).contains(StringUtils.defaultIfBlank((String)config.charset, (String)"utf8").toLowerCase())) {
            throw new CloudBlobToSQLImpossibleException("Charset not supported: '" + config.charset + "'");
        }
        CloudBlobSupport.setCSVQuoting(config, mode);
        if (config.style == CSVFormatConfig.CSVStyle.EXCEL) {
            mode.escape = mode.quote;
        } else {
            CloudBlobSupport.setCSVEscaping(config, mode, true);
        }
        CloudBlobSupport.setCSVCompression(config, mode);
        mode.multiline = true;
        mode.writeHeader = databricksToCloud && config.parseHeaderRow;
        mode.ignoreHeader = config.skipRowsAfterHeader + config.skipRowsBeforeHeader;
        if (config.parseHeaderRow) {
            ++mode.ignoreHeader;
        }
        return mode;
    }

    static CopyMode getCsvToSynapse(Dataset inputDS, Dataset outputDS) {
        CopyMode mode = new CopyMode();
        mode.type = CopyModeType.CSV;
        CSVFormatConfig config = inputDS.getFormatParamsAs(CSVFormatConfig.class);
        mode.delimiter = config.getSeparatorChar();
        if (mode.delimiter == '\u0000' || mode.delimiter > '\u007f') {
            throw new CloudBlobToSQLImpossibleException("Input separator not supported: '" + config.getSeparatorStr() + "'");
        }
        if (!Sets.newHashSet((Object[])new String[]{"utf8", "utf-8"}).contains(StringUtils.defaultIfBlank((String)config.charset, (String)"utf8").toLowerCase())) {
            throw new CloudBlobToSQLImpossibleException("Charset not supported: '" + config.charset + "'");
        }
        CloudBlobSupport.setCSVQuoting(config, mode);
        CloudBlobSupport.setCSVEscaping(config, mode, false);
        CloudBlobSupport.setCSVCompression(config, mode);
        mode.ignoreHeader = config.skipRowsAfterHeader + config.skipRowsBeforeHeader;
        if (config.parseHeaderRow) {
            ++mode.ignoreHeader;
        }
        mode.useQuoting = ApplicationConfigurator.getParams().getBoolParam("dku.azure_to_synapse.use.quoting", true);
        mode.useQuoting = outputDS.getDkuPropertiesAsParams().getBoolParam("azure_to_synapse.use.quoting", mode.useQuoting);
        return mode;
    }

    public static LocationToLoad getAzureBlobStorageLocation(String hdfsUrl) {
        Pattern pattern = Pattern.compile("^([a-z]+)://([^@]+)@([^\\.]+)\\.([^/]+)/(.*)$");
        Matcher matcher = pattern.matcher(hdfsUrl);
        if (matcher.find()) {
            LocationToLoad ret = new LocationToLoad();
            ret.scheme = matcher.group(1);
            ret.container = matcher.group(2);
            ret.storageAccount = matcher.group(3);
            ret.location = matcher.group(4);
            ret.pathInContainer = matcher.group(5);
            if (StringUtils.isBlank((String)ret.pathInContainer)) {
                throw new IllegalArgumentException("Invalid file path: " + hdfsUrl);
            }
            return ret;
        }
        throw new IllegalArgumentException("Incorrect file path : " + hdfsUrl);
    }

    protected static class CopyMode {
        CopyModeType type;
        ParquetFormatConfig.CompressionMethod parquetCompressionMethod;
        ORCFileFormatConfig.CompressionMethod orcCompressionMethod;
        AvroFormatConfig.AvroCompressionMethod avroCompressionMethod;
        char delimiter;
        char quote;
        char escape;
        String csvCompressionMethod;
        boolean multiline;
        int ignoreHeader;
        boolean useQuoting;
        boolean writeHeader;

        protected CopyMode() {
        }

        public static CopyMode csv(char delimiter, char quote, String compression, int ignoreHeader, boolean useQuoting) {
            CopyMode ret = new CopyMode();
            ret.type = CopyModeType.CSV;
            ret.delimiter = delimiter;
            ret.quote = quote;
            ret.useQuoting = useQuoting;
            ret.ignoreHeader = ignoreHeader;
            ret.csvCompressionMethod = compression;
            return ret;
        }

        public static CopyMode parquet(ParquetFormatConfig.CompressionMethod compression) {
            CopyMode ret = new CopyMode();
            ret.type = CopyModeType.PARQUET;
            ret.parquetCompressionMethod = compression;
            return ret;
        }

        public static CopyMode orc(ORCFileFormatConfig.CompressionMethod compression) {
            CopyMode ret = new CopyMode();
            ret.type = CopyModeType.ORC;
            ret.orcCompressionMethod = compression;
            return ret;
        }
    }

    public static class CloudBlobToSQLImpossibleException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        CloudBlobToSQLImpossibleException(String message) {
            super(message);
        }
    }

    protected static enum CopyModeType {
        CSV,
        PARQUET,
        ORC,
        AVRO;

    }

    public static class LocationToLoad {
        public String scheme;
        public String container;
        public String storageAccount;
        public String location;
        public String pathInContainer;

        public static LocationToLoad from(String scheme, String container, String storageAccount, String location, String pathInContainer) {
            LocationToLoad ret = new LocationToLoad();
            ret.scheme = scheme;
            ret.container = container;
            ret.storageAccount = storageAccount;
            ret.location = location;
            ret.pathInContainer = pathInContainer;
            return ret;
        }

        public int hashCode() {
            return Objects.hash(this.scheme, this.container, this.storageAccount, this.location, this.pathInContainer);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocationToLoad other = (LocationToLoad)obj;
            return StringUtils.equals((String)this.scheme, (String)other.scheme) && StringUtils.equals((String)this.container, (String)other.container) && StringUtils.equals((String)this.storageAccount, (String)other.storageAccount) && StringUtils.equals((String)this.location, (String)other.location) && StringUtils.equals((String)this.pathInContainer, (String)other.pathInContainer);
        }
    }
}

