/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FSSubgraphHelper;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.dataflow.exec.sync.RedshiftToS3;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AmazonS3OutputStream;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class S3ToRedshift
extends SISORecipeExecutor
implements AutoFastPathConnector {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.s3toredshift");

    private static CopyMode getCopyMode(Dataset inputDS) {
        CopyMode mode = new CopyMode();
        switch (inputDS.getFormatType()) {
            case "csv": {
                mode.setInputCSVCopyMode(inputDS.getFormatParamsAs(CSVFormatConfig.class));
                break;
            }
            case "parquet": {
                mode.setParquetCopyMode(inputDS);
                break;
            }
            case "orcfile": {
                mode.setOrcCopyMode();
                break;
            }
            default: {
                throw new S3ToRedshiftImpossibleException("input format not supported: " + inputDS.getFormatType());
            }
        }
        return mode;
    }

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "S3")) {
            status.markAsNonSelectable("Input dataset is not in S3", RecipeEngineStatus.WarningLevel.ERROR);
        } else if (outputMeta != BuiltinSQLDatasets.REDSHIFT_META) {
            status.markAsNonSelectable("Output dataset is not in Redshift", RecipeEngineStatus.WarningLevel.ERROR);
        } else {
            try {
                S3ToRedshift.getCopyMode(inputDS);
            }
            catch (S3ToRedshiftImpossibleException e) {
                status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (this.writeMode == Output.WriteMode.APPEND) {
            throw new IllegalArgumentException("Unsupported Append mode");
        }
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             S3DatasetHandler s3dh = (S3DatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            String jobId;
            String manifestProjectKey;
            FilePartitioner.ResolvedFilesFilterResult filterResult = FSSubgraphHelper.getInputFiles(this.inputPartitions, s3dh);
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            SQLUtils.SQLTable table = vti.getResolvedTable();
            EC2Connection ec2 = s3dh.getConnection();
            String s3Credentials = ec2.getS3CredentialsForRedshift(this.outputDS, this.authCtx, this.symetricCryptoService);
            String displayableS3Credentials = RedshiftToS3.getDisplayableS3Credentials(s3Credentials);
            String defaultManagedBucket = ec2.params.getDefaultManagedBucket();
            if (StringUtils.isBlank((String)defaultManagedBucket)) {
                throw ErrorContext.iaef((String)"Can't create temporary Redshift manifest file on connection '%s' missing 'defaultManagedBucket' param", (Object)ec2.name, (Object[])new Object[0]);
            }
            String defaultManagedPath = ec2.params.getDefaultManagedPath();
            if (StringUtils.isBlank((String)defaultManagedPath)) {
                throw ErrorContext.iaef((String)"Can't create temporary Redshift manifest file on connection '%s' missing 'defaultManagedPath' param", (Object)ec2.name, (Object[])new Object[0]);
            }
            S3Client s3Client = ec2.getS3Client(this.authCtx);
            String manifestFilePathSuffix = this.activity == null ? SecretKeyGenerator.generate() : this.activity.id();
            JobContext jta = JobContext.getCurrentJobContext();
            if (jta != null) {
                manifestProjectKey = jta.projectKey;
                jobId = jta.jobId;
            } else {
                manifestProjectKey = this.contextProjectKey;
                jobId = SecretKeyGenerator.generate((int)8);
            }
            String manifestFilePath = PathUtils.slashes((String)(defaultManagedPath + "/_tmp.redshift/"), (Boolean)false, (Boolean)true, (boolean)true, null) + manifestProjectKey + "/" + jobId + "/" + manifestFilePathSuffix + ".json";
            String manifestFileAddress = "s3://" + defaultManagedBucket + "/" + manifestFilePath;
            CopyMode copyMode = S3ToRedshift.getCopyMode(this.inputDS);
            logger.infoV("Saving Redshift copy manifest to bucket=%s path=%s", new Object[]{defaultManagedBucket, manifestFilePath});
            Manifest manifest = new Manifest(s3dh, filterResult.getAllPaths(), copyMode.type);
            if (copyMode.type != CopyMode.CopyModeType.CSV) {
                manifest.setComputeLength(s3Client, defaultManagedBucket, s3dh.getRootWithinBucket());
            }
            manifest.save(ec2, s3Client, defaultManagedBucket, manifestFilePath);
            RedshiftSQLDialect dialect = (RedshiftSQLDialect)connData.getDialect();
            String tableWithSchema = dialect.getQuotedTableFullName(table);
            boolean hasParquetSmallIntColumn = copyMode.type == CopyMode.CopyModeType.PARQUET && this.inputDS.getSchema().columns.stream().filter(sc -> sc.getType() == Type.TINYINT || sc.getType() == Type.SMALLINT).findAny().isPresent();
            try (SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();
                 Statement stmt = conn.createStatement();){
                logger.info((Object)("Deleting Redshift output partition : " + this.outputPartition.id()));
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                dialect.dropAndRecreateTableOrPartition(this.authCtx, connData, conn, this.outputDS, this.outputPartition, false, messages);
                if (!messages.isEmpty()) {
                    this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
                SQLUtils.executePreWriteStatements(connData, conn, this.outputDS);
                if (hasParquetSmallIntColumn || this.outputPartition != null && !this.outputPartition.isAll() && !this.outputPartition.isNP() && this.outputDS.getPartitioningSchema().isPartitioned()) {
                    String tempTableName = "tmp_" + table.getTable();
                    String tempTableFullName = dialect.getQuotedTableFullName("", "", tempTableName);
                    Schema temporaryTableSchema = FastpathUtils.getTemporaryTableSchemaForDBSync(this.inputDS, this.outputDS);
                    String createTempTableStatement = dialect.generateTempTableStatementSQL(tempTableName, this.outputDS, temporaryTableSchema);
                    logger.info((Object)("Creating temp table :" + createTempTableStatement));
                    stmt.execute(createTempTableStatement);
                    String copyStatement = String.format("COPY %s FROM '%s' %s MANIFEST", tempTableFullName, manifestFileAddress, s3Credentials) + (manifest.isGZIP() ? " GZIP" : "") + copyMode.redshiftOptions(false);
                    String displayableCopyStatement = String.format("COPY %s FROM '%s' %s MANIFEST", tempTableFullName, manifestFileAddress, displayableS3Credentials) + (manifest.isGZIP() ? " GZIP" : "") + copyMode.redshiftOptions(false);
                    logger.info((Object)("Inserting into temp table: " + displayableCopyStatement));
                    SQLUtils.execute(conn, stmt, copyStatement, displayableCopyStatement, true, false);
                    conn.commit();
                    String insertFromTempTableStatement = String.format("INSERT INTO %s SELECT %s FROM %s", tableWithSchema, this.getSelectColumnNames(), tempTableFullName);
                    logger.info((Object)("Inserting from temp table: " + insertFromTempTableStatement));
                    SQLUtils.execute(conn, stmt, insertFromTempTableStatement, true);
                } else {
                    String copyStatement = String.format("COPY %s FROM '%s' %s MANIFEST", tableWithSchema, manifestFileAddress, s3Credentials) + (manifest.isGZIP() ? " GZIP" : "") + copyMode.redshiftOptions(false);
                    String displayableCopyStatement = String.format("COPY %s FROM '%s' %s MANIFEST", tableWithSchema, manifestFileAddress, displayableS3Credentials) + (manifest.isGZIP() ? " GZIP" : "") + copyMode.redshiftOptions(false);
                    SQLUtils.execute(conn, stmt, copyStatement, displayableCopyStatement, true, true);
                }
                logger.info((Object)"Committing Redshift transaction");
                SQLUtils.executePostWriteStatements(connData, conn, this.outputDS);
                conn.commit();
            }
        }
    }

    private String getSelectColumnNames() {
        List inputColumnNames = this.inputDS.getSchema().columns;
        ArrayList<CallSite> selectColumnNamesL = new ArrayList<CallSite>();
        for (SchemaColumn col : this.outputDS.getSchema().columns) {
            if (this.outputPartition != null && this.outputPartition.getDimensionValues().containsKey(col.getName())) {
                if (col.getType().isTemporal()) {
                    String dateValue = ExpressionUtils.getStringForDimensionValue((DimensionValue)this.outputPartition.getDimensionValues().get(col.getName()), col.getType());
                    String sqlType = col.getType() == Type.DATEONLY ? "DATE" : (col.getType() == Type.DATETIMENOTZ ? "TIMESTAMP" : "TIMESTAMPTZ");
                    selectColumnNamesL.add((CallSite)((Object)("'" + dateValue + "'::" + sqlType + " as \"" + col.getName() + "\"")));
                    continue;
                }
                selectColumnNamesL.add((CallSite)((Object)("'" + FastpathUtils.getPartitionValue(col.getName(), this.outputPartition) + "' as \"" + col.getName() + "\"")));
                continue;
            }
            if (FastpathUtils.containsColumn(inputColumnNames, col.getName())) {
                selectColumnNamesL.add((CallSite)((Object)("\"" + col.getName() + "\"")));
                continue;
            }
            throw new IllegalStateException("Missing column: " + col.getName() + " in input dataset");
        }
        return Joiner.on((String)",").join(selectColumnNamesL);
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void initForAutoFastPath(AuthCtx authCtx, WarningsContext warnContext, Dataset cloudDataset, Partition cloudPartition, Dataset redshiftDataset, Output.WriteMode writeMode) throws Exception {
        this.outputDS = redshiftDataset;
        this.inputDS = cloudDataset;
        this.contextProjectKey = redshiftDataset.getProjectKey();
        this.inputPartitions = Lists.newArrayList((Object[])new Partition[]{cloudPartition});
        this.outputPartition = cloudPartition;
        this.writeMode = writeMode;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.clearOutputPartitionsIfNeeded();
    }

    public static class CopyMode {
        CopyModeType type;
        char delimiter;
        boolean csv;
        char quote;
        boolean escape;
        String compress;
        int ignoreHeader;

        static String quoteChar(char c2) {
            if (c2 == '\t') {
                return "\\t";
            }
            if (c2 >= ' ' && c2 < '\u007f' && c2 != '\'') {
                return Character.toString(c2);
            }
            return String.format("\\%03o", c2);
        }

        public void setOutputCSVCopyMode(CSVFormatConfig config) {
            if (config == null || config.style == null) {
                throw new RedshiftToS3.RedshiftToS3Exception("output format not defined");
            }
            this.type = CopyModeType.CSV;
            this.compress = config.compress;
            if (!com.dataiku.dip.utils.StringUtils.isUtf8((String)config.charset)) {
                throw new RedshiftToS3.RedshiftToS3Exception("output charset not supported: " + config.charset);
            }
            if (StringUtils.isEmpty((String)config.getSeparatorStr())) {
                throw new RedshiftToS3.RedshiftToS3Exception("missing output separator");
            }
            if (config.getSeparatorChar() == '\u0000' || config.getSeparatorChar() > '\u00ff') {
                throw new RedshiftToS3.RedshiftToS3Exception("output separator not supported: '" + config.getSeparatorStr() + "'");
            }
            this.delimiter = config.getSeparatorChar();
            switch (config.style) {
                case EXCEL: {
                    if (config.getQuoteChar() == '\u0000' || config.getQuoteChar() > '\u00ff') {
                        throw new RedshiftToS3.RedshiftToS3Exception("output quoting character not supported: '" + config.getQuoteChar() + "'");
                    }
                    this.csv = true;
                    this.quote = config.getQuoteChar();
                    break;
                }
                case UNIX: {
                    if (config.getEscapeChar() != '\\') {
                        throw new RedshiftToS3.RedshiftToS3Exception("output escape character not supported: '" + config.getQuoteChar() + "'");
                    }
                    this.csv = true;
                    this.escape = true;
                    this.quote = config.getQuoteChar();
                    break;
                }
                case ESCAPE_ONLY_NO_QUOTE: {
                    if (config.getEscapeChar() != '\\') {
                        throw new RedshiftToS3.RedshiftToS3Exception("output escape character not supported: '" + config.getQuoteChar() + "'");
                    }
                    this.escape = true;
                    break;
                }
            }
            this.ignoreHeader = config.skipRowsAfterHeader + config.skipRowsBeforeHeader;
            if (config.parseHeaderRow) {
                ++this.ignoreHeader;
            }
        }

        public void setInputCSVCopyMode(CSVFormatConfig config) {
            if (!com.dataiku.dip.utils.StringUtils.isUtf8((String)config.charset)) {
                throw new S3ToRedshiftImpossibleException("input charset not supported: " + config.charset);
            }
            if (config.getSeparatorChar() == '\u0000' || config.getSeparatorChar() > '\u00ff') {
                throw new S3ToRedshiftImpossibleException("input separator not supported: '" + config.getSeparatorStr() + "'");
            }
            this.delimiter = config.getSeparatorChar();
            this.type = CopyModeType.CSV;
            switch (config.style) {
                case EXCEL: {
                    if (config.getQuoteChar() == '\u0000' || config.getQuoteChar() > '\u00ff') {
                        throw new S3ToRedshiftImpossibleException("input quoting character not supported: '" + config.getQuoteChar() + "'");
                    }
                    this.csv = true;
                    this.quote = config.getQuoteChar();
                    break;
                }
                case UNIX: {
                    throw new S3ToRedshiftImpossibleException("Unix quoting style not supported");
                }
                case ESCAPE_ONLY_NO_QUOTE: {
                    if (config.getEscapeChar() != '\\') {
                        throw new S3ToRedshiftImpossibleException("input escape character not supported: '" + config.getQuoteChar() + "'");
                    }
                    this.escape = true;
                    break;
                }
            }
            this.ignoreHeader = config.skipRowsAfterHeader + config.skipRowsBeforeHeader;
            if (config.parseHeaderRow) {
                ++this.ignoreHeader;
            }
        }

        public void setOrcCopyMode() {
            this.type = CopyModeType.ORC;
        }

        public void setParquetCopyMode(Dataset ds) {
            this.type = CopyModeType.PARQUET;
            ParquetFormatConfig config = ds.getFormatParamsAs(ParquetFormatConfig.class);
            switch (config.parquetCompressionMethod) {
                case UNCOMPRESSED: 
                case SNAPPY: 
                case ZSTD: 
                case LZO: 
                case GZIP: {
                    break;
                }
                default: {
                    throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException(String.format("Unsupported compression type %s for parquet files", new Object[]{config.parquetCompressionMethod}));
                }
            }
        }

        private void outputAsCSV(StringBuilder opt) {
            if (this.delimiter != '\u0000') {
                opt.append(" DELIMITER AS '").append(CopyMode.quoteChar(this.delimiter)).append("'");
            }
            if (this.quote != '\u0000') {
                opt.append(" ADDQUOTES");
            }
            if (this.escape) {
                opt.append(" ESCAPE");
            }
            if (this.compress.contains("gz")) {
                opt.append(" GZIP");
            }
        }

        private void inputAsCSV(StringBuilder opt) {
            if (this.delimiter != '\u0000') {
                opt.append(" DELIMITER '").append(CopyMode.quoteChar(this.delimiter)).append("'");
            }
            if (this.csv) {
                opt.append(" CSV");
            }
            if (this.quote != '\u0000') {
                opt.append(" QUOTE '").append(CopyMode.quoteChar(this.quote)).append("'");
            }
            if (this.escape) {
                opt.append(" ESCAPE");
            }
            if (this.ignoreHeader != 0) {
                opt.append(" IGNOREHEADER ").append(this.ignoreHeader);
            }
            opt.append(" EMPTYASNULL DATEFORMAT 'auto' TIMEFORMAT 'auto'");
        }

        public String redshiftOptions(boolean asOutput) {
            StringBuilder opt = new StringBuilder();
            if (CopyModeType.CSV.equals((Object)this.type)) {
                if (asOutput) {
                    this.outputAsCSV(opt);
                } else {
                    this.inputAsCSV(opt);
                }
            } else if (CopyModeType.PARQUET.equals((Object)this.type)) {
                opt.append(" PARQUET");
            } else if (CopyModeType.ORC.equals((Object)this.type)) {
                opt.append(" ORC");
            } else {
                throw new UnsupportedOperationException("Unsupported copy mode for Snowflake: " + String.valueOf((Object)this.type));
            }
            return opt.toString();
        }

        static enum CopyModeType {
            CSV,
            PARQUET,
            ORC;

        }
    }

    public static class S3ToRedshiftImpossibleException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        S3ToRedshiftImpossibleException(String message) {
            super(message);
        }
    }

    static class Manifest {
        List<Entry> entries = new ArrayList<Entry>();
        transient CopyMode.CopyModeType mode;

        Manifest(S3DatasetHandler s3dh, List<FSPath> paths, CopyMode.CopyModeType mode) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            this.mode = mode;
            if (s3dh.isSingleFile()) {
                this.entries.add(new Entry(s3dh.getInformationalRootPath(), paths.get(0).path()));
            } else {
                String address = s3dh.getInformationalRootPath();
                if (address.endsWith("/")) {
                    address = address.substring(0, address.length() - 1);
                }
                for (FSPath p : paths) {
                    this.entries.add(new Entry(address + p.path(), p.path()));
                }
            }
        }

        void setComputeLength(S3Client s3, String bucket, String path) {
            for (Entry e : this.entries) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(path + e.path).build();
                e.meta = new Meta(s3.headObject(headObjectRequest).contentLength());
            }
        }

        void save(EC2Connection conn, S3Client s3, String bucket, String path) throws IOException {
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new AmazonS3OutputStream(s3, bucket, path, conn.params.encryptionMode.sseAlgorithm, conn.params.encryptionKeyId), StandardCharsets.UTF_8);){
                w.write(JSON.pretty((Object)this));
            }
        }

        boolean isGZIP() {
            if (this.entries.isEmpty() || this.mode != CopyMode.CopyModeType.CSV) {
                return false;
            }
            boolean gzip = this.entries.get((int)0).url.toLowerCase(Locale.ENGLISH).endsWith(".gz");
            for (Entry e : this.entries) {
                if (e.url.toLowerCase(Locale.ENGLISH).endsWith(".gz") == gzip) continue;
                throw new Error("unsupported operation : dataset contains compressed and non compressed files");
            }
            return gzip;
        }

        static class Entry {
            transient String path;
            String url;
            Meta meta;

            Entry(String url, String path) {
                this.url = url;
                this.path = path;
            }
        }

        static class Meta {
            final long content_length;

            public Meta(long contentLength) {
                this.content_length = contentLength;
            }
        }
    }
}

