/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.NotImplementedException;

public class FlowImplicitRecipe
extends FlowRunnable {
    private final String datasetType;
    private final String projectKey;
    public String roleName;

    public FlowImplicitRecipe(String datasetType, FlowComputable successor, FlowComputable predecessor, String role) {
        this.datasetType = datasetType;
        this.projectKey = DatasetLocUtils.resolveFull(successor.getFullId()).getProjectKey();
        this.addSuccessor(successor, role);
        this.addPredecessor(predecessor, role);
    }

    @Override
    public String getFullId() {
        return this.datasetType + "->" + this.getSuccessor().getFullId();
    }

    @Override
    public String getGraphId() {
        throw new NotImplementedException();
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    public FlowComputable getPredecessor() {
        GraphNode p = this.getPredecessors().get(0);
        assert (p instanceof FlowComputable);
        return (FlowComputable)p;
    }

    public FlowComputable getSuccessor() {
        GraphNode s = this.getSuccessors().get(0);
        assert (s instanceof FlowComputable);
        return (FlowComputable)s;
    }

    @Override
    public String getName() {
        return this.datasetType + this.getSuccessor().getFullId();
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getType() {
        throw new NotImplementedException();
    }

    public String getDatasetType() {
        return this.datasetType;
    }
}

