/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ColumnUsageView
extends AbstractFlowTool.FlowView {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private final ColumnUsageViewState state;
    private ColumnUsageOptions options = new ColumnUsageOptions();

    public ColumnUsageView(AuthCtx authCtx, String projectKey) {
        super(authCtx, projectKey);
        this.state = new ColumnUsageViewState();
    }

    @Override
    public synchronized AbstractFlowTool.FlowState getFlowState(JsonObject jsonOptions) throws Exception {
        this.options = (ColumnUsageOptions)JSON.parse((JsonElement)jsonOptions, ColumnUsageOptions.class);
        if (this.options != null && !this.options.caseSensitive && this.options.columnNames != null) {
            this.options.columnNames = this.options.columnNames.stream().map(name -> name.toLowerCase()).collect(Collectors.toList());
        }
        Collection<String> currentFocus = this.state.focused;
        this.computeState();
        this.state.focused = currentFocus;
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        this.state.focused = focused == null ? new HashSet() : focused;
    }

    @Override
    public synchronized ColumnUsageViewState computeState() throws Exception {
        HashSet serializedDatasets;
        if (this.options.columnNames == null) {
            return this.state;
        }
        try (Transaction t = this.transactionService.beginRead();){
            serializedDatasets = new HashSet(this.datasetsDAO.listUnsafe(this.projectKey));
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedDatasets(this.projectKey)) {
                serializedDatasets.add((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(datasetLoc));
            }
        }
        this.state.lastColumnDoesntExist = true;
        for (SerializedDataset sd : serializedDatasets) {
            FutureProgressState.checkInterrupt();
            Set set = sd.getSchema().columns.stream().map(SchemaColumn::getName).filter(c2 -> this.options.columnNames.contains(this.options.caseSensitive ? c2 : c2.toLowerCase())).collect(Collectors.toSet());
            if (set.isEmpty()) continue;
            this.state.lastColumnDoesntExist = false;
            String datasetId = GraphIds.forDataset(sd.projectKey, sd.name);
            if (this.state.valueByNode.containsKey(datasetId)) {
                this.state.valueByNode.get(datasetId).addAll(set);
                continue;
            }
            this.state.valueByNode.put(datasetId, set);
        }
        return this.state;
    }

    public static class ColumnUsageOptions {
        public List<String> columnNames;
        public boolean caseSensitive = false;
    }

    private static class ColumnUsageViewState
    implements AbstractFlowTool.FlowState {
        public Map<String, Set<String>> valueByNode = new HashMap<String, Set<String>>();
        public Collection<String> focused = new HashSet<String>();
        boolean lastColumnDoesntExist;

        private ColumnUsageViewState() {
        }
    }
}

