/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class InterestsView
extends AbstractFlowTool.FlowView {
    @Autowired
    private InterestsService interestsService;
    private InterestsViewState state;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.interests");

    public InterestsView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized InterestsViewState computeState() throws Exception {
        this.state = new InterestsViewState();
        Map<TaggableObjectsService.TaggableObjectRef, WatchStarDesc> watched = this.getWatchedItems();
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, WatchStarDesc> e : watched.entrySet()) {
            FutureProgressState.checkInterrupt();
            TaggableObjectsService.TaggableObjectRef ref = e.getKey();
            String nodeId = GraphIds.forRef(ref);
            this.state.valueByNode.put(nodeId, e.getValue());
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private Map<TaggableObjectsService.TaggableObjectRef, WatchStarDesc> getWatchedItems() {
        HashMap<TaggableObjectsService.TaggableObjectRef, WatchStarDesc> items = new HashMap<TaggableObjectsService.TaggableObjectRef, WatchStarDesc>();
        TaggableObjectsService.TaggableObjectFilter filter = new TaggableObjectsService.TaggableObjectFilter();
        filter.projectKey = this.projectKey;
        InterestsService.InterestsResponse interests = this.interestsService.getUserInterests_NT(this.authCtx.getAssociatedDSSUser(), 0, filter, 10000, false);
        for (InterestsInternalDB.TaggableObjectRefWithInterest interest : interests.interests) {
            WatchStarDesc ws = new WatchStarDesc();
            ws.w = interest.watching.enabled();
            ws.s = interest.starred;
            if (!ws.w && !ws.s || interest.objectType == null || !interest.objectType.isFlowItem()) continue;
            TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(this.projectKey, interest.objectType, interest.objectId);
            items.put(ref, ws);
        }
        return items;
    }

    public class InterestsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, WatchStarDesc> valueByNode = new HashMap<String, WatchStarDesc>();
        public Collection<String> focused = new HashSet<String>();
    }

    public class WatchStarDesc {
        boolean w;
        boolean s;
    }
}

