/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.slave;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.jobrunner.JobRunner;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.master.locking.PermitStatus;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.intercom.t.JobsIntercomController;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.HttpRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.google.gson.JsonObject;
import java.io.IOException;

public class JobKernelAPIClient
extends InternalAPIClient {
    private final APITicketService apiTicketService;

    public JobKernelAPIClient(APITicketService apiTicketService) {
        super("http://127.0.0.1:" + Integer.parseInt(System.getenv("DKU_BACKEND_PORT")), null, false);
        this.apiTicketService = apiTicketService;
    }

    private void addHeader(HttpRequest req) throws Exception {
        req.setHeader("X-DKU-APITicket", this.apiTicketService.getSingleTicket().getSecret());
    }

    protected HttpGet newGet(String path) throws Exception {
        HttpGet get = new HttpGet(this.baseURI + "/" + path);
        this.addHeader((HttpRequest)get);
        this.setAdditionalHeadersInRequest((HttpRequestBase)get);
        return get;
    }

    protected HttpPost newPost(String path) throws Exception {
        HttpPost post = new HttpPost(this.baseURI + "/" + path);
        this.addHeader((HttpRequest)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    protected HttpPut newPut(String path) throws Exception {
        HttpPut post = new HttpPut(this.baseURI + "/" + path);
        this.addHeader((HttpRequest)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    protected HttpDelete newDelete(String path) throws Exception {
        HttpDelete post = new HttpDelete(this.baseURI + "/" + path);
        this.addHeader((HttpRequest)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    public String askBuildPermit(Job job, SerializedJobActivity activity) throws IOException {
        return (String)this.postFormToJSON("/dip/api/tintercom/jobs/ask-build-permit", String.class, new Object[]{"jobProjectKey", job.def.projectKey, "jobId", job.def.id, "activity", JSON.json((Object)activity)});
    }

    public PermitStatus waitBuildPermit(Job job, SerializedJobActivity activity, String permitIdentifier, long timeoutMs) throws IOException {
        return (PermitStatus)this.postFormToJSON("/dip/api/tintercom/jobs/wait-build-permit", PermitStatus.class, new Object[]{"jobProjectKey", job.def.projectKey, "jobId", job.def.id, "permitIdentifier", permitIdentifier, "timeoutMs", timeoutMs});
    }

    public void releaseBuildPermit(Job job, String permitId) throws IOException {
        this.postFormToJSON("/dip/api/tintercom/jobs/release-build-permit", Void.class, new Object[]{"jobProjectKey", job.def.projectKey, "jobId", job.def.id, "permitIdentifier", permitId});
    }

    public void onActivityStarted(JobDef jobDef, SerializedJobActivityStatus activity) throws APIError.APIErrorException, IOException {
        this.postFormToJSON("/dip/api/tintercom/jobs/activity-started", Void.class, new Object[]{"jobDef", JSON.json((Object)jobDef), "activity", JSON.json((Object)activity)});
    }

    public void onActivityDone(JobDef jobDef, SerializedJobActivityStatus activity, JobRunner.ActivityDoneContext adsc) throws APIError.APIErrorException, IOException {
        this.postFormToJSON("/dip/api/tintercom/jobs/activity-done", Void.class, new Object[]{"jobDef", JSON.json((Object)jobDef), "activity", JSON.json((Object)activity), "scenarioCtx", JSON.json((Object)adsc)});
    }

    public JobsIntercomController.ActivityChecksResults runChecksForActivity(JobDef jobDef, SerializedJobActivityStatus activity) throws APIError.APIErrorException, IOException {
        return (JobsIntercomController.ActivityChecksResults)this.postFormToJSON("/dip/api/tintercom/jobs/run-checks-for-activity", JobsIntercomController.ActivityChecksResults.class, new Object[]{"jobDef", JSON.json((Object)jobDef), "activity", JSON.json((Object)activity)});
    }

    public void statusUpdate(String jobProjectKey, String jobId, CoreJobStatus status) throws APIError.APIErrorException, IOException {
        this.postFormToJSON("/dip/api/tintercom/jobs/status-update", Void.class, new Object[]{"jobProjectKey", jobProjectKey, "jobId", jobId, "status", JSON.json((Object)status)});
    }

    public void emitUserAudit(String jobProjectKey, String jobId, JsonObject obj) throws APIError.APIErrorException, IOException {
        this.postFormToJSON("/dip/api/tintercom/jobs/emit-audit", Void.class, new Object[]{"jobProjectKey", jobProjectKey, "jobId", jobId, "obj", JSON.json((Object)obj)});
    }
}

