/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.utils;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FlowJobUtils {
    private static Logger logger = Logger.getLogger((String)"dku.flow");
    public static String LOCALCONFIG_FOLDER_NAME = "localconfig";
    public static String LOCALCONFIG_ARCHIVE_NAME = "localconfig.zip";

    public static File getJobFile(String subpath, String name) throws IOException {
        JobContext jac = JobContext.getCurrentJobContext();
        File f = null;
        if (jac == null) {
            throw new IOException("No job is running");
        }
        String activity = JobContext.getCurrentActivity();
        f = activity == null ? DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{subpath + "/" + name}) : DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{jac.activity + "/" + subpath + "/" + name});
        DKUFileUtils.mkdirsParent((File)f);
        return f;
    }

    public static File getJobTouchedFile(String subpath, String name) throws IOException {
        File f = FlowJobUtils.getJobFile(subpath, name);
        FileUtils.touch((File)f);
        return f;
    }

    public static File getJobMadeDir(String subpath, String name) throws IOException {
        File f = FlowJobUtils.getJobFile(subpath, name);
        DKUFileUtils.mkdirs((File)f);
        return f;
    }

    public static AutoDelete getJobTempFile(String path, String prefix, String extension) throws IOException {
        JobContext jac = JobContext.getCurrentJobContext();
        File f = null;
        if (jac == null) {
            f = DSSTempUtils.getTempFileNoCreate((String)path, (String)prefix, (String)extension);
        } else {
            String activity = JobContext.getCurrentActivity();
            if (extension != null && extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            f = activity == null ? DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{path + "/" + prefix + SecretKeyGenerator.generate((int)8) + "." + extension}) : DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{jac.activity + "/" + path + "/" + prefix + SecretKeyGenerator.generate((int)8) + "." + extension});
        }
        DKUFileUtils.mkdirsParent((File)f);
        return new AutoDelete(f);
    }

    public static AutoDelete getJobTempFile(String path, String fileName) throws IOException {
        String activity;
        JobContext jac = JobContext.getCurrentJobContext();
        File f = null;
        f = jac == null ? DSSTempUtils.getTempFileNoCreate((String)path, (String)fileName) : ((activity = JobContext.getCurrentActivity()) == null ? DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{path + "/" + fileName}) : DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{jac.activity + "/" + path + "/" + fileName}));
        DKUFileUtils.mkdirsParent((File)f);
        return new AutoDelete(f);
    }

    public static AutoDelete getTmpFolder(String path, String prefix) throws IOException {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null || jac.activity == null) {
            return DSSTempUtils.getTempFolder((String)path, (String)prefix);
        }
        File f = DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{jac.activity + "/" + path + "/" + prefix + SecretKeyGenerator.generate((int)12)});
        DKUFileUtils.mkdirs((File)f);
        return new AutoDelete(f);
    }

    public static File getActivitySubdir(String path) throws IOException {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null || jac.activity == null) {
            throw new IllegalArgumentException("No activity active in thread");
        }
        File f = DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{jac.activity, path});
        DKUFileUtils.mkdirs((File)f);
        return f;
    }

    public static String pathRelativeToActivity(File f) throws IOException {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null || jac.activity == null) {
            throw new IllegalArgumentException("No activity active in thread");
        }
        File activityPath = DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{jac.activity});
        String canonicalActivityPath = activityPath.getCanonicalPath();
        String canonicalFilePath = f.getCanonicalPath();
        if (!canonicalFilePath.startsWith(canonicalActivityPath)) {
            throw new IllegalArgumentException("File path does not start by activity path");
        }
        return canonicalFilePath.substring(canonicalActivityPath.length());
    }

    public static SmartLogTail getSmartLogTail(String tail, String activityId) {
        String[] lines;
        SmartLogTail ret = new SmartLogTail();
        for (String line : lines = tail.split("\n")) {
            if (activityId != null) {
                line = line.replace("starting " + activityId + " ", "");
                line = line.replace("act." + activityId + " ", "");
            }
            ret.appendLine(line);
        }
        return ret;
    }

    public static File jobsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key not specified");
        return ApplicationConfigurator.getFile((String[])new String[]{"jobs", projectKey});
    }

    public static File jobFolder(boolean dryRun, String projectKey, String jobId) {
        if (dryRun) {
            return DKUFileUtils.getWithin((File)FlowJobUtils.jobsFolder(projectKey), (String[])new String[]{"dryruns/" + jobId});
        }
        return DKUFileUtils.getWithin((File)FlowJobUtils.jobsFolder(projectKey), (String[])new String[]{jobId});
    }

    public static File jobLocalConfigFolder(File jobFolder) {
        return new File(jobFolder, LOCALCONFIG_FOLDER_NAME);
    }

    public static File jobLocalConfigArchive(File jobFolder) {
        return new File(jobFolder, LOCALCONFIG_ARCHIVE_NAME);
    }

    public static File jobLocalConfigFolder(boolean dryRun, String projectKey, String jobId) {
        return FlowJobUtils.jobLocalConfigFolder(FlowJobUtils.jobFolder(dryRun, projectKey, jobId));
    }

    public static File jobLocalConfigArchive(boolean dryRun, String projectKey, String jobId) {
        return FlowJobUtils.jobLocalConfigArchive(FlowJobUtils.jobFolder(dryRun, projectKey, jobId));
    }

    public static File jobDefFile(boolean dryRun, String projectKey, String jobId) {
        return new File(FlowJobUtils.jobFolder(dryRun, projectKey, jobId), "job.def");
    }

    public static File jobLogFile(boolean dryRun, String projectKey, String jobId) {
        return new File(FlowJobUtils.jobFolder(dryRun, projectKey, jobId), "log.log");
    }

    public static File jobLogOutputFile(boolean dryRun, String projectKey, String jobId) {
        return new File(FlowJobUtils.jobFolder(dryRun, projectKey, jobId), "output.log");
    }

    public static File jobStatusFile(boolean dryRun, String projectKey, String jobId) {
        return new File(FlowJobUtils.jobFolder(dryRun, projectKey, jobId), "status.json");
    }

    public static List<String> listJobFolders(String projectKey) {
        ArrayList<String> ret = new ArrayList<String>();
        if (FlowJobUtils.jobsFolder(projectKey).isDirectory()) {
            for (File f : FlowJobUtils.jobsFolder(projectKey).listFiles()) {
                if (!new File(f, "job.def").exists()) continue;
                ret.add(f.getName());
            }
        }
        return ret;
    }

    public static File getCurrentJobFolder() {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null) {
            return null;
        }
        return FlowJobUtils.jobFolder(false, jac.projectKey, jac.jobId);
    }

    public static File getCurrentJobActivityFolder() {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null || jac.activity == null) {
            return null;
        }
        return DKUFileUtils.getWithin((File)FlowJobUtils.jobFolder(false, jac.projectKey, jac.jobId), (String[])new String[]{jac.activity});
    }
}

