/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.topn;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datasets.Type;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class TopNer {
    private final TopNRecipePayloadParams params;
    private final File folder;
    private final Sorter.MergeSortParams mergeSortParams;
    private Sorter sorter = null;
    private boolean unlimitedRows;
    private static Logger logger = Logger.getLogger((String)"dip.topner");

    public TopNer(TopNRecipePayloadParams params, File folder, Sorter.MergeSortParams mergeSortParams, boolean unlimitedRows) {
        this.params = params;
        this.folder = folder;
        this.mergeSortParams = mergeSortParams;
        this.unlimitedRows = unlimitedRows;
    }

    public TopNer(TopNRecipePayloadParams params, File folder, Sorter.MergeSortParams mergeSortParams) {
        this(params, folder, mergeSortParams, false);
    }

    public void cancel() throws Exception {
        if (this.sorter != null) {
            this.sorter.cancel();
        }
    }

    public void compute(RowInputStream input, ColumnFactory inputCf, Schema inputSchema, ProcessorOutput outputMain, ColumnFactory outputCfMain, RowFactory outputRfMain, ProcessorOutput outputRejects) throws Exception {
        ArrayList specs = Lists.newArrayList();
        if (this.params.keys != null) {
            for (String key : this.params.keys) {
                specs.add(new Sorter.SortSpec(key, true));
            }
        }
        if (this.params.orders != null) {
            for (TopNRecipePayloadParams.Order order : this.params.orders) {
                specs.add(new Sorter.SortSpec(order.column, !order.desc));
            }
        }
        try (SpilledRowsStorage storage = new SpilledRowsStorage(this.folder, SpilledRowsStorage.factoryColumnsOfSchema(inputCf, inputSchema), this.mergeSortParams);){
            this.sorter = new Sorter(specs, inputSchema, inputCf, storage, outputRfMain, outputCfMain, this.mergeSortParams);
            long totalRowCount = 0L;
            Row row = input.next();
            while (row != null) {
                this.sorter.emitRow(row);
                ++totalRowCount;
                row = input.next();
            }
            this.sorter.lastRowEmitted();
            storage.doneWriting();
            logger.info((Object)"Sort for TopN done, now iterating");
            if (totalRowCount == 0L) {
                return;
            }
            this.iterateOverRows(inputSchema, outputCfMain, outputRfMain, outputMain, outputRejects);
        }
    }

    private void iterateOverRows(Schema inputSchema, ColumnFactory outputCfMain, RowFactory outputRfMain, ProcessorOutput outputMain, ProcessorOutput outputRejects) throws Exception {
        RowsComparator partitionComparator = this.getPartitionComparator(inputSchema, outputCfMain);
        RowsComparator rankComparator = this.getRankComparator(inputSchema, outputCfMain);
        SortedRowsIterator partitionPosition = this.sorter.read();
        SortedRowsIterator topnPosition = this.sorter.read();
        TopNPartition topnPartition = this.advancePartition(partitionPosition, partitionPosition.next(), partitionComparator);
        long partitionCount = 0L;
        long currentIndex = 0L;
        while (topnPartition != null && topnPartition.first != null && topnPartition.last != null) {
            ++partitionCount;
            long duplicateCountValue = 1L + topnPartition.last.mark.index - topnPartition.first.mark.index;
            if (duplicateCountValue > 100000L) {
                logger.info((Object)("Distinct on parition [" + topnPartition.first.mark.index + ", " + topnPartition.last.mark.index + "]"));
            } else if (partitionCount % 1000L == 0L) {
                logger.info((Object)("Distincted " + topnPartition.last.mark.index + " rows into " + partitionCount + " partitions"));
            }
            long rowNumberValue = 0L;
            long rankValue = 0L;
            long rankRetention = 0L;
            long denseRankValue = 0L;
            RowAndSortMark previousRowAndMark = null;
            while (topnPosition.hasNext() && currentIndex <= topnPartition.last.mark.index) {
                RowAndSortMark rowAndMark = topnPosition.next();
                ++rowNumberValue;
                if (previousRowAndMark == null) {
                    ++rankValue;
                    rankRetention = 0L;
                    ++denseRankValue;
                } else {
                    boolean sameRow;
                    boolean bl = sameRow = rankComparator.compare(previousRowAndMark.row, rowAndMark.row) == 0;
                    if (!sameRow) {
                        rankValue += rankRetention + 1L;
                        ++denseRankValue;
                        rankRetention = 0L;
                    } else {
                        ++rankRetention;
                    }
                }
                Row outputRow = this.getOutputRow(outputCfMain, outputRfMain, rowAndMark, duplicateCountValue, rowNumberValue, rankValue, denseRankValue);
                if (this.unlimitedRows || currentIndex < topnPartition.first.mark.index + (long)this.params.firstRows || currentIndex > topnPartition.last.mark.index - (long)this.params.lastRows) {
                    outputMain.emitRow(outputRow);
                } else if (outputRejects != null) {
                    outputRejects.emitRow(outputRow);
                }
                previousRowAndMark = rowAndMark;
                ++currentIndex;
            }
            topnPartition = this.advancePartition(partitionPosition, topnPartition.next, partitionComparator);
        }
    }

    private Row getOutputRow(ColumnFactory outputCfMain, RowFactory outputRfMain, RowAndSortMark rowAndMark, long duplicateCountValue, long rowNumberValue, long rankValue, long denseRankValue) {
        Row outputRow = outputRfMain.row();
        for (Column col : outputCfMain.columns()) {
            if (this.params.retrievedColumnsSelectionMode != TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL && !this.params.retrievedColumns.contains(col.getName())) continue;
            outputRow.with(outputCfMain, col.getName(), rowAndMark.row.row.get(col));
        }
        if (this.params.duplicateCount) {
            outputRow.put(outputCfMain.column("_duplicate_count"), duplicateCountValue);
        }
        if (this.params.rowNumber) {
            outputRow.put(outputCfMain.column("_row_number"), rowNumberValue);
        }
        if (this.params.rank) {
            outputRow.put(outputCfMain.column("_rank"), rankValue);
        }
        if (this.params.denseRank) {
            outputRow.put(outputCfMain.column("_dense_rank"), denseRankValue);
        }
        return outputRow;
    }

    public Schema getOutputSchema(Schema inputSchema) {
        Schema outputSchema = new Schema();
        for (SchemaColumn sc : inputSchema.getColumns()) {
            if (this.params.retrievedColumnsSelectionMode != TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL && !this.params.retrievedColumns.contains(sc.getName())) continue;
            outputSchema.addColumn(sc);
        }
        if (this.params.duplicateCount) {
            outputSchema.addColumn(outputSchema.transmogrify("_duplicate_count"), Type.BIGINT);
        }
        if (this.params.rowNumber) {
            outputSchema.addColumn(outputSchema.transmogrify("_row_number"), Type.BIGINT);
        }
        if (this.params.rank) {
            outputSchema.addColumn(outputSchema.transmogrify("_rank"), Type.BIGINT);
        }
        if (this.params.denseRank) {
            outputSchema.addColumn(outputSchema.transmogrify("_dense_rank"), Type.BIGINT);
        }
        return outputSchema;
    }

    private RowsComparator getPartitionComparator(Schema inputSchema, ColumnFactory outputCfMain) {
        ArrayList partitionSpecs = Lists.newArrayList();
        if (this.params.keys != null) {
            for (String key : this.params.keys) {
                Sorter.SortSpec spec = new Sorter.SortSpec(key, true);
                spec.schemaColumn = inputSchema.getColumn(key);
                spec.factoryColumn = outputCfMain.column(key);
                partitionSpecs.add(spec);
            }
        }
        return partitionSpecs.isEmpty() ? null : new RowsComparator(partitionSpecs, RowsComparator.NullsOrdering.AUTO);
    }

    private RowsComparator getRankComparator(Schema inputSchema, ColumnFactory outputCfMain) {
        Sorter.SortSpec spec;
        ArrayList rankSpecs = Lists.newArrayList();
        if (this.params.keys != null) {
            for (String key : this.params.keys) {
                spec = new Sorter.SortSpec(key, true);
                spec.schemaColumn = inputSchema.getColumn(key);
                spec.factoryColumn = outputCfMain.column(key);
                rankSpecs.add(spec);
            }
        }
        if (this.params.orders != null) {
            for (TopNRecipePayloadParams.Order order : this.params.orders) {
                spec = new Sorter.SortSpec(order.column, !order.desc);
                spec.schemaColumn = inputSchema.getColumn(order.column);
                spec.factoryColumn = outputCfMain.column(order.column);
                rankSpecs.add(spec);
            }
        }
        return new RowsComparator(rankSpecs, RowsComparator.NullsOrdering.AUTO);
    }

    private TopNPartition advancePartition(SortedRowsIterator partitionPosition, RowAndSortMark first, Comparator<NumberedRow> partitionComparator) throws IOException {
        RowAndSortMark last = first;
        RowAndSortMark next = null;
        boolean gotDifference = false;
        while (partitionPosition.hasNext()) {
            next = partitionPosition.next();
            if (partitionComparator == null || partitionComparator.compare(first.row, next.row) == 0) {
                last = next;
                continue;
            }
            gotDifference = true;
            break;
        }
        if (!gotDifference && !partitionPosition.hasNext()) {
            next = null;
        }
        TopNPartition position = new TopNPartition();
        position.first = first;
        position.last = last;
        position.next = next;
        return position;
    }

    class TopNPartition {
        RowAndSortMark first;
        RowAndSortMark last;
        RowAndSortMark next;

        TopNPartition() {
        }
    }
}

