/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.window.RowsDeltaWindowSlider;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.Hours;
import com.dataiku.dss.shadelib.org.joda.time.Minutes;
import com.dataiku.dss.shadelib.org.joda.time.Months;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.Weeks;
import com.dataiku.dss.shadelib.org.joda.time.Years;
import org.apache.commons.lang.StringUtils;

public class LagDiffAggregation
extends WindowAggregation {
    public final Date dateMeaning = new Date();
    private static final DateOnly dateOnlyMeaning = new DateOnly();
    private static final DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private final RowsDeltaWindowSlider slider;
    private final Type type;
    private final WindowRecipePayloadParams.DateDiffUnit dateDiffUnit;

    private static SchemaColumn makeDiffOutputSchemaColumn(String name, Type type) {
        if (type == Type.BOOLEAN) {
            return new SchemaColumn(name, Type.TINYINT);
        }
        return new SchemaColumn(name, type);
    }

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return LagDiffAggregation.makeDiffOutputSchemaColumn(name, schemaColumn.getType());
    }

    public LagDiffAggregation(Column column, Column result, SchemaColumn schemaColumn, RowsDeltaWindowSlider slider, WindowRecipePayloadParams.DateDiffUnit dateDiffUnit) {
        super(column, result, schemaColumn, LagDiffAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        this.slider = slider;
        WindowRecipePayloadParams.DateDiffUnit dateDiffUnit2 = this.dateDiffUnit = dateDiffUnit == null ? WindowRecipePayloadParams.DateDiffUnit.DAY : dateDiffUnit;
        if (schemaColumn.getType().isNumeric()) {
            this.type = schemaColumn.getType().isFloatingPoint() ? Type.DOUBLE : Type.BIGINT;
        } else if (schemaColumn.getType() == Type.DATE || schemaColumn.getType() == Type.DATEONLY || schemaColumn.getType() == Type.DATETIMENOTZ) {
            this.type = schemaColumn.getType();
        } else if (schemaColumn.getType() == Type.BOOLEAN) {
            this.type = Type.BOOLEAN;
        } else {
            throw new NotImplementedException("Cannot diff " + String.valueOf(schemaColumn.getType()));
        }
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void expandInternal(Object value) {
    }

    @Override
    public void shrinkInternal(Object value) {
    }

    @Override
    public Object produceValueInternal() {
        throw new RuntimeException("unreachable");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void produceValue(Row row) {
        RowAndSortMark slided = this.slider.current();
        if (slided != null) {
            if (this.type.isTemporal()) {
                String vx = row.get(this.column);
                String vy = slided.row.row.get(this.column);
                if (StringUtils.isBlank((String)vx) || StringUtils.isBlank((String)vy)) {
                    row.put(this.result, null);
                    return;
                } else {
                    long mssy;
                    long mssx;
                    if (this.type == Type.DATE) {
                        mssx = this.dateMeaning.msSinceEpoch(vx);
                        mssy = this.dateMeaning.msSinceEpoch(vy);
                    } else if (this.type == Type.DATEONLY) {
                        mssx = dateOnlyMeaning.msSinceEpoch(vx);
                        mssy = dateOnlyMeaning.msSinceEpoch(vy);
                    } else if (this.type == Type.DATETIMENOTZ) {
                        mssx = datetimeNoTzMeaning.msSinceEpoch(vx);
                        mssy = datetimeNoTzMeaning.msSinceEpoch(vy);
                    } else {
                        mssx = 0L;
                        mssy = 0L;
                    }
                    DateTime dx = new DateTime(mssx);
                    DateTime dy = new DateTime(mssy);
                    if (this.dateDiffUnit == WindowRecipePayloadParams.DateDiffUnit.HOUR) {
                        row.put(this.result, Hours.hoursBetween((ReadableInstant)dy, (ReadableInstant)dx).getHours());
                        return;
                    } else if (this.dateDiffUnit == WindowRecipePayloadParams.DateDiffUnit.DAY) {
                        row.put(this.result, Days.daysBetween((ReadableInstant)dy, (ReadableInstant)dx).getDays());
                        return;
                    } else if (this.dateDiffUnit == WindowRecipePayloadParams.DateDiffUnit.MINUTE) {
                        row.put(this.result, Minutes.minutesBetween((ReadableInstant)dy, (ReadableInstant)dx).getMinutes());
                        return;
                    } else if (this.dateDiffUnit == WindowRecipePayloadParams.DateDiffUnit.MONTH) {
                        row.put(this.result, Months.monthsBetween((ReadableInstant)dy, (ReadableInstant)dx).getMonths());
                        return;
                    } else if (this.dateDiffUnit == WindowRecipePayloadParams.DateDiffUnit.WEEK) {
                        row.put(this.result, Weeks.weeksBetween((ReadableInstant)dy, (ReadableInstant)dx).getWeeks());
                        return;
                    } else if (this.dateDiffUnit == WindowRecipePayloadParams.DateDiffUnit.YEAR) {
                        row.put(this.result, Years.yearsBetween((ReadableInstant)dy, (ReadableInstant)dx).getYears());
                        return;
                    } else {
                        if (this.dateDiffUnit != WindowRecipePayloadParams.DateDiffUnit.SECOND) return;
                        row.put(this.result, (mssx - mssy) / 1000L);
                    }
                }
                return;
            } else {
                Object x = this.valueReader.read(row);
                Object y = this.valueReader.read(slided.row.row);
                if (x == null || y == null) {
                    row.put(this.result, null);
                    return;
                } else if (x instanceof Double) {
                    row.put(this.result, (Double)x - (Double)y);
                    return;
                } else if (x instanceof Long) {
                    row.put(this.result, (Long)x - (Long)y);
                    return;
                } else {
                    if (!(x instanceof Boolean)) throw new RuntimeException("unreachable");
                    int ix = (Boolean)x != false ? 1 : 0;
                    int iy = (Boolean)y != false ? 1 : 0;
                    row.put(this.result, ix - iy);
                }
            }
            return;
        } else {
            row.put(this.result, null);
        }
    }
}

