/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DynamoDBDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    private DynamoDBDatasetHandler handler;
    private AuthCtx authCtx;
    private static final Pattern startWithAlphanumOrUnderscore = Pattern.compile("^[a-zA-Z_]{1}");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb");

    public DynamoDBDatasetTestHandler(AuthCtx authCtx, DynamoDBDatasetHandler handler) {
        this.authCtx = authCtx;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    public TestResult test(String projectKey, Dataset dataset, boolean connectionOnly, boolean forConsistencyCheck, boolean inferStorageTypes, boolean listTables) throws Exception {
        assert (DynamoDBDatasetHandler.META.getType().equals(dataset.getType()));
        logger.info((Object)("Testing, dataset = " + dataset.getName() + " connectionOnly = " + connectionOnly));
        TestResult result = new TestResult();
        result.testedConnectionOnly = true;
        try (DatasetHandler dhForName = DatasetHandlerFactory.build(this.authCtx, dataset);){
            result.suggestedName = DatasetInspector.slufigyAndUnicize(projectKey, dhForName.suggestName(), this.dao, this.transactionService);
        }
        DynamoDBDatasetHandler.Config config = dataset.getParamsAs(DynamoDBDatasetHandler.Config.class);
        if (StringUtils.isBlank((String)config.connection)) {
            throw new IllegalArgumentException("Missing connection name");
        }
        if (StringUtils.isBlank((String)config.table) && dataset.isManaged()) {
            throw new IllegalArgumentException("Missing table name");
        }
        try (DynamoDBConnectionWrapper dynamoConn = DynamoDBConnectionWrapper.get(this.authCtx, config.connection);){
            if (!dataset.isManaged() && listTables) {
                result.tablesList = new ArrayList<String>(dynamoConn.client.listTables().tableNames());
            } else {
                dynamoConn.testConnection();
            }
            if (StringUtils.isNotBlank((String)config.table)) {
                dynamoConn.client.describeTable(builder -> builder.tableName(config.table));
                result.tableExists = true;
            }
            result.connectionOK = true;
        }
        catch (DynamoDbException e) {
            result.connectionErrorMsg = e.getMessage();
            logger.warn((Object)("Server connection error for connection " + config.connection + " : " + String.valueOf((Object)e)));
            return result;
        }
        if (connectionOnly || !result.tableExists) {
            return result;
        }
        result.testedConnectionOnly = false;
        logger.info((Object)"Gathering table preview");
        try {
            Pair<SchemaDetection.SchemaDetectionResult, MemTable> res = null;
            res = inferStorageTypes ? DatasetUtils.detectSchemaWithStorageTypeInference(this.authCtx, dataset, forConsistencyCheck) : DatasetUtils.simpleDetectSchema(this.authCtx, dataset, forConsistencyCheck);
            ((SchemaDetection.SchemaDetectionResult)res.first).makesSenseToInferStorageTypes = true;
            result.schemaDetection = (SchemaDetection.SchemaDetectionResult)res.first;
            SerializedMemTableSimple smt = new SerializedMemTableSimple();
            smt.fromMemTable((MemTable)res.second, 0, ((MemTable)res.second).nrows());
            result.preview = smt;
        }
        catch (DynamoDbException e) {
            logger.warn((Object)("Error getting preview for table " + config.table + " : " + String.valueOf((Object)e)));
            result.previewErrorMsg = e.getMessage();
        }
        return result;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (StringUtils.isBlank((String)newDatasetName)) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name is empty");
            return ret;
        }
        if (newDatasetName.contains("$")) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name should not contain '$'");
        }
        if (newDatasetName.contains("\u0000")) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name should not contain a null character");
        }
        if (!startWithAlphanumOrUnderscore.matcher(newDatasetName).find()) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should start with a letter or '_'");
        }
        return ret;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        TestResult result = this.test(this.handler.getDataset().getProjectKey(), this.handler.getDataset(), false, true, false, false);
        ret.empty = !result.tableExists;
        ret.result = result.schemaDetection;
        return ret;
    }

    public static class TestResult {
        public boolean testedConnectionOnly;
        public String suggestedName;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public boolean tableExists;
        public List<String> tablesList;
        public String previewErrorMsg;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
        public SerializedMemTableSimple preview;
    }
}

