/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

class BlobLikeSingleFileOutputWriter
extends OutputStreamOutputWriter {
    private String path;
    private BlobLikeFSProvider provider;

    public BlobLikeSingleFileOutputWriter(AuthCtx authCtx, String projectKey, BlobLikeFSProvider provider, String path, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, Output.WriteMode writeMode, String compress) throws IOException, CodedException, DKUSecurityException {
        super(BlobLikeSingleFileOutputWriter.getOutputStream(provider, path, compress), BlobLikeSingleFileOutputWriter.getFormatter(authCtx, projectKey, formatType, formatParams, schema, warningsContext));
        this.path = path;
        this.provider = provider;
    }

    private static OutputFormatter getFormatter(AuthCtx authCtx, String projectKey, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext) {
        OutputFormatter formatter = FormatFactory.buildFormatter(authCtx, projectKey, formatType, formatParams);
        formatter.setOutputSchema(schema);
        if (warningsContext != null) {
            formatter.setWarningsContext(warningsContext);
        }
        return formatter;
    }

    private static OutputStream getOutputStream(BlobLikeFSProvider provider, String path, String compress) throws IOException, CodedException, DKUSecurityException {
        OutputStream os = provider.write(path);
        if ("gz".equals(compress)) {
            os = new GZIPOutputStream(os);
        }
        return os;
    }

    public void lastRowEmitted() throws Exception {
        super.lastRowEmitted();
        this.provider.waitUntilReadable(this.path);
    }
}

