/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.HTTPSourceException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpHead;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.conn.ConnectionReleaseTrigger;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.cookie.DateParseException;
import com.dataiku.dss.shadelib.org.apache.http.impl.cookie.DateUtils;
import com.google.common.collect.Maps;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HTTPFSProvider
implements FSProvider {
    final DefaultHttpClient httpClient;
    final String base;
    final ProxySettings proxySettings;
    final AuthCtx authCtx;
    final boolean consider404AsEmpty;
    final boolean fallbackHeadToGet;
    final boolean trustAnySSLCertificate;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.http");

    public HTTPFSProvider(AuthCtx authCtx, String base, boolean consider404AsEmpty, boolean fallbackHeadToGet, boolean trustAnySSLCertificate, ProxySettings proxySettings) {
        this.authCtx = authCtx;
        this.consider404AsEmpty = consider404AsEmpty;
        this.fallbackHeadToGet = fallbackHeadToGet;
        this.trustAnySSLCertificate = trustAnySSLCertificate;
        this.base = this.cleanBase(base);
        this.proxySettings = proxySettings;
        PoolingClientConnectionManager connectionManager = this.trustAnySSLCertificate ? new PoolingClientConnectionManager(ConnectionUtils.getNonValidatingSchemeRegistry()) : new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(100);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (DefaultHttpClient)this.httpClient);
        this.httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategyWithIPBlacklist(proxySettings));
        this.httpClient.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
    }

    private String cleanBase(String base) {
        String cleanBase;
        String string = cleanBase = base == null ? "" : base;
        while (cleanBase.endsWith("/")) {
            cleanBase = cleanBase.substring(0, cleanBase.length() - 1);
        }
        return cleanBase;
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        ret.put("base", this.base);
        if (withSensitiveInfo) {
            ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (Map)ret);
        }
        return ret;
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException {
        FSBrowsePath ret = new FSBrowsePath();
        if (strategy == FSProvider.FSBrowseStrategy.DIRECTORY) {
            return ret;
        }
        Object lsPath = path.startsWith("/") ? path : "/" + path;
        String uri = this.getPath((String)lsPath);
        ret.fullPath = lsPath;
        ret.directory = false;
        for (String chunk : path.split("/+")) {
            if (chunk.length() <= 0) continue;
            ret.pathElts.add(chunk);
            ret.name = HTTPClientUtils.makeFileNameFromChunk((String)chunk);
        }
        HttpResponse response = this.getResponseForHeadersWithHEADorGET(uri);
        if (response == null) {
            ret.exists = false;
        } else {
            ret.exists = true;
            ret.size = this.tryGetSizeFromHeaders(response);
            ret.lastModified = HTTPFSProvider.tryGetLastModifiedFromHeaders(response);
        }
        return ret;
    }

    private long tryGetSizeFromHeaders(HttpResponse response) {
        Header sizeHeader = response.getLastHeader("Content-Length");
        if (sizeHeader != null) {
            try {
                return Long.parseLong(sizeHeader.getValue());
            }
            catch (NumberFormatException ignored) {
                return -1L;
            }
        }
        return -1L;
    }

    private static long tryGetLastModifiedFromHeaders(HttpResponse response) {
        Date lastModified = null;
        Header lastModifiedHeader = response.getLastHeader("Last-Modified");
        if (lastModifiedHeader != null) {
            try {
                lastModified = DateUtils.parseDate((String)lastModifiedHeader.getValue());
            }
            catch (DateParseException ignored) {
                lastModified = null;
            }
        }
        return lastModified == null ? -1L : lastModified.getTime();
    }

    private HttpResponse getResponseForHeadersWithHEADorGET(String uri) throws IOException {
        IPBlacklistVerifier.validateUriNotBlacklisted(uri, this.proxySettings);
        try {
            return this.execute((HttpUriRequest)new HttpHead(uri), (HttpClient)this.httpClient, true);
        }
        catch (HTTPSourceException e) {
            if (this.fallbackHeadToGet) {
                logger.warn((Object)"HEAD method not working, trying GET", (Throwable)((Object)e));
                HttpGet get = new HttpGet(uri);
                get.addHeader("Content-Range", "bytes=0-0");
                return this.execute((HttpUriRequest)get, (HttpClient)this.httpClient, true);
            }
            throw e;
        }
    }

    public HTTPFSEnumerationResult enumerateRecursive(String path, FSEnumerationSettings enumerationSettings) {
        HttpResponse response;
        String uri = this.getPath(path);
        logger.info((Object)("Enumerate HTTP URI: " + uri));
        try {
            response = this.getResponseForHeadersWithHEADorGET(uri);
        }
        catch (IOException e) {
            logger.error((Object)"Enumeration failed", (Throwable)e);
            return HTTPFSEnumerationResult.fromError(e);
        }
        if (response == null) {
            logger.info((Object)"Response null, non existing URI");
            return HTTPFSEnumerationResult.fromNonExistingURI();
        }
        long lastModified = HTTPFSProvider.tryGetLastModifiedFromHeaders(response);
        long size = this.tryGetSizeFromHeaders(response);
        return HTTPFSEnumerationResult.fromPaths(new FSPath((String)(path.startsWith("/") ? path : "/" + path), size, lastModified));
    }

    public FSPathOrDirectory stat(String path) throws IOException {
        HTTPFSEnumerationResult res = this.enumerateRecursive(path, new FSEnumerationSettings());
        if (!res.isSuccessful()) {
            if (res.getError() != null) {
                throw (IOException)res.getError();
            }
            return null;
        }
        if (res.getPaths() == null) {
            return null;
        }
        Iterator<FSPath> pathIterator = res.getPaths().iterator();
        if (!pathIterator.hasNext()) {
            return null;
        }
        FSPath resPath = pathIterator.next();
        return new FSPathOrDirectory(resPath.path(), resPath.getSize(), resPath.getLastModified(), false);
    }

    public HTTPEnrichedInputStream read(String path) throws CodedIOException {
        String uri = this.getPath(path);
        DefaultHttpClient client = this.trustAnySSLCertificate ? ConnectionUtils.newNonValidatingHttpClient() : new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (DefaultHttpClient)client);
        client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategyWithIPBlacklist(this.proxySettings));
        IPBlacklistVerifier.validateUriNotBlacklisted(uri, this.proxySettings);
        HttpResponse response = this.execute((HttpUriRequest)new HttpGet(uri), (HttpClient)client, false);
        return new HTTPEnrichedInputStream(response, path, uri, client);
    }

    private String getPath(String path) {
        if (this.base.isEmpty()) {
            if (path.matches("(?i)https?://.+")) {
                return path;
            }
            return (path.startsWith("//") ? "http:" : "http://") + path;
        }
        return this.base + (String)(path.startsWith("/") ? path : "/" + path);
    }

    private HttpResponse execute(HttpUriRequest request, HttpClient client, boolean can404) throws CodedIOException {
        HttpResponse response;
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            if (e instanceof ConnectException || e instanceof UnknownHostException) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_HTTP_CONNECTION_FAILED, "Connection to " + request.getURI().getHost() + ":" + request.getURI().getPort() + " failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_HTTP_REQUEST_FAILED, request.getMethod() + " request to " + String.valueOf(request.getURI()) + " failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        logger.debug((Object)("HTTP response code: " + response.getStatusLine().getStatusCode()));
        switch (response.getStatusLine().getStatusCode()) {
            case 404: {
                if (!this.consider404AsEmpty || !can404) {
                    throw new HTTPSourceException(response.getStatusLine());
                }
                return null;
            }
            case 200: 
            case 204: 
            case 301: 
            case 302: 
            case 304: {
                return response;
            }
        }
        throw new HTTPSourceException(response.getStatusLine());
    }

    public OutputStream write(String path) throws IOException {
        throw new UnsupportedOperationException("Write on HTTP is not supported");
    }

    public void setLastModified(String path, long lastModified) throws IOException {
        throw new UnsupportedOperationException("Set last modified on HTTP is not supported");
    }

    public void deleteRecursive(String path) throws IOException {
        throw new UnsupportedOperationException("Write on HTTP is not supported");
    }

    public boolean deleteFile(String path) throws IOException {
        throw new UnsupportedOperationException("Write on HTTP is not supported");
    }

    public boolean deleteDirectory(String path) throws IOException {
        throw new UnsupportedOperationException("Write on HTTP is not supported");
    }

    public void moveDirectory(String from, String to) throws IOException {
        throw new UnsupportedOperationException("Write on HTTP is not supported");
    }

    public void moveFile(String path, String newName) throws IOException {
        throw new UnsupportedOperationException("Write on HTTP is not supported");
    }

    public void close() throws IOException {
        this.httpClient.getConnectionManager().shutdown();
    }

    static class HTTPFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public HTTPFSEnumerationResult() {
        }

        public HTTPFSEnumerationResult(FSPath ... paths) {
            super(Arrays.asList(paths));
        }

        public HTTPFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static HTTPFSEnumerationResult fromError(Throwable error) {
            return new HTTPFSEnumerationResult(error);
        }

        private static HTTPFSEnumerationResult fromPaths(FSPath ... paths) {
            return new HTTPFSEnumerationResult(paths);
        }

        private static HTTPFSEnumerationResult fromNonExistingURI() {
            return new HTTPFSEnumerationResult();
        }
    }

    public static class HTTPEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final HttpResponse response;
        private final DefaultHttpClient httpClient;

        public HTTPEnrichedInputStream(HttpResponse response, String pathWithinProvider, String uri, DefaultHttpClient httpClient) {
            super(response.getEntity().getContentLength(), pathWithinProvider, HTTPClientUtils.getFileName((String)uri, (HttpResponse)response, (boolean)true), uri, () -> HTTPFSProvider.tryGetLastModifiedFromHeaders(response));
            this.response = response;
            this.httpClient = httpClient;
        }

        protected InputStream getBasicInputStream() throws IOException {
            InputStream in = this.response.getEntity().getContent();
            return new FilterInputStream(in){
                private boolean closed;
                {
                    super(in);
                    this.closed = false;
                }

                @Override
                public void close() throws IOException {
                    try {
                        if (!this.closed && this.in instanceof ConnectionReleaseTrigger) {
                            ((ConnectionReleaseTrigger)this.in).abortConnection();
                            this.closed = true;
                        }
                        super.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error closing input stream", (Throwable)e);
                    }
                    finally {
                        httpClient.getConnectionManager().shutdown();
                    }
                }
            };
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException {
            return this.getBasicInputStream();
        }
    }
}

