/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DirectoryAwareFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.SharePointOnlineDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesUtils;
import java.io.IOException;
import javax.annotation.Nullable;

public class SharePointOnlineDatasetHandler
extends DirectoryAwareFSDatasetHandler<BuiltinFSDatasets.SharePointOnlineDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler {
    private final PasswordEncryptionService symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sharepointonline");

    public SharePointOnlineDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        ((BuiltinFSDatasets.SharePointOnlineDatasetConfig)this.resolvedConfig).container = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.SharePointOnlineDatasetConfig)this.resolvedConfig).container);
        logger.info((Object)("Building Sharepoint handler config: " + JSON.json((Object)this.resolvedConfig)));
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(@Nullable String path) throws IOException, CodedException, DKUSecurityException {
        String providerPath = path == null ? ((BuiltinFSDatasets.SharePointOnlineDatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("SharePointOnline", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    protected SharePointOnlineConnection getConnection() throws IOException, DKUSecurityException {
        SharePointOnlineConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.SharePointOnlineDatasetConfig)this.resolvedConfig).connection, SharePointOnlineConnection.class);
        connection.decryptFields(this.symetricCryptoService);
        return connection;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.SHAREPOINTONLINE_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        logger.info((Object)"SharePointOnlineDatasetHandler:buildTestHandler");
        return new SharePointOnlineDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }
}

